"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultServerMeta = void 0;
function getDefaultServerMeta(id, version, options) {
    const servMeta = {
        meta: {
            version: '1.0.0',
            name: `${id} (Minecraft ${version})`,
            description: `${id} Running Minecraft ${version}`,
            address: 'localhost:25565',
            discord: {
                shortId: '<FILL IN OR REMOVE DISCORD OBJECT>',
                largeImageText: '<FILL IN OR REMOVE DISCORD OBJECT>',
                largeImageKey: '<FILL IN OR REMOVE DISCORD OBJECT>'
            },
            mainServer: false,
            autoconnect: false
        }
    };
    if (options?.forgeVersion) {
        servMeta.meta.description = `${servMeta.meta.description} (Forge v${options.forgeVersion})`;
        servMeta.forge = {
            version: options.forgeVersion
        };
    }
    // Add empty untracked files.
    servMeta.untrackedFiles = [];
    return servMeta;
}
exports.getDefaultServerMeta = getDefaultServerMeta;
//# sourceMappingURL=servermeta.js.map