"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToggleableModuleStructure = exports.ToggleableNamespace = void 0;
const Module_struct_1 = require("./Module.struct");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
var ToggleableNamespace;
(function (ToggleableNamespace) {
    ToggleableNamespace["REQUIRED"] = "required";
    ToggleableNamespace["OPTIONAL_ON"] = "optionalon";
    ToggleableNamespace["OPTIONAL_OFF"] = "optionaloff";
})(ToggleableNamespace = exports.ToggleableNamespace || (exports.ToggleableNamespace = {}));
class ToggleableModuleStructure extends Module_struct_1.ModuleStructure {
    constructor(absoluteRoot, relativeRoot, structRoot, baseUrl, minecraftVersion, type, untrackedFiles, filter) {
        super(absoluteRoot, relativeRoot, structRoot, baseUrl, minecraftVersion, type, untrackedFiles, filter);
    }
    async init() {
        await super.init();
        for (const namespace of Object.values(ToggleableNamespace)) {
            await (0, fs_extra_1.mkdirs)((0, path_1.resolve)(this.containerDirectory, namespace));
        }
    }
    async getSpecModel() {
        if (this.resolvedModels == null) {
            const moduleCandidates = [];
            for (const value of Object.values(ToggleableNamespace)) {
                moduleCandidates.push(...(await super._doModuleDiscovery((0, path_1.resolve)(this.containerDirectory, value))).map(val => ({ ...val, namespace: value })));
            }
            this.resolvedModels = await this._doModuleRetrieval(moduleCandidates, {
                preProcess: (candidate) => {
                    this.activeNamespace = candidate.namespace;
                },
                postProcess: (module) => {
                    this.getNamespaceMapper(this.activeNamespace)(module);
                }
            });
            // Cleanup
            this.activeNamespace = undefined;
        }
        return this.resolvedModels;
    }
    getActiveNamespace() {
        return this.activeNamespace || '';
    }
    getNamespaceMapper(namespace) {
        switch (namespace) {
            case ToggleableNamespace.REQUIRED:
                return () => { };
            case ToggleableNamespace.OPTIONAL_ON:
                return (x) => { x.required = { value: false }; };
            case ToggleableNamespace.OPTIONAL_OFF:
                return (x) => { x.required = { value: false, def: false }; };
        }
    }
}
exports.ToggleableModuleStructure = ToggleableModuleStructure;
//# sourceMappingURL=ToggleableModule.struct.js.map