"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiscFileStructure = void 0;
const helios_distribution_types_1 = require("helios-distribution-types");
const url_1 = require("url");
const Module_struct_1 = require("./Module.struct");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
class MiscFileStructure extends Module_struct_1.ModuleStructure {
    constructor(absoluteRoot, relativeRoot, baseUrl, minecraftVersion, untrackedFiles) {
        super(absoluteRoot, relativeRoot, 'files', baseUrl, minecraftVersion, helios_distribution_types_1.Type.File, untrackedFiles);
    }
    getLoggerName() {
        return 'MiscFileStructure';
    }
    async getSpecModel() {
        if (this.resolvedModels == null) {
            this.resolvedModels = await this.recursiveModuleScan(this.containerDirectory);
        }
        return this.resolvedModels;
    }
    async recursiveModuleScan(dir) {
        let acc = [];
        const subdirs = await (0, fs_extra_1.readdir)(dir);
        for (const file of subdirs) {
            const filePath = (0, path_1.resolve)(dir, file);
            const stats = await (0, fs_extra_1.stat)(filePath);
            if (stats.isDirectory()) {
                acc = acc.concat(await this.recursiveModuleScan(filePath));
            }
            else {
                if (!this.FILE_NAME_BLACKLIST.includes(file)) {
                    acc.push(await this.parseModule(file, filePath, stats));
                }
            }
        }
        return acc;
    }
    async getModuleId(name, path) {
        return name;
    }
    async getModuleName(name, path) {
        return name;
    }
    async getModuleUrl(name, path, stats) {
        return new url_1.URL((0, path_1.join)(this.relativeRoot, ...path.substr(this.containerDirectory.length + 1).split(path_1.sep)), this.baseUrl).toString();
    }
    async getModulePath(name, path, stats) {
        return path.substr(this.containerDirectory.length + 1).replace(/\\/g, '/');
    }
}
exports.MiscFileStructure = MiscFileStructure;
//# sourceMappingURL=File.struct.js.map