"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepoStructure = void 0;
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const BaseFileStructure_1 = require("../BaseFileStructure");
const LibRepo_struct_1 = require("./LibRepo.struct");
const VersionRepo_struct_1 = require("./VersionRepo.struct");
class RepoStructure extends BaseFileStructure_1.BaseFileStructure {
    constructor(absoluteRoot, relativeRoot) {
        super(absoluteRoot, relativeRoot, 'repo');
        this.libRepoStruct = new LibRepo_struct_1.LibRepoStructure(this.containerDirectory, this.relativeRoot);
        this.versionRepoStruct = new VersionRepo_struct_1.VersionRepoStructure(this.containerDirectory, this.relativeRoot);
    }
    getLoggerName() {
        return 'RepoStructure';
    }
    async init() {
        super.init();
        await this.libRepoStruct.init();
        await this.versionRepoStruct.init();
        await (0, fs_extra_1.mkdirs)(this.getCacheDirectory());
    }
    getLibRepoStruct() {
        return this.libRepoStruct;
    }
    getVersionRepoStruct() {
        return this.versionRepoStruct;
    }
    getTempDirectory() {
        return (0, path_1.join)(this.absoluteRoot, 'temp');
    }
    getWorkDirectory() {
        return (0, path_1.join)(this.absoluteRoot, 'work');
    }
    getCacheDirectory() {
        return (0, path_1.join)(this.absoluteRoot, 'cache');
    }
    getForgeCacheDirectory(artifactVersion) {
        return (0, path_1.join)(this.getCacheDirectory(), 'forge', artifactVersion);
    }
}
exports.RepoStructure = RepoStructure;
//# sourceMappingURL=Repo.struct.js.map