"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseForgeModStructure = void 0;
const helios_distribution_types_1 = require("helios-distribution-types");
const path_1 = require("path");
const url_1 = require("url");
const ToggleableModule_struct_1 = require("./ToggleableModule.struct");
const ClaritasLibraryType_1 = require("../../../model/claritas/ClaritasLibraryType");
class BaseForgeModStructure extends ToggleableModule_struct_1.ToggleableModuleStructure {
    constructor(absoluteRoot, relativeRoot, baseUrl, minecraftVersion, untrackedFiles) {
        super(absoluteRoot, relativeRoot, 'forgemods', baseUrl, minecraftVersion, helios_distribution_types_1.Type.ForgeMod, untrackedFiles);
        this.EXAMPLE_MOD_ID = 'examplemod';
    }
    async getSpecModel() {
        // Sort by file name to allow control of load order.
        return (await super.getSpecModel()).sort((a, b) => {
            const aFileName = a.artifact.url.substring(a.artifact.url.lastIndexOf('/') + 1);
            const bFileName = b.artifact.url.substring(b.artifact.url.lastIndexOf('/') + 1);
            return aFileName.localeCompare(bFileName);
        });
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModuleUrl(name, path, stats) {
        return new url_1.URL((0, path_1.join)(this.relativeRoot, this.getActiveNamespace(), name), this.baseUrl).toString();
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModulePath(name, path, stats) {
        return null;
    }
    getClaritasExceptions() {
        return [{
                exceptionName: 'optifine',
                proxyMetadata: {
                    group: 'net.optifine'
                }
            }];
    }
    getClaritasType() {
        return ClaritasLibraryType_1.LibraryType.FORGE;
    }
    discernResult(claritasValue, crudeInference) {
        return (claritasValue == null || claritasValue == '') ? crudeInference : claritasValue;
    }
}
exports.BaseForgeModStructure = BaseForgeModStructure;
//# sourceMappingURL=ForgeMod.struct.js.map