"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackXZExtractWrapper = void 0;
const path_1 = require("path");
const JarExecutor_1 = require("./JarExecutor");
class PackXZExtractWrapper extends JarExecutor_1.JarExecutor {
    constructor() {
        super('PackXZExtract');
    }
    getJarPath() {
        return (0, path_1.join)(process.cwd(), 'libraries', 'java', 'PackXZExtract.jar');
    }
    execute(command, paths) {
        return super.executeJar([], command, paths.join(','));
    }
    extractUnpack(paths) {
        return this.execute('-packxz', paths);
    }
    extract(paths) {
        return this.execute('-xz', paths);
    }
    unpack(paths) {
        return this.execute('-pack', paths);
    }
}
exports.PackXZExtractWrapper = PackXZExtractWrapper;
//# sourceMappingURL=PackXZExtractWrapper.js.map