"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseFileStructure = void 0;
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const LoggerUtil_1 = require("../util/LoggerUtil");
class BaseFileStructure {
    constructor(absoluteRoot, relativeRoot, structRoot) {
        this.absoluteRoot = absoluteRoot;
        this.relativeRoot = relativeRoot;
        this.structRoot = structRoot;
        this.relativeRoot = (0, path_1.join)(relativeRoot, structRoot);
        this.containerDirectory = (0, path_1.resolve)(absoluteRoot, structRoot);
        this.logger = LoggerUtil_1.LoggerUtil.getLogger(this.getLoggerName());
    }
    async init() {
        (0, fs_extra_1.mkdirs)(this.containerDirectory);
    }
}
exports.BaseFileStructure = BaseFileStructure;
//# sourceMappingURL=BaseFileStructure.js.map