/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas.discovery;

import com.dscalzi.claritas.discovery.dto.ModuleMetadata;
import com.dscalzi.claritas.resolver.MetadataResolver;
import com.dscalzi.claritas.resolver.ResolverRegistry;
import com.dscalzi.claritas.resolver.library.LibraryType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(LibraryAnalyzer.class);
    private static final String CLASS_EXTENSION = ".class";
    private final LibraryType type;
    private final String mcVersion;
    private final String absoluteJarPath;

    public LibraryAnalyzer(LibraryType type, String mcVersion, String absoluteJarPath) {
        this.type = type;
        this.mcVersion = mcVersion;
        this.absoluteJarPath = absoluteJarPath;
    }

    private boolean isClassEntry(ZipEntry entry) {
        return entry.getName().toLowerCase().endsWith(CLASS_EXTENSION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleMetadata analyze() {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this.absoluteJarPath);
        }
        catch (IOException e) {
            log.error("IOException while opening jar file.", e);
            return null;
        }
        MetadataResolver resolver = ResolverRegistry.getMetadataResolver(this.type, this.mcVersion);
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.absoluteJarPath));){
            ZipEntry entry;
            resolver.preAnalyze(this.absoluteJarPath);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || !this.isClassEntry(entry)) continue;
                InputStream is = zipFile.getInputStream(entry);
                try {
                    ModuleMetadata md = resolver.resolveMetadata(is);
                    if (md == null) continue;
                    ModuleMetadata moduleMetadata = md;
                    return moduleMetadata;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.error("IOException while processing jar file {}.", (Object)this.absoluteJarPath, (Object)e);
            return null;
        }
        ModuleMetadata md = resolver.getIfNoneFound();
        if (md != null) return md;
        log.error("Failed to resolve metadata for {}.", (Object)this.absoluteJarPath);
        return md;
    }
}

