/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas.resolver.library.forge;

import com.dscalzi.claritas.asm.ClaritasClassVisitor;
import com.dscalzi.claritas.discovery.dto.ModuleMetadata;
import com.dscalzi.claritas.discovery.dto.forge.ForgeMetadata_1_7;
import com.dscalzi.claritas.discovery.dto.forge.ForgeModType_1_7;
import com.dscalzi.claritas.discovery.dto.internal.TweakMetaFile;
import com.dscalzi.claritas.resolver.MetadataResolver;
import com.dscalzi.claritas.util.DataUtil;
import com.dscalzi.claritas.util.Tuple;
import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgeMetadataResolver_1_7
extends MetadataResolver {
    private static final Logger logger = LoggerFactory.getLogger(ForgeMetadataResolver_1_7.class);
    private static final String A_STANDARD_K_MODID = "modid";
    private static final String A_STANDARD_K_VERSION = "version";
    private static final String A_STANDARD_K_NAME = "name";
    private static final String A_COREMOD_K_VALUE = "value";
    private final String standardAnnotation;
    private final String coreModBase;
    private final String coreModAnnotation;
    private final String dummyContainerClass;
    private boolean isCoreMod;
    public final ForgeMetadata_1_7 coreModMetadata = new ForgeMetadata_1_7(ForgeModType_1_7.CORE_MOD);
    private boolean isTweaker;
    private final ForgeMetadata_1_7 tweakMetadata = new ForgeMetadata_1_7(ForgeModType_1_7.TWEAKER);

    public ForgeMetadataResolver_1_7(String standardAnnotation, String coreModBase, String coreModAnnotation, String dummyContainerClass) {
        this.standardAnnotation = standardAnnotation;
        this.coreModBase = coreModBase;
        this.coreModAnnotation = coreModAnnotation;
        this.dummyContainerClass = dummyContainerClass;
    }

    @Override
    public void preAnalyze(String absoluteJarPath) {
        block5: {
            if (absoluteJarPath.endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(absoluteJarPath);
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) break block5;
                    this.isCoreMod = manifest.getMainAttributes().getValue("FMLCorePlugin") != null;
                    boolean bl = this.isTweaker = manifest.getMainAttributes().getValue("TweakClass") != null;
                    if (this.isTweaker) {
                        this.fetchTweakerMeta(absoluteJarPath, manifest.getMainAttributes());
                    }
                }
                catch (IOException e) {
                    logger.error("IO exception while pre-analyzing {}", (Object)absoluteJarPath);
                }
            } else {
                logger.warn("Resolve invoked on non-jar file {}", (Object)absoluteJarPath);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchTweakerMeta(String absoluteJarPath, Attributes mainAttributes) {
        String manifestTweakClass = mainAttributes.getValue("TweakClass");
        String manifestTweakName = DataUtil.getNonEmptyStringOrNull(mainAttributes.getValue("TweakName"));
        String manifestTweakVersion = DataUtil.getNonEmptyStringOrNull(mainAttributes.getValue("TweakVersion"));
        String manifestTweakMetaFile = DataUtil.getNonEmptyStringOrNull(mainAttributes.getValue("TweakMetaFile"));
        String tweakMetaId = null;
        String tweakMetaName = null;
        String tweakMetaVersion = null;
        if (manifestTweakMetaFile != null) {
            try {
                ZipFile zipFile = new ZipFile(absoluteJarPath);
                try (ZipInputStream zis = new ZipInputStream(new FileInputStream(absoluteJarPath));){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().endsWith(manifestTweakMetaFile)) continue;
                        InputStream is = zipFile.getInputStream(entry);
                        try {
                            TweakMetaFile tweakMetaFile = new Gson().fromJson((Reader)new InputStreamReader(is), TweakMetaFile.class);
                            tweakMetaId = DataUtil.getNonEmptyStringOrNull(tweakMetaFile.getId());
                            tweakMetaName = DataUtil.getNonEmptyStringOrNull(tweakMetaFile.getName());
                            tweakMetaVersion = DataUtil.getNonEmptyStringOrNull(tweakMetaFile.getVersion());
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("IOException while processing jar file {}.", (Object)absoluteJarPath, (Object)e);
                }
            }
            catch (IOException e) {
                logger.error("IO exception while pulling tweak meta file {} from {}.", (Object)manifestTweakMetaFile, (Object)absoluteJarPath);
            }
        }
        this.tweakMetadata.setId((String)(tweakMetaId == null ? (tweakMetaName == null ? (manifestTweakName == null ? null : manifestTweakName.toLowerCase()) : tweakMetaName.toLowerCase()) : tweakMetaId));
        this.tweakMetadata.setName(DataUtil.multiplex(tweakMetaName, manifestTweakName));
        this.tweakMetadata.setVersion(DataUtil.multiplex(tweakMetaVersion, manifestTweakVersion));
        this.tweakMetadata.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage(manifestTweakClass), this.tweakMetadata.getId()));
    }

    @Override
    public ModuleMetadata resolveMetadata(InputStream classStream) throws IOException {
        ClaritasClassVisitor cv = this.getClaritasClassVisitor(classStream);
        ForgeMetadata_1_7 fromModAnn = cv.getAnnotations().stream().filter(a -> a.getClassName().equals(this.standardAnnotation)).findFirst().map(a -> {
            ForgeMetadata_1_7 md = new ForgeMetadata_1_7();
            md.setModType(ForgeModType_1_7.MOD);
            for (Map.Entry<String, Object> entry : a.getAnnotationData().entrySet()) {
                switch (entry.getKey()) {
                    case "modid": {
                        md.setId((String)entry.getValue());
                        break;
                    }
                    case "version": {
                        md.setVersion(DataUtil.cleanVersion((String)entry.getValue()));
                        break;
                    }
                    case "name": {
                        md.setName((String)entry.getValue());
                    }
                }
            }
            md.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage(a.getAnnotatedClassName()), md.getId()));
            return md;
        }).orElse(null);
        if (fromModAnn != null) {
            return fromModAnn;
        }
        if (this.isCoreMod) {
            if (this.coreModMetadata.getId() == null) {
                cv.getAnnotations().stream().filter(a -> a.getClassName().equals(this.coreModAnnotation)).findFirst().ifPresent(a -> {
                    this.coreModMetadata.setId(DataUtil.getNonEmptyStringOrNull((String)a.getAnnotationData().get(A_COREMOD_K_VALUE)));
                    this.coreModMetadata.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage(a.getAnnotatedClassName()), this.coreModMetadata.getId()));
                });
            }
            if (this.coreModMetadata.getGroup() == null) {
                cv.getAnnotations().stream().filter(a -> a.getClassName().contains(this.coreModBase)).findFirst().ifPresent(a -> this.coreModMetadata.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage(a.getAnnotatedClassName()), this.coreModMetadata.getId())));
                if (this.coreModMetadata.getGroup() == null) {
                    Tuple<String, List<String>> interfaces = cv.getInterfaces();
                    interfaces.getValue().stream().filter(i -> i.equals(this.coreModBase)).findFirst().ifPresent(i -> this.coreModMetadata.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage((String)interfaces.getKey()), this.coreModMetadata.getId())));
                }
                if (this.coreModMetadata.getGroup() == null && Objects.equals(cv.getSuperClassName(), this.dummyContainerClass)) {
                    this.coreModMetadata.setGroup(DataUtil.inferGroupFromPackage(DataUtil.getPackage(cv.getClassName()), this.coreModMetadata.getId()));
                }
            }
        }
        return null;
    }

    @Override
    public ModuleMetadata getIfNoneFound() {
        if (this.isCoreMod) {
            return this.coreModMetadata;
        }
        if (this.isTweaker) {
            return this.tweakMetadata;
        }
        return new ForgeMetadata_1_7(ForgeModType_1_7.UNKNOWN);
    }
}

