/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUtil {
    public static final Pattern ILLEGAL_VERSION_CHARS = Pattern.compile(".*[@$]+.*");
    private static final Logger log = LoggerFactory.getLogger(DataUtil.class);
    public static final List<String> BLACKLIST = Arrays.asList("common", "util", "internal", "tweaker", "tweak");
    public static final List<String> BLACKLIST_WHEN_NOT_ID = Arrays.asList("forge", "bukkit", "sponge");

    public static List<String> buildBlacklist(@Nullable String id) {
        ArrayList<String> ret = new ArrayList<String>(BLACKLIST);
        if (id == null) {
            ret.addAll(BLACKLIST_WHEN_NOT_ID);
        } else {
            BLACKLIST_WHEN_NOT_ID.stream().filter(term -> !term.equalsIgnoreCase(id)).forEach(ret::add);
        }
        return ret;
    }

    public static String getPackage(String name) {
        if (!name.contains(".")) {
            return null;
        }
        return name.substring(0, name.lastIndexOf(46)).toLowerCase();
    }

    public static String inferGroupFromPackage(String packageName, @Nullable String id) {
        if (packageName == null) {
            log.debug("Mod {} has null package.", (Object)id);
            return null;
        }
        LinkedList<String> packageBits = new LinkedList<String>(Arrays.asList(packageName.split("\\.")));
        List<String> CUSTOM_BLACKLIST = DataUtil.buildBlacklist(id);
        boolean isBadTerm = true;
        while (isBadTerm && !packageBits.isEmpty()) {
            String term = packageBits.getLast();
            if (!Objects.equals(term, id) && !CUSTOM_BLACKLIST.contains(term)) {
                isBadTerm = false;
                continue;
            }
            if (packageBits.size() == 1) {
                isBadTerm = false;
                continue;
            }
            if (Objects.equals(term, id) && packageBits.size() == 2) {
                isBadTerm = false;
                continue;
            }
            packageBits.removeLast();
        }
        return String.join((CharSequence)".", packageBits);
    }

    @Nullable
    public static String getNonEmptyStringOrNull(@Nullable String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    @Nullable
    public static String cleanVersion(String version) {
        if (version != null && !ILLEGAL_VERSION_CHARS.matcher(version).matches()) {
            return version;
        }
        return null;
    }

    @Nullable
    public static <T> T multiplex(@Nullable T a, @Nullable T b) {
        return a != null ? a : b;
    }
}

