/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.DelegatesTo;
import groovy.lang.IntRange;
import groovy.lang.Tuple2;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureConflictResolver;
import groovy.transform.stc.ClosureSignatureHint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.groovy.util.BeanUtils;
import org.apache.groovy.util.SystemUtil;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenUtil;
import org.codehaus.groovy.transform.stc.DefaultTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.DelegationMetadata;
import org.codehaus.groovy.transform.stc.EnumTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.PropertyLookupVisitor;
import org.codehaus.groovy.transform.stc.Receiver;
import org.codehaus.groovy.transform.stc.SecondPassExpression;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.SignatureCodec;
import org.codehaus.groovy.transform.stc.SignatureCodecVersion1;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TraitTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.TypeCheckingExtension;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.Traits;

public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final boolean DEBUG_GENERATED_CODE = SystemUtil.getBooleanSafe("groovy.stc.debug");
    private static final AtomicLong UNIQUE_LONG = new AtomicLong();
    protected static final Object ERROR_COLLECTOR = ErrorCollector.class;
    protected static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    protected static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    protected static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    protected static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    protected static final ClassNode TYPECHECKING_INFO_NODE = ClassHelper.make(TypeChecked.TypeCheckingInfo.class);
    protected static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    protected static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    protected static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    protected static final MethodNode GET_DELEGATE = ClassHelper.CLOSURE_TYPE.getGetterMethod("getDelegate");
    protected static final MethodNode GET_OWNER = ClassHelper.CLOSURE_TYPE.getGetterMethod("getOwner");
    protected static final MethodNode GET_THISOBJECT = ClassHelper.CLOSURE_TYPE.getGetterMethod("getThisObject");
    protected static final ClassNode DELEGATES_TO = ClassHelper.make(DelegatesTo.class);
    protected static final ClassNode DELEGATES_TO_TARGET = ClassHelper.make(DelegatesTo.Target.class);
    protected static final ClassNode LINKEDHASHMAP_CLASSNODE = ClassHelper.make(LinkedHashMap.class);
    protected static final ClassNode CLOSUREPARAMS_CLASSNODE = ClassHelper.make(ClosureParams.class);
    protected static final ClassNode NAMED_PARAMS_CLASSNODE = ClassHelper.make(NamedParams.class);
    protected static final ClassNode MAP_ENTRY_TYPE = ClassHelper.make(Map.Entry.class);
    protected static final ClassNode ENUMERATION_TYPE = ClassHelper.make(Enumeration.class);
    public static final Statement GENERATED_EMPTY_STATEMENT = EmptyStatement.INSTANCE;
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    protected final ReturnAdder.ReturnStatementListener returnListener = new ReturnAdder.ReturnStatementListener(){

        @Override
        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (StaticTypeCheckingVisitor.isNullConstant(returnStatement.getExpression())) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingClosure() != null) {
                StaticTypeCheckingVisitor.this.addClosureReturnType(returnType);
            } else if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingMethod() == null) {
                throw new GroovyBugError("Unexpected return statement at " + returnStatement.getLineNumber() + ":" + returnStatement.getColumnNumber() + " " + returnStatement.getText());
            }
        }
    };
    protected final ReturnAdder returnAdder = new ReturnAdder(this.returnListener);
    protected FieldNode currentField;
    protected PropertyNode currentProperty;
    protected DefaultTypeCheckingExtension extension;
    protected TypeCheckingContext typeCheckingContext = new TypeCheckingContext(this);

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode classNode) {
        this.typeCheckingContext.pushEnclosingClassNode(classNode);
        this.typeCheckingContext.pushTemporaryTypeInfo();
        this.typeCheckingContext.pushErrorCollector(source.getErrorCollector());
        this.typeCheckingContext.source = source;
        this.extension = new DefaultTypeCheckingExtension(this);
        this.extension.addHandler(new EnumTypeCheckingExtension(this));
        this.extension.addHandler(new TraitTypeCheckingExtension(this));
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.typeCheckingContext.getSource();
    }

    public void initialize() {
        this.extension.setup();
    }

    public TypeCheckingContext getTypeCheckingContext() {
        return this.typeCheckingContext;
    }

    public void addTypeCheckingExtension(TypeCheckingExtension extension) {
        this.extension.addHandler(extension);
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.typeCheckingContext.setCompilationUnit(compilationUnit);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitClass(node)) {
            Object type = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (type != null) {
                this.typeCheckingContext.pushErrorCollector();
            }
            this.typeCheckingContext.pushEnclosingClassNode(node);
            Set<MethodNode> oldSet = this.typeCheckingContext.alreadyVisitedMethods;
            this.typeCheckingContext.alreadyVisitedMethods = new LinkedHashSet<MethodNode>();
            super.visitClass(node);
            node.getInnerClasses().forEachRemaining(this::visitClass);
            this.typeCheckingContext.alreadyVisitedMethods = oldSet;
            this.typeCheckingContext.popEnclosingClassNode();
            if (type != null) {
                this.typeCheckingContext.popErrorCollector();
            }
            node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, node);
            node.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
            node.getMethods().forEach(n -> n.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE));
            node.getDeclaredConstructors().forEach(n -> n.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE));
        }
        this.extension.afterVisitClass(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(StaticTypeCheckingVisitor.class)) || this.isSkipMode(node);
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        for (ClassNode tca : this.getTypeCheckingAnnotations()) {
            List<AnnotationNode> annotations = node.getAnnotations(tca);
            if (annotations == null) continue;
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                if (value == null) continue;
                if (value instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)value;
                    if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                    return true;
                }
                if (!(value instanceof PropertyExpression)) continue;
                PropertyExpression pe = (PropertyExpression)value;
                if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                return true;
            }
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return this.isSkippedInnerClass(node);
    }

    protected boolean isSkippedInnerClass(AnnotatedNode node) {
        MethodNode enclosingMethod;
        ClassNode type;
        return node instanceof ClassNode && (type = (ClassNode)node).getOuterClass() != null && (enclosingMethod = type.getEnclosingMethod()) != null && this.isSkipMode(enclosingMethod);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        ClassNode cn = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression, this.getType(expression));
        }
    }

    private static ClassNode getOutermost(ClassNode cn) {
        while (cn.getOuterClass() != null) {
            cn = cn.getOuterClass();
        }
        return cn;
    }

    private static void addPrivateFieldOrMethodAccess(Expression source, ClassNode cn, StaticTypesMarker key, ASTNode accessedMember) {
        cn.getNodeMetaData((Object)key, x -> new LinkedHashSet()).add(accessedMember);
        source.putNodeMetaData((Object)key, accessedMember);
    }

    private void checkOrMarkPrivateAccess(Expression source, FieldNode fn, boolean lhsOfAssignment) {
        ClassNode enclosingClass;
        if (fn == null || !fn.isPrivate()) {
            return;
        }
        ClassNode declaringClass = fn.getDeclaringClass();
        if (declaringClass == (enclosingClass = this.typeCheckingContext.getEnclosingClassNode()) && this.typeCheckingContext.getEnclosingClosure() == null) {
            return;
        }
        if (declaringClass == enclosingClass || StaticTypeCheckingVisitor.getOutermost(declaringClass) == StaticTypeCheckingVisitor.getOutermost(enclosingClass)) {
            StaticTypesMarker accessKind = lhsOfAssignment ? StaticTypesMarker.PV_FIELDS_MUTATION : StaticTypesMarker.PV_FIELDS_ACCESS;
            StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, accessKind, fn);
        }
    }

    private void checkOrMarkPrivateAccess(Expression source, MethodNode mn) {
        ClassNode enclosingClassNode;
        if (mn == null) {
            return;
        }
        ClassNode declaringClass = mn.getDeclaringClass();
        if (declaringClass != (enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode()) || this.typeCheckingContext.getEnclosingClosure() != null) {
            int mods = mn.getModifiers();
            boolean sameModule = declaringClass.getModule() == enclosingClassNode.getModule();
            String packageName = declaringClass.getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            if (Modifier.isPrivate(mods) && sameModule) {
                StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, StaticTypesMarker.PV_METHODS_ACCESS, mn);
            } else if (Modifier.isProtected(mods) && !packageName.equals(enclosingClassNode.getPackageName()) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(enclosingClassNode, declaringClass)) {
                ClassNode cn = enclosingClassNode;
                while ((cn = cn.getOuterClass()) != null) {
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(cn, declaringClass)) continue;
                    StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, cn, StaticTypesMarker.PV_METHODS_ACCESS, mn);
                    break;
                }
            }
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        super.visitVariableExpression(vexp);
        if (this.storeTypeForSuper(vexp)) {
            return;
        }
        if (this.storeTypeForThis(vexp)) {
            return;
        }
        String name = vexp.getName();
        Variable accessedVariable = vexp.getAccessedVariable();
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (accessedVariable == null) {
            return;
        }
        if (accessedVariable instanceof DynamicVariable) {
            if (enclosingClosure != null) {
                switch (name) {
                    case "delegate": {
                        DelegationMetadata dm = this.getDelegationMetadata(enclosingClosure.getClosureExpression());
                        if (dm != null) {
                            this.storeType(vexp, dm.getType());
                            return;
                        }
                    }
                    case "owner": {
                        if (this.typeCheckingContext.getEnclosingClosureStack().size() > 1) {
                            this.storeType(vexp, ClassHelper.CLOSURE_TYPE);
                            return;
                        }
                    }
                    case "thisObject": {
                        this.storeType(vexp, this.typeCheckingContext.getEnclosingClassNode());
                        return;
                    }
                    case "parameterTypes": {
                        this.storeType(vexp, ClassHelper.CLASS_Type.makeArray());
                        return;
                    }
                    case "maximumNumberOfParameters": 
                    case "resolveStrategy": 
                    case "directive": {
                        this.storeType(vexp, ClassHelper.int_TYPE);
                        return;
                    }
                }
            }
            if (this.tryVariableExpressionAsProperty(vexp, name)) {
                return;
            }
            if (!this.extension.handleUnresolvedVariableExpression(vexp)) {
                this.addStaticTypeError("The variable [" + name + "] is undeclared.", vexp);
            }
        } else if (accessedVariable instanceof FieldNode) {
            if (enclosingClosure != null) {
                this.tryVariableExpressionAsProperty(vexp, name);
            } else {
                this.checkOrMarkPrivateAccess(vexp, (FieldNode)accessedVariable, this.typeCheckingContext.isTargetOfEnclosingAssignment(vexp));
                ClassNode inferredType = this.getInferredTypeFromTempInfo(vexp, null);
                if (inferredType != null && !inferredType.equals(ClassHelper.OBJECT_TYPE)) {
                    vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferredType);
                } else {
                    this.storeType(vexp, this.getType(vexp));
                }
            }
        } else if (accessedVariable instanceof PropertyNode) {
            Expression leftExpression;
            SetterInfo setterInfo;
            BinaryExpression enclosingBinaryExpression;
            if (this.tryVariableExpressionAsProperty(vexp, name) && (enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null && (setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression = enclosingBinaryExpression.getLeftExpression())) != null) {
                Expression rightExpression = enclosingBinaryExpression.getRightExpression();
                this.ensureValidSetter(vexp, leftExpression, rightExpression, setterInfo);
            }
        } else {
            VariableExpression localVariable;
            if (accessedVariable instanceof Parameter) {
                Parameter parameter = (Parameter)accessedVariable;
                localVariable = new ParameterVariableExpression(parameter);
            } else {
                localVariable = (VariableExpression)accessedVariable;
            }
            ClassNode inferredType = (ClassNode)localVariable.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            inferredType = this.getInferredTypeFromTempInfo(localVariable, inferredType);
            if (inferredType != null && !inferredType.equals(ClassHelper.OBJECT_TYPE)) {
                vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferredType);
            }
        }
    }

    private boolean storeTypeForSuper(VariableExpression vexp) {
        if (vexp == VariableExpression.SUPER_EXPRESSION) {
            return true;
        }
        if (!vexp.isSuperExpression()) {
            return false;
        }
        this.storeType(vexp, this.makeSuper());
        return true;
    }

    private boolean storeTypeForThis(VariableExpression vexp) {
        if (vexp == VariableExpression.THIS_EXPRESSION) {
            return true;
        }
        if (!vexp.isThisExpression()) {
            return false;
        }
        this.storeType(vexp, !ClassHelper.OBJECT_TYPE.equals(vexp.getType()) ? vexp.getType() : this.makeThis());
        return true;
    }

    private boolean tryVariableExpressionAsProperty(VariableExpression vexp, String dynName) {
        PropertyExpression pexp = GeneralUtils.thisPropX(true, dynName);
        if (this.existsProperty(pexp, !this.typeCheckingContext.isTargetOfEnclosingAssignment(vexp))) {
            vexp.copyNodeMetaData(pexp.getObjectExpression());
            for (Object key : new Object[]{StaticTypesMarker.IMPLICIT_RECEIVER, StaticTypesMarker.READONLY_PROPERTY, StaticTypesMarker.PV_FIELDS_ACCESS, StaticTypesMarker.PV_FIELDS_MUTATION, StaticTypesMarker.DECLARATION_INFERRED_TYPE, StaticTypesMarker.DIRECT_METHOD_CALL_TARGET}) {
                Object val = pexp.getNodeMetaData(key);
                if (val == null) continue;
                vexp.putNodeMetaData(key, val);
            }
            vexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            ClassNode type = (ClassNode)pexp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            this.storeType(vexp, Optional.ofNullable(type).orElseGet(pexp::getType));
            String receiver = (String)vexp.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
            Boolean dynamic = (Boolean)pexp.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION);
            if ((receiver != null && !receiver.endsWith("owner") || Boolean.TRUE.equals(dynamic)) && !(vexp.getAccessedVariable() instanceof DynamicVariable)) {
                vexp.setAccessedVariable(new DynamicVariable(dynName, false));
            }
            return true;
        }
        return false;
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        if (this.existsProperty(expression, !this.typeCheckingContext.isTargetOfEnclosingAssignment(expression))) {
            return;
        }
        if (!this.extension.handleUnresolvedProperty(expression)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), expression);
        }
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        if (this.existsProperty(expression, true)) {
            return;
        }
        if (!this.extension.handleUnresolvedAttribute(expression)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such attribute: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), expression);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        ClassNode fromType = ClassHelper.getWrapper(this.getType(expression.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType(expression.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType(expression, ClassHelper.make(IntRange.class));
        } else {
            ClassNode rangeType = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            rangeType.setGenericsTypes(new GenericsType[]{new GenericsType(WideningCategories.lowestUpperBound(fromType, toType))});
            this.storeType(expression, rangeType);
        }
    }

    @Override
    public void visitNotExpression(NotExpression expression) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitNotExpression(expression);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        this.typeCheckingContext.pushEnclosingBinaryExpression(expression);
        try {
            boolean isEmptyDeclaration;
            boolean isAssignment;
            ClassNode resultType;
            int op = expression.getOperation().getType();
            Expression leftExpression = expression.getLeftExpression();
            Expression rightExpression = expression.getRightExpression();
            leftExpression.visit(this);
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
            ClassNode lType = null;
            if (setterInfo != null) {
                if (this.ensureValidSetter(expression, leftExpression, rightExpression, setterInfo)) {
                    return;
                }
                lType = this.getType(leftExpression);
            } else {
                if (op != 100 && op != 217) {
                    lType = this.getType(leftExpression);
                } else {
                    lType = this.getOriginalDeclarationType(leftExpression);
                    if (ClassHelper.isFunctionalInterface(lType)) {
                        this.processFunctionalInterfaceAssignment(lType, rightExpression);
                    } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && rightExpression instanceof ClosureExpression) {
                        this.storeInferredReturnType(rightExpression, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
                    }
                }
                rightExpression.visit(this);
            }
            ClassNode rType = StaticTypeCheckingVisitor.isNullConstant(rightExpression) && !ClassHelper.isPrimitiveType(lType) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo(rightExpression, this.getType(rightExpression));
            BinaryExpression reversedBinaryExpression = GeneralUtils.binX(rightExpression, expression.getOperation(), leftExpression);
            ClassNode classNode = resultType = op == 573 || op == 129 ? this.getResultType(rType, op, lType, reversedBinaryExpression) : this.getResultType(lType, op, rType, expression);
            if (op == 573 || op == 129) {
                this.storeTargetMethod(expression, (MethodNode)reversedBinaryExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            } else if (op == 30 && leftExpression instanceof VariableExpression && leftExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) == null) {
                this.storeType(leftExpression, lType);
            } else if (op == 217) {
                ElvisOperatorExpression elvisOperatorExpression = new ElvisOperatorExpression(leftExpression, rightExpression);
                elvisOperatorExpression.setSourcePosition(expression);
                elvisOperatorExpression.visit(this);
                resultType = this.getType(elvisOperatorExpression);
                this.storeType(leftExpression, resultType);
            }
            if (resultType == null) {
                resultType = lType;
            }
            if (leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isClosureSharedVariable()) {
                this.typeCheckingContext.secondPassExpressions.add(new SecondPassExpression(expression));
            }
            if ((isAssignment = StaticTypeCheckingSupport.isAssignment(expression.getOperation().getType())) && lType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType)) {
                ClassNode completedType;
                resultType = completedType = GenericsUtils.parameterizeType(lType, resultType.getPlainNodeReference());
            }
            if (StaticTypeCheckingSupport.isArrayOp(op) && !lType.isArray() && enclosingBinaryExpression != null && enclosingBinaryExpression.getLeftExpression() == expression && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
                Expression enclosingBE_rightExpr = enclosingBinaryExpression.getRightExpression();
                if (!(enclosingBE_rightExpr instanceof ClosureExpression)) {
                    enclosingBE_rightExpr.visit(this);
                }
                ClassNode[] arguments = new ClassNode[]{rType, this.getType(enclosingBE_rightExpr)};
                List<MethodNode> nodes = this.findMethod(lType.redirect(), "putAt", arguments);
                if (nodes.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(lType, arguments, nodes.get(0), enclosingBE_rightExpr);
                } else if (nodes.isEmpty()) {
                    this.addNoMatchingMethodError(lType, "putAt", arguments, enclosingBinaryExpression);
                }
            }
            boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && rightExpression instanceof EmptyExpression;
            if (isAssignment && !isEmptyDeclaration) {
                if (rightExpression instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
                }
                ClassNode originType = this.getOriginalDeclarationType(leftExpression);
                this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(resultType), ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                } else if (lType.isUsingGenerics() && !lType.isEnum() && StaticTypeCheckingVisitor.hasRHSIncompleteGenericTypeInfo(resultType)) {
                    resultType = lType;
                } else {
                    int modifiers = resultType.getModifiers();
                    ClassNode enclosingType = this.typeCheckingContext.getEnclosingClassNode();
                    if (!(Modifier.isPublic(modifiers) || enclosingType.equals(resultType) || StaticTypeCheckingVisitor.getOutermost(enclosingType).equals(StaticTypeCheckingVisitor.getOutermost(resultType)) || !Modifier.isPrivate(modifiers) && Objects.equals(enclosingType.getPackageName(), resultType.getPackageName()))) {
                        resultType = originType;
                    }
                }
                if (ClassHelper.isPrimitiveType(originType) && resultType.equals(ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                }
                if (!StaticTypeCheckingVisitor.isNullConstant(rightExpression) && leftExpression instanceof VariableExpression && this.typeCheckingContext.ifElseForWhileAssignmentTracker != null) {
                    Variable accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable();
                    if (accessedVariable instanceof Parameter) {
                        accessedVariable = new ParameterVariableExpression((Parameter)accessedVariable);
                    }
                    if (accessedVariable instanceof VariableExpression) {
                        this.recordAssignment((VariableExpression)accessedVariable, resultType);
                    }
                }
                this.storeType(leftExpression, resultType);
                if (leftExpression instanceof VariableExpression) {
                    Variable targetVariable;
                    if (rightExpression instanceof ClosureExpression) {
                        leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, ((ClosureExpression)rightExpression).getParameters());
                    } else if (rightExpression instanceof VariableExpression && ((VariableExpression)rightExpression).getAccessedVariable() instanceof Expression && ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null && (targetVariable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)leftExpression)) instanceof ASTNode) {
                        ((ASTNode)((Object)targetVariable)).putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, ((Expression)((Object)((VariableExpression)rightExpression).getAccessedVariable())).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                    }
                }
            } else if (op == 544) {
                this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
            }
            if (!isEmptyDeclaration) {
                this.storeType(expression, resultType);
            }
            this.validateResourceInARM(expression, resultType);
        }
        finally {
            this.typeCheckingContext.popEnclosingBinaryExpression();
        }
    }

    private void validateResourceInARM(BinaryExpression expression, ClassNode lType) {
        if (expression instanceof DeclarationExpression && TryCatchStatement.isResource(expression) && !lType.implementsInterface(ClassHelper.AUTOCLOSEABLE_TYPE)) {
            this.addError("Resource[" + lType.getName() + "] in ARM should be of type AutoCloseable", expression);
        }
    }

    private void processFunctionalInterfaceAssignment(ClassNode lhsType, Expression rhsExpression) {
        if (rhsExpression instanceof ClosureExpression) {
            this.inferParameterAndReturnTypesOfClosureOnRHS(lhsType, (ClosureExpression)rhsExpression);
        } else if (rhsExpression instanceof MethodReferenceExpression) {
            LambdaExpression lambdaExpression = this.constructLambdaExpressionForMethodReference(lhsType);
            this.inferParameterAndReturnTypesOfClosureOnRHS(lhsType, lambdaExpression);
            rhsExpression.putNodeMetaData((Object)StaticTypesMarker.CONSTRUCTED_LAMBDA_EXPRESSION, lambdaExpression);
            rhsExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, Arrays.stream(lambdaExpression.getParameters()).map(Parameter::getType).toArray(ClassNode[]::new));
        }
    }

    private void inferParameterAndReturnTypesOfClosureOnRHS(ClassNode lhsType, ClosureExpression rhsExpression) {
        ClassNode[] samParameterTypes;
        int m;
        Tuple2<ClassNode[], ClassNode> typeInfo = GenericsUtils.parameterizeSAM(lhsType);
        Parameter[] closureParameters = ClosureUtils.getParametersSafe(rhsExpression);
        int n = closureParameters.length;
        if (n == (m = (samParameterTypes = typeInfo.getV1()).length) || 1 == m && ClosureUtils.hasImplicitParameter(rhsExpression)) {
            for (int i = 0; i < n; ++i) {
                Parameter parameter;
                if (samParameterTypes[i] == null || !(parameter = closureParameters[i]).isDynamicTyped()) continue;
                parameter.setType(samParameterTypes[i]);
                parameter.setOriginType(samParameterTypes[i]);
            }
        } else {
            String descriptor = StaticTypeCheckingSupport.toMethodParametersString(ClassHelper.findSAM(lhsType).getName(), samParameterTypes);
            this.addStaticTypeError("Wrong number of parameters for method target " + descriptor, rhsExpression);
        }
        this.storeInferredReturnType(rhsExpression, typeInfo.getV2());
    }

    private boolean ensureValidSetter(Expression expression, Expression leftExpression, Expression rightExpression, SetterInfo setterInfo) {
        VariableExpression ve = GeneralUtils.varX("%", setterInfo.receiverType);
        Expression newRightExpression = StaticTypeCheckingVisitor.isCompoundAssignment(expression) ? GeneralUtils.binX(leftExpression, StaticTypeCheckingVisitor.getOpWithoutEqual(expression), rightExpression) : rightExpression;
        MethodCallExpression call = GeneralUtils.callX((Expression)ve, setterInfo.name, newRightExpression);
        call.setImplicitThis(false);
        this.visitMethodCallExpression(call);
        MethodNode directSetterCandidate = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (directSetterCandidate == null) {
            for (MethodNode setter : setterInfo.setters) {
                ClassNode type = ClassHelper.getWrapper(setter.getParameters()[0].getOriginType());
                if (!ClassHelper.Boolean_TYPE.equals(type) && !ClassHelper.STRING_TYPE.equals(type) && !ClassHelper.CLASS_Type.equals(type)) continue;
                call = GeneralUtils.callX((Expression)ve, setterInfo.name, (Expression)GeneralUtils.castX(type, newRightExpression));
                call.setImplicitThis(false);
                this.visitMethodCallExpression(call);
                directSetterCandidate = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                if (directSetterCandidate == null) continue;
                break;
            }
        }
        if (directSetterCandidate != null) {
            for (MethodNode setter : setterInfo.setters) {
                if (setter != directSetterCandidate) continue;
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directSetterCandidate);
                leftExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                this.storeType(leftExpression, this.getType(newRightExpression));
                break;
            }
            return false;
        }
        ClassNode firstSetterType = setterInfo.setters.get(0).getParameters()[0].getOriginType();
        this.addAssignmentError(firstSetterType, this.getType(newRightExpression), expression);
        return true;
    }

    private static boolean isClosureWithType(ClassNode type) {
        return type.equals(ClassHelper.CLOSURE_TYPE) && Optional.ofNullable(type.getGenericsTypes()).filter(gts -> gts != null && ((GenericsType[])gts).length == 1).isPresent();
    }

    private static boolean isCompoundAssignment(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return false;
        }
        int type = ((BinaryExpression)exp).getOperation().getType();
        return StaticTypeCheckingSupport.isAssignment(type) && type != 100;
    }

    private static Token getOpWithoutEqual(Expression exp) {
        if (!(exp instanceof BinaryExpression)) {
            return null;
        }
        Token op = ((BinaryExpression)exp).getOperation();
        int typeWithoutEqual = TokenUtil.removeAssignment(op.getType());
        return new Token(typeWithoutEqual, op.getText(), op.getStartLine(), op.getStartColumn());
    }

    protected ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (var instanceof PropertyNode) {
                return this.getType(lhs);
            }
            if (var instanceof DynamicVariable) {
                return this.getType(lhs);
            }
            return var.getOriginType();
        }
        if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    protected void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode node = cce.getType();
        if (node.isUsingGenerics() && node.getGenericsTypes() != null && node.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(cce.getArguments());
            if (argumentListExpression.getExpressions().isEmpty()) {
                this.adjustGenerics(lType, node);
            } else {
                ClassNode type = this.getType(argumentListExpression.getExpression(0));
                if (type.isUsingGenerics()) {
                    this.adjustGenerics(type, node);
                }
            }
            this.storeType(cce, node);
        }
    }

    private void adjustGenerics(ClassNode from, ClassNode to) {
        GenericsType[] genericsTypes = from.getGenericsTypes();
        if (genericsTypes == null) {
            genericsTypes = to.redirect().getGenericsTypes();
        }
        GenericsType[] copy = new GenericsType[genericsTypes.length];
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
        }
        to.setGenericsTypes(copy);
    }

    protected void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        List potentialTypes = this.typeCheckingContext.temporaryIfBranchTypeInformation.peek().computeIfAbsent(this.extractTemporaryTypeInfoKey(objectOfInstanceOf), key -> new LinkedList());
        potentialTypes.add(typeExpression.getType());
    }

    private boolean typeCheckMultipleAssignmentAndContinue(Expression leftExpression, Expression rightExpression) {
        if (!(leftExpression instanceof TupleExpression)) {
            return true;
        }
        Expression transformedRightExpression = this.transformRightExpressionToSupportMultipleAssignment(rightExpression);
        if (transformedRightExpression == null) {
            this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
            return false;
        }
        rightExpression = transformedRightExpression;
        TupleExpression tuple = (TupleExpression)leftExpression;
        ListExpression list = (ListExpression)rightExpression;
        List<Expression> listExpressions = list.getExpressions();
        List<Expression> tupleExpressions = tuple.getExpressions();
        if (listExpressions.size() < tupleExpressions.size()) {
            this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list);
            return false;
        }
        int tupleExpressionsSize = tupleExpressions.size();
        for (int i = 0; i < tupleExpressionsSize; ++i) {
            ClassNode tupleType;
            Expression tupleExpression = tupleExpressions.get(i);
            Expression listExpression = listExpressions.get(i);
            ClassNode elemType = this.getType(listExpression);
            if (!StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) {
                this.addStaticTypeError("Cannot assign value of type " + elemType.toString(false) + " to variable of type " + tupleType.toString(false), rightExpression);
                return false;
            }
            this.storeType(tupleExpression, elemType);
        }
        return true;
    }

    private Expression transformRightExpressionToSupportMultipleAssignment(Expression rightExpression) {
        if (rightExpression instanceof ListExpression) {
            return rightExpression;
        }
        ClassNode cn = null;
        if (rightExpression instanceof MethodCallExpression || rightExpression instanceof ConstructorCallExpression || rightExpression instanceof VariableExpression) {
            ClassNode inferredType = this.getType(rightExpression);
            ClassNode classNode = cn = inferredType == null ? rightExpression.getType() : inferredType;
        }
        if (cn == null) {
            return null;
        }
        int n = ClassHelper.TUPLE_CLASSES.length;
        for (int i = 0; i < n; ++i) {
            Class tcn = ClassHelper.TUPLE_CLASSES[i];
            if (!tcn.equals(cn.getTypeClass())) continue;
            ListExpression listExpression = new ListExpression();
            GenericsType[] genericsTypes = cn.getGenericsTypes();
            for (int j = 0; j < i; ++j) {
                MethodCallExpression mce = new MethodCallExpression(rightExpression, "getV" + (j + 1), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                ClassNode elementType = genericsTypes != null ? genericsTypes[j].getType() : ClassHelper.OBJECT_TYPE;
                mce.setType(elementType);
                this.storeType(mce, elementType);
                listExpression.addExpression(mce);
            }
            listExpression.setSourcePosition(rightExpression);
            return listExpression;
        }
        return null;
    }

    private static ClassNode adjustTypeForSpreading(ClassNode inferredRightExpressionType, Expression leftExpression) {
        ClassNode wrappedRHS = inferredRightExpressionType;
        if (leftExpression instanceof PropertyExpression && ((PropertyExpression)leftExpression).isSpreadSafe()) {
            wrappedRHS = ClassHelper.LIST_TYPE.getPlainNodeReference();
            wrappedRHS.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(inferredRightExpressionType))});
        }
        return wrappedRHS;
    }

    private boolean addedReadOnlyPropertyError(Expression expr) {
        if (expr.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) == null) {
            return false;
        }
        String name = expr instanceof VariableExpression ? ((VariableExpression)expr).getName() : ((PropertyExpression)expr).getPropertyAsString();
        this.addStaticTypeError("Cannot set read-only property: " + name, expr);
        return true;
    }

    private void addPrecisionErrors(ClassNode leftRedirect, ClassNode lhsType, ClassNode rhsType, Expression rightExpression) {
        ClassNode rightComponentType;
        ClassNode leftComponentType;
        if (ClassHelper.isNumberType(leftRedirect)) {
            if (ClassHelper.isNumberType(rhsType) && StaticTypeCheckingSupport.checkPossibleLossOfPrecision(leftRedirect, rhsType, rightExpression)) {
                this.addStaticTypeError("Possible loss of precision from " + rhsType.toString(false) + " to " + lhsType.toString(false), rightExpression);
            }
            return;
        }
        if (!leftRedirect.isArray()) {
            return;
        }
        if (rightExpression instanceof ListExpression) {
            ClassNode leftComponentType2 = leftRedirect.getComponentType();
            for (Expression expression : ((ListExpression)rightExpression).getExpressions()) {
                ClassNode rightComponentType2 = this.getType(expression);
                if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType2, rightComponentType2) || StaticTypeCheckingVisitor.isNullConstant(expression) && !ClassHelper.isPrimitiveType(leftComponentType2)) continue;
                this.addStaticTypeError("Cannot assign value of type " + rightComponentType2.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
            }
        } else if (rhsType.redirect().isArray() && !StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType = leftRedirect.getComponentType(), rightComponentType = rhsType.redirect().getComponentType())) {
            this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + lhsType.toString(false), rightExpression);
        }
    }

    private void addListAssignmentConstructorErrors(ClassNode leftRedirect, ClassNode leftExpressionType, ClassNode inferredRightExpressionType, Expression rightExpression, Expression assignmentExpression) {
        if (rightExpression instanceof ListExpression && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.LIST_TYPE, leftRedirect)) {
            ArgumentListExpression argList = GeneralUtils.args(((ListExpression)rightExpression).getExpressions());
            ClassNode[] args = this.getArgumentTypes(argList);
            MethodNode methodNode = this.checkGroovyStyleConstructor(leftRedirect, args, assignmentExpression);
            if (methodNode != null) {
                rightExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, methodNode);
            }
        } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE) && !StaticTypeCheckingSupport.isWildcardLeftHandSide(leftExpressionType) && !this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
        }
    }

    private void addMapAssignmentConstructorErrors(ClassNode leftRedirect, Expression leftExpression, Expression rightExpression) {
        if (!(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped() || leftRedirect.equals(ClassHelper.OBJECT_TYPE) || StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE)) {
            return;
        }
        ClassNode[] argTypes = this.getArgumentTypes(GeneralUtils.args(rightExpression));
        this.checkGroovyStyleConstructor(leftRedirect, argTypes, rightExpression);
        MapExpression mapExpression = (MapExpression)rightExpression;
        this.checkGroovyConstructorMap(leftExpression, leftRedirect, mapExpression);
    }

    private void checkTypeGenerics(ClassNode leftExpressionType, ClassNode wrappedRHS, Expression rightExpression) {
        if (!leftExpressionType.isUsingGenerics()) {
            return;
        }
        if (StaticTypeCheckingVisitor.hasRHSIncompleteGenericTypeInfo(wrappedRHS)) {
            return;
        }
        GenericsType gt = GenericsUtils.buildWildcardType(leftExpressionType);
        if (StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE.equals(wrappedRHS) || gt.isCompatibleWith(wrappedRHS) || StaticTypeCheckingVisitor.isNullConstant(rightExpression)) {
            return;
        }
        this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + wrappedRHS.toString(false) + " to: " + leftExpressionType.toString(false), rightExpression);
    }

    private boolean hasGStringStringError(ClassNode leftExpressionType, ClassNode wrappedRHS, Expression rightExpression) {
        if (StaticTypeCheckingSupport.isParameterizedWithString(leftExpressionType) && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(wrappedRHS)) {
            this.addStaticTypeError("You are trying to use a GString in place of a String in a type which explicitly declares accepting String. Make sure to call toString() on all GString values.", rightExpression);
            return true;
        }
        return false;
    }

    protected void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode inferredRightExpressionTypeOrig) {
        ClassNode wrappedRHS;
        ClassNode inferredRightExpressionType = inferredRightExpressionTypeOrig;
        if (!this.typeCheckMultipleAssignmentAndContinue(leftExpression, rightExpression)) {
            return;
        }
        if (this.addedReadOnlyPropertyError(leftExpression)) {
            return;
        }
        ClassNode leftRedirect = leftExpressionType.redirect();
        if (rightExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(rightExpression) && assignmentExpression.getOperation().getType() == 100) {
            inferredRightExpressionType = (ClassNode)rightExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect, wrappedRHS = StaticTypeCheckingVisitor.adjustTypeForSpreading(inferredRightExpressionType, leftExpression), rightExpression)) {
            if (!this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
                this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression.getRightExpression());
            }
        } else {
            this.addPrecisionErrors(leftRedirect, leftExpressionType, inferredRightExpressionType, rightExpression);
            this.addListAssignmentConstructorErrors(leftRedirect, leftExpressionType, inferredRightExpressionType, rightExpression, assignmentExpression);
            this.addMapAssignmentConstructorErrors(leftRedirect, leftExpression, rightExpression);
            if (this.hasGStringStringError(leftExpressionType, wrappedRHS, rightExpression)) {
                return;
            }
            this.checkTypeGenerics(leftExpressionType, wrappedRHS, rightExpression);
        }
    }

    protected void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        this.typeCheckingContext.pushEnclosingBinaryExpression(null);
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            Expression valueExpression;
            ClassNode valueType;
            ClassNode resultType;
            Expression keyExpression = entryExpression.getKeyExpression();
            if (!(keyExpression instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpression);
                continue;
            }
            String pName = keyExpression.getText();
            AtomicReference<ClassNode> pType = new AtomicReference<ClassNode>();
            if (!this.existsProperty(GeneralUtils.propX((Expression)GeneralUtils.varX("_", receiverType), pName), false, new PropertyLookupVisitor(pType))) {
                this.addStaticTypeError("No such property: " + pName + " for class: " + receiverType.getText(), receiver);
                continue;
            }
            ClassNode targetType = Optional.ofNullable(receiverType.getSetterMethod(GeneralUtils.getSetterName(pName), false)).map(setter -> setter.getParameters()[0].getType()).orElseGet(pType::get);
            if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(targetType, resultType = this.getResultType(targetType, 100, valueType = this.getType(valueExpression = entryExpression.getValueExpression()), StaticTypeCheckingVisitor.assignX(keyExpression, valueExpression, entryExpression)), valueExpression) || this.extension.handleIncompatibleAssignment(targetType, valueType, entryExpression)) continue;
            this.addAssignmentError(targetType, valueType, entryExpression);
        }
        this.typeCheckingContext.popEnclosingBinaryExpression();
    }

    protected static boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!genericsType.isPlaceholder()) continue;
                replaceType = true;
                break;
            }
        }
        return replaceType;
    }

    @Deprecated
    protected void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        this.checkGroovyStyleConstructor(node, arguments, this.typeCheckingContext.getEnclosingClassNode());
    }

    protected MethodNode checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments, ASTNode source) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return null;
        }
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return null;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            if (StaticTypeCheckingSupport.isBeingCompiled(node) && arguments.length == 1 && LINKEDHASHMAP_CLASSNODE.equals(arguments[0])) {
                ConstructorNode cn = new ConstructorNode(1, new Parameter[]{new Parameter(LINKEDHASHMAP_CLASSNODE, "args")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                return cn;
            }
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        if (constructorList.size() > 1) {
            this.addStaticTypeError("Ambiguous constructor call " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), source);
            return null;
        }
        return constructorList.get(0);
    }

    protected Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    protected ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        List<ClassNode> nodes;
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (nodes = this.getTemporaryTypesForExpression(expr)) != null && nodes.size() == 1) {
            return nodes.get(0);
        }
        return type;
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean readMode, ClassCodeVisitorSupport visitor) {
        ClassNode receiverType;
        super.visitPropertyExpression(pexp);
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return false;
        }
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType(objectExpression);
        List<ClassNode> enclosingTypes = this.typeCheckingContext.getEnclosingClassNodes();
        boolean staticOnlyAccess = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(objectExpressionType);
        if (staticOnlyAccess && "this".equals(propertyName)) {
            ClassNode outer = objectExpressionType.getGenericsTypes()[0].getType();
            ClassNode found = null;
            for (ClassNode enclosingType : enclosingTypes) {
                if (enclosingType.isStaticClass() || !outer.equals(enclosingType.getOuterClass())) continue;
                found = enclosingType;
                break;
            }
            if (found != null) {
                this.storeType(pexp, outer);
                return true;
            }
        }
        boolean foundGetterOrSetter = false;
        String capName = BeanUtils.capitalize(propertyName);
        HashSet<ClassNode> handledNodes = new HashSet<ClassNode>();
        ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
        this.addReceivers(receivers, this.makeOwnerList(objectExpression), pexp.isImplicitThis());
        for (Receiver receiver : receivers) {
            receiverType = receiver.getType();
            if (receiverType.isArray() && "length".equals(propertyName)) {
                this.storeType(pexp, ClassHelper.int_TYPE);
                if (visitor != null) {
                    FieldNode length = new FieldNode("length", 17, ClassHelper.int_TYPE, receiverType, null);
                    length.setDeclaringClass(receiverType);
                    visitor.visitField(length);
                }
                return true;
            }
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(receiverType);
            if (ClassHelper.isPrimitiveType(receiverType)) {
                queue.add(ClassHelper.getWrapper(receiverType));
            }
            while (!queue.isEmpty()) {
                ClassNode current = (ClassNode)queue.remove();
                if (!handledNodes.add(current)) continue;
                Object field = current.getDeclaredField(propertyName);
                if (field == null) {
                    if (current.getSuperClass() != null) {
                        queue.addFirst(current.getUnresolvedSuperClass());
                    }
                    for (ClassNode face : current.getAllInterfaces()) {
                        queue.add(GenericsUtils.parameterizeType(current, face));
                    }
                }
                boolean staticOnly = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(current) ? false : staticOnlyAccess;
                field = (FieldNode)this.allowStaticAccessToMember(field, staticOnly);
                if (pexp instanceof AttributeExpression) {
                    if (field == null || !this.storeField((FieldNode)field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) continue;
                    pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                    return true;
                }
                if (field != null && enclosingTypes.contains(current) && this.storeField((FieldNode)field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) {
                    pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                    return true;
                }
                MethodNode getter = this.findGetter(current, "get" + capName, pexp.isImplicitThis());
                if ((getter = this.allowStaticAccessToMember(getter, staticOnly)) == null) {
                    getter = this.findGetter(current, "is" + capName, pexp.isImplicitThis());
                }
                getter = this.allowStaticAccessToMember(getter, staticOnly);
                Object setters = StaticTypeCheckingSupport.findSetters(current, GeneralUtils.getSetterName(propertyName), false);
                setters = (List)this.allowStaticAccessToMember(setters, staticOnly);
                if (visitor != null && getter != null) {
                    visitor.visitMethod(getter);
                }
                PropertyNode property = current.getProperty(propertyName);
                if ((property = this.allowStaticAccessToMember(property, staticOnly)) == null || !enclosingTypes.contains(receiverType)) {
                    if (readMode) {
                        if (getter != null) {
                            ClassNode returnType = this.inferReturnTypeGenerics(current, getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                            this.storeInferredTypeForPropertyExpression(pexp, returnType);
                            this.storeTargetMethod(pexp, getter);
                            String delegationData = (String)receiver.getData();
                            if (delegationData != null) {
                                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                            }
                            return true;
                        }
                    } else {
                        if (!setters.isEmpty()) {
                            String delegationData;
                            if (visitor != null) {
                                if (field != null) {
                                    visitor.visitField((FieldNode)field);
                                } else {
                                    Iterator returnType = setters.iterator();
                                    while (returnType.hasNext()) {
                                        MethodNode setter = (MethodNode)returnType.next();
                                        FieldNode virtual = new FieldNode(propertyName, 0, setter.getParameters()[0].getOriginType(), current, null);
                                        virtual.setDeclaringClass(setter.getDeclaringClass());
                                        visitor.visitField(virtual);
                                    }
                                }
                            }
                            SetterInfo info = new SetterInfo(current, GeneralUtils.getSetterName(propertyName), (List)setters);
                            BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
                            if (enclosingBinaryExpression != null) {
                                StaticTypeCheckingVisitor.putSetterInfo(enclosingBinaryExpression.getLeftExpression(), info);
                            }
                            if ((delegationData = (String)receiver.getData()) != null) {
                                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
                            }
                            pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                            return true;
                        }
                        if (property == null) {
                            if (field != null && StaticTypeCheckingVisitor.hasAccessToField(this.typeCheckingContext.getEnclosingClassNode(), (FieldNode)field)) {
                                pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                            } else if (getter != null) {
                                pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, Boolean.TRUE);
                            }
                        }
                    }
                }
                boolean bl = foundGetterOrSetter = foundGetterOrSetter || !setters.isEmpty() || getter != null;
                if (property != null && this.storeProperty(property, pexp, receiverType, visitor, (String)receiver.getData())) {
                    return true;
                }
                if (field == null || !this.storeField((FieldNode)field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) continue;
                return true;
            }
            ArrayList<ClassNode> dgmReceivers = new ArrayList<ClassNode>(2);
            dgmReceivers.add(receiverType);
            if (ClassHelper.isPrimitiveType(receiverType)) {
                dgmReceivers.add(ClassHelper.getWrapper(receiverType));
            }
            for (ClassNode dgmReceiver : dgmReceivers) {
                List<MethodNode> bestMethods;
                List<MethodNode> methods = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), dgmReceiver, "get" + capName, ClassNode.EMPTY_ARRAY);
                for (MethodNode method2 : StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), dgmReceiver, "is" + capName, ClassNode.EMPTY_ARRAY)) {
                    if (!ClassHelper.Boolean_TYPE.equals(ClassHelper.getWrapper(method2.getReturnType()))) continue;
                    methods.add(method2);
                }
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(dgmReceiver)) {
                    methods.removeIf(method -> !StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(dgmReceiver, ClassNode.EMPTY_ARRAY, method));
                }
                if (methods.isEmpty() || (bestMethods = StaticTypeCheckingSupport.chooseBestMethod(dgmReceiver, methods, ClassNode.EMPTY_ARRAY)).size() != 1) continue;
                MethodNode getter = bestMethods.get(0);
                if (visitor != null) {
                    visitor.visitMethod(getter);
                }
                ClassNode returnType = this.inferReturnTypeGenerics(dgmReceiver, getter, ArgumentListExpression.EMPTY_ARGUMENTS);
                this.storeInferredTypeForPropertyExpression(pexp, returnType);
                if (readMode) {
                    this.storeTargetMethod(pexp, getter);
                }
                return true;
            }
            if (receiverType.isArray() || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(receiverType)) || !pexp.isImplicitThis() || this.typeCheckingContext.getEnclosingClosure() == null) continue;
            MethodNode mopMethod = readMode ? receiverType.getMethod("get", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")}) : receiverType.getMethod("set", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "value")});
            if (mopMethod == null) {
                mopMethod = receiverType.getMethod("propertyMissing", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
            }
            if (mopMethod == null || mopMethod.isStatic() || mopMethod.isSynthetic()) continue;
            pexp.putNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION, Boolean.TRUE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            visitor.visitMethod(mopMethod);
            return true;
        }
        for (Receiver receiver : receivers) {
            receiverType = receiver.getType();
            ClassNode propertyType = this.getTypeForMapPropertyExpression(receiverType, pexp);
            if (propertyType == null) {
                propertyType = this.getTypeForListPropertyExpression(receiverType, pexp);
            }
            if (propertyType == null) {
                propertyType = this.getTypeForSpreadExpression(receiverType, pexp);
            }
            if (propertyType == null) continue;
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, propertyType, receiver.getType(), null, null, null);
                node.setDeclaringClass(receiver.getType());
                visitor.visitProperty(node);
            }
            this.storeType(pexp, propertyType);
            String delegationData = (String)receiver.getData();
            if (delegationData != null) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
            }
            return true;
        }
        return foundGetterOrSetter;
    }

    private static boolean hasAccessToField(ClassNode accessor, FieldNode field) {
        if (field.isPublic() || accessor.equals(field.getDeclaringClass())) {
            return true;
        }
        if (field.isProtected()) {
            return accessor.isDerivedFrom(field.getDeclaringClass());
        }
        return !field.isPrivate() && Objects.equals(accessor.getPackageName(), field.getDeclaringClass().getPackageName());
    }

    private MethodNode findGetter(ClassNode current, String name, boolean searchOuterClasses) {
        MethodNode getterMethod = current.getGetterMethod(name);
        if (getterMethod == null && searchOuterClasses && current.getOuterClass() != null) {
            return this.findGetter(current.getOuterClass(), name, true);
        }
        return getterMethod;
    }

    private ClassNode getTypeForMultiValueExpression(ClassNode compositeType, Expression prop) {
        GenericsType[] gts = compositeType.getGenericsTypes();
        ClassNode itemType = gts != null && gts.length == 1 ? StaticTypeCheckingSupport.getCombinedBoundType(gts[0]) : ClassHelper.OBJECT_TYPE;
        AtomicReference<ClassNode> propertyType = new AtomicReference<ClassNode>();
        if (this.existsProperty(GeneralUtils.propX((Expression)GeneralUtils.varX("{}", itemType), prop), true, new PropertyLookupVisitor(propertyType))) {
            gts = new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(propertyType.get()))};
            ClassNode listType = ClassHelper.LIST_TYPE.getPlainNodeReference();
            listType.setGenericsTypes(gts);
            return listType;
        }
        return null;
    }

    private ClassNode getTypeForSpreadExpression(ClassNode testClass, PropertyExpression pexp) {
        if (pexp.isSpreadSafe()) {
            MethodCallExpression mce = GeneralUtils.callX(GeneralUtils.varX("_", testClass), "iterator");
            mce.setImplicitThis(false);
            mce.visit(this);
            ClassNode iteratorType = this.getType(mce);
            if (GeneralUtils.isOrImplements(iteratorType, ClassHelper.Iterator_TYPE)) {
                return this.getTypeForMultiValueExpression(iteratorType, pexp.getProperty());
            }
        }
        return null;
    }

    private ClassNode getTypeForListPropertyExpression(ClassNode testClass, PropertyExpression pexp) {
        if (GeneralUtils.isOrImplements(testClass, ClassHelper.LIST_TYPE)) {
            ClassNode listType = testClass.equals(ClassHelper.LIST_TYPE) ? testClass : GenericsUtils.parameterizeType(testClass, ClassHelper.LIST_TYPE);
            return this.getTypeForMultiValueExpression(listType, pexp.getProperty());
        }
        return null;
    }

    private ClassNode getTypeForMapPropertyExpression(ClassNode testClass, PropertyExpression pexp) {
        if (GeneralUtils.isOrImplements(testClass, ClassHelper.MAP_TYPE)) {
            ClassNode mapType = testClass.equals(ClassHelper.MAP_TYPE) ? testClass : GenericsUtils.parameterizeType(testClass, ClassHelper.MAP_TYPE);
            GenericsType[] gts = mapType.getGenericsTypes();
            if (gts == null || gts.length != 2) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (!pexp.isSpreadSafe()) {
                return StaticTypeCheckingSupport.getCombinedBoundType(gts[1]);
            }
            switch (pexp.getPropertyAsString()) {
                case "key": {
                    ClassNode keyList = ClassHelper.LIST_TYPE.getPlainNodeReference();
                    keyList.setGenericsTypes(new GenericsType[]{gts[0]});
                    return keyList;
                }
                case "value": {
                    ClassNode valueList = ClassHelper.LIST_TYPE.getPlainNodeReference();
                    valueList.setGenericsTypes(new GenericsType[]{gts[1]});
                    return valueList;
                }
            }
            this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
        }
        return null;
    }

    private <T> T allowStaticAccessToMember(T member, boolean staticOnly) {
        boolean isStatic;
        if (member == null) {
            return null;
        }
        if (!staticOnly) {
            return member;
        }
        if (member instanceof Variable) {
            Variable v = (Variable)member;
            isStatic = Modifier.isStatic(v.getModifiers());
        } else {
            if (member instanceof List) {
                List list = (List)member;
                if (list.size() == 1) {
                    return (T)Collections.singletonList(this.allowStaticAccessToMember((MethodNode)list.get(0), staticOnly));
                }
                return (T)Collections.emptyList();
            }
            MethodNode mn = (MethodNode)member;
            isStatic = mn.isStatic();
        }
        if (staticOnly && !isStatic) {
            return null;
        }
        return member;
    }

    private void storeWithResolve(ClassNode type, ClassNode receiver, ClassNode declaringClass, boolean isStatic, Expression expressionToStoreOn) {
        if (GenericsUtils.hasUnresolvedGenerics(type)) {
            type = this.resolveGenericsWithContext(this.resolvePlaceHoldersFromDeclaration(receiver, declaringClass, null, isStatic), type);
        }
        if (expressionToStoreOn instanceof PropertyExpression) {
            this.storeInferredTypeForPropertyExpression((PropertyExpression)expressionToStoreOn, type);
        } else {
            this.storeType(expressionToStoreOn, type);
        }
    }

    private boolean storeField(FieldNode field, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData, boolean lhsOfAssignment) {
        if (visitor != null) {
            visitor.visitField(field);
        }
        this.checkOrMarkPrivateAccess(expressionToStoreOn, field, lhsOfAssignment);
        if (expressionToStoreOn instanceof AttributeExpression && !StaticTypeCheckingVisitor.hasAccessToField(StaticTypeCheckingVisitor.isSuperExpression(expressionToStoreOn.getObjectExpression()) ? this.typeCheckingContext.getEnclosingClassNode() : receiver, field)) {
            this.addStaticTypeError("The field " + field.getDeclaringClass().getNameWithoutPackage() + "." + field.getName() + " is not accessible", expressionToStoreOn.getProperty());
        }
        this.storeWithResolve(field.getOriginType(), receiver, field.getDeclaringClass(), field.isStatic(), expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    private boolean storeProperty(PropertyNode property, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData) {
        if (visitor != null) {
            visitor.visitProperty(property);
        }
        this.storeWithResolve(property.getOriginType(), receiver, property.getDeclaringClass(), property.isStatic(), expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, delegationData);
        }
        return true;
    }

    protected void storeInferredTypeForPropertyExpression(PropertyExpression pexp, ClassNode flatInferredType) {
        if (pexp.isSpreadSafe()) {
            ClassNode list = ClassHelper.LIST_TYPE.getPlainNodeReference();
            list.setGenericsTypes(new GenericsType[]{new GenericsType(flatInferredType)});
            this.storeType(pexp, list);
        } else {
            this.storeType(pexp, flatInferredType);
        }
    }

    @Override
    public void visitProperty(PropertyNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentProperty = node;
            this.visitAnnotations(node);
            this.visitClassCodeContainer(node.getGetterBlock());
            this.visitClassCodeContainer(node.getSetterBlock());
        }
        finally {
            this.currentProperty = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    @Override
    public void visitField(FieldNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentField = node;
            this.visitAnnotations(node);
            this.visitInitialExpression(node.getInitialExpression(), new FieldExpression(node), node);
        }
        finally {
            this.currentField = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    private void visitInitialExpression(Expression value, Expression target, ASTNode position) {
        if (value != null) {
            ClassNode lType = target.getType();
            if (ClassHelper.isFunctionalInterface(lType)) {
                this.processFunctionalInterfaceAssignment(lType, value);
            } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && value instanceof ClosureExpression) {
                this.storeInferredReturnType(value, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
            }
            this.typeCheckingContext.pushEnclosingBinaryExpression(StaticTypeCheckingVisitor.assignX(target, value, position));
            value.visit(this);
            ClassNode rType = this.getType(value);
            if (value instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)value, lType);
            }
            BinaryExpression dummy = this.typeCheckingContext.popEnclosingBinaryExpression();
            this.typeCheckAssignment(dummy, target, lType, value, this.getResultType(lType, 100, rType, dummy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            collectionExpression.visit(this);
            ClassNode collectionType = collectionExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(collectionExpression) ? this.getInferredReturnType(collectionExpression) : this.getType(collectionExpression);
            ClassNode forLoopVariableType = forLoop.getVariableType();
            ClassNode componentType = ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(forLoopVariableType)) && ClassHelper.STRING_TYPE.equals(collectionType) ? forLoopVariableType : StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            if (ClassHelper.getUnwrapper(componentType) == forLoopVariableType) {
                componentType = forLoopVariableType;
            }
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoopVariableType, componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoopVariableType.toString(false) + " with collection of type " + collectionType.toString(false), forLoop);
            }
            if (forLoopVariableType != ClassHelper.DYNAMIC_TYPE) {
                componentType = forLoopVariableType;
            }
            this.typeCheckingContext.controlStructureVariables.put(forLoop.getVariable(), componentType);
            try {
                super.visitForLoop(forLoop);
            }
            finally {
                this.typeCheckingContext.controlStructureVariables.remove(forLoop.getVariable());
            }
        }
        if (this.isSecondPassNeededForControlStructure(varOrigType, oldTracker)) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ITERABLE_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ITERABLE_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ClassHelper.MAP_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ClassHelper.MAP_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = MAP_ENTRY_TYPE.getPlainNodeReference();
                componentType.setGenericsTypes(genericsTypes);
            } else if (ClassHelper.STRING_TYPE.equals(collectionType)) {
                componentType = ClassHelper.STRING_TYPE;
            } else if (ENUMERATION_TYPE.equals(collectionType)) {
                ClassNode intf = GenericsUtils.parameterizeType(collectionType, ENUMERATION_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else {
                componentType = ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    protected boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        for (Map.Entry<VariableExpression, ClassNode> entry : this.popAssignmentTracking(oldTracker).entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry.getKey());
            if (!(key instanceof VariableExpression) || !varOrigType.containsKey(key)) continue;
            ClassNode origType = varOrigType.get(key);
            ClassNode newType = entry.getValue();
            if (newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        MethodNode mn;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isBigIntCategory(typeRe) ? type : (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE ? ClassHelper.PATTERN_TYPE : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : (typeRe.equals(ClassHelper.PATTERN_TYPE) ? ClassHelper.PATTERN_TYPE : ((mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0])) != null ? mn.getReturnType() : ClassHelper.OBJECT_TYPE))));
        this.storeType(expression, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary(expression, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary(expression, "negative");
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        Expression operand = expression.getExpression();
        int operator = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression, operand, operator);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        Expression operand = expression.getExpression();
        int operator = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression(expression, operand, operator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitPrefixOrPostifExpression(Expression origin, Expression operand, int operator) {
        Optional<Token> token = TokenUtil.asAssignment(operator);
        token.ifPresent(value -> this.typeCheckingContext.pushEnclosingBinaryExpression(GeneralUtils.binX(operand, value, GeneralUtils.constX(1))));
        try {
            MethodNode node;
            String name;
            operand.visit(this);
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(operand);
            if (setterInfo != null) {
                BinaryExpression rewrite = this.typeCheckingContext.getEnclosingBinaryExpression();
                rewrite.setSourcePosition(origin);
                if (this.ensureValidSetter(rewrite, operand, rewrite.getRightExpression(), setterInfo)) {
                    return;
                }
            }
            ClassNode operandType = this.getType(operand);
            boolean isPostfix = origin instanceof PostfixExpression;
            String string = operator == 250 ? "next" : (name = operator == 260 ? "previous" : null);
            if (name != null && ClassHelper.isNumberType(operandType)) {
                MethodNode node2;
                if (!ClassHelper.isPrimitiveType(operandType) && (node2 = this.findMethodOrFail(GeneralUtils.varX("_dummy_", operandType), operandType, name, new ClassNode[0])) != null) {
                    this.storeTargetMethod(origin, node2);
                    this.storeType(origin, isPostfix ? operandType : StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                    return;
                }
                this.storeType(origin, operandType);
                return;
            }
            if (name != null && operandType.isDerivedFrom(ClassHelper.Number_TYPE) && (node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0])) != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                return;
            }
            if (name == null) {
                this.addUnsupportedPreOrPostfixExpressionError(origin);
                return;
            }
            node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0]);
            if (node != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, isPostfix ? operandType : this.inferReturnTypeGenerics(operandType, node, ArgumentListExpression.EMPTY_ARGUMENTS));
            }
        }
        finally {
            if (token.isPresent()) {
                this.typeCheckingContext.popEnclosingBinaryExpression();
            }
        }
    }

    private static ClassNode getMathWideningClassNode(ClassNode type) {
        if (ClassHelper.byte_TYPE.equals(type) || ClassHelper.short_TYPE.equals(type) || ClassHelper.int_TYPE.equals(type)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(type) || ClassHelper.Short_TYPE.equals(type) || ClassHelper.Integer_TYPE.equals(type)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(type)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(type)) {
            return ClassHelper.Double_TYPE;
        }
        return type;
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        MethodNode mn;
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression, type, name, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.typeCheckingContext.pushEnclosingMethod(node);
        if (!this.isSkipMode(node) && !this.shouldSkipMethodNode(node)) {
            super.visitConstructorOrMethod(node, isConstructor);
        }
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.typeCheckingContext.popEnclosingMethod();
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitExpressionStatement(statement);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
        this.returnListener.returnStatementAdded(statement);
    }

    private ClassNode infer(ClassNode target, ClassNode source) {
        DeclarationExpression virtualDecl = new DeclarationExpression(GeneralUtils.varX("{target}", target), Token.newSymbol(100, -1, -1), (Expression)GeneralUtils.varX("{source}", source));
        virtualDecl.visit(this);
        ClassNode newlyInferred = (ClassNode)virtualDecl.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        return !StaticTypeCheckingSupport.missesGenericsTypes(newlyInferred) ? newlyInferred : null;
    }

    protected ClassNode checkReturnType(ReturnStatement statement) {
        Expression expression = statement.getExpression();
        ClassNode type = expression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(expression) ? this.getInferredReturnType(expression) : this.getType(expression);
        if (this.typeCheckingContext.getEnclosingClosure() != null) {
            ClassNode inferredReturnType = this.getInferredReturnType(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
            if (inferredReturnType != null && inferredReturnType.equals(ClassHelper.STRING_TYPE) && StaticTypeCheckingSupport.isGStringOrGStringStringLUB(type)) {
                type = ClassHelper.STRING_TYPE;
            }
            return type;
        }
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        if (enclosingMethod != null && !enclosingMethod.isVoidMethod()) {
            if (!(StaticTypeCheckingVisitor.isNullConstant(expression) || type.equals(ClassHelper.VOID_TYPE) || type.equals(ClassHelper.void_WRAPPER_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(enclosingMethod.getReturnType(), type, null, false))) {
                if (!this.extension.handleIncompatibleReturnType(statement, type)) {
                    this.addStaticTypeError("Cannot return value of type " + StaticTypeCheckingSupport.prettyPrintType(type) + " on method returning type " + StaticTypeCheckingSupport.prettyPrintType(enclosingMethod.getReturnType()), expression);
                }
            } else {
                ClassNode inferred;
                ClassNode previousType = this.getInferredReturnType(enclosingMethod);
                ClassNode classNode = inferred = previousType == null ? type : WideningCategories.lowestUpperBound(type, previousType);
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferred, enclosingMethod.getReturnType())) {
                    if (StaticTypeCheckingSupport.missesGenericsTypes(inferred)) {
                        ClassNode newlyInferred = this.infer(enclosingMethod.getReturnType(), type);
                        if (newlyInferred != null) {
                            type = newlyInferred;
                        }
                    } else {
                        this.checkTypeGenerics(enclosingMethod.getReturnType(), inferred, expression);
                    }
                } else {
                    return enclosingMethod.getReturnType();
                }
            }
        }
        return type;
    }

    protected void addClosureReturnType(ClassNode returnType) {
        if (returnType != null && !returnType.equals(ClassHelper.VOID_TYPE)) {
            this.typeCheckingContext.getEnclosingClosure().addReturnType(returnType);
        }
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        Set<MethodNode> methods;
        MethodNode node;
        if (this.extension.beforeMethodCall(call)) {
            this.extension.afterMethodCall(call);
            return;
        }
        ClassNode receiver = call.isThisCall() ? this.makeThis() : (call.isSuperCall() ? this.makeSuper() : call.getType());
        Expression arguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(arguments);
        this.checkForbiddenSpreadArgument(argumentList);
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        if (this.looksLikeNamedArgConstructor(receiver, args) && this.findMethod(receiver, "<init>", DefaultGroovyMethods.init(args)).size() == 1 && this.findMethod(receiver, "<init>", args).isEmpty() && (node = this.typeCheckMapConstructor(call, receiver, arguments)) != null) {
            this.storeTargetMethod(call, node);
            this.extension.afterMethodCall(call);
            return;
        }
        node = this.findMethodOrFail(call, receiver, "<init>", args);
        if (node != null) {
            if (this.looksLikeNamedArgConstructor(receiver, args) && node.getParameters().length + 1 == args.length) {
                node = this.typeCheckMapConstructor(call, receiver, arguments);
            } else {
                this.typeCheckMethodsWithGenericsOrFail(receiver, args, node, call);
            }
            if (node != null) {
                this.storeTargetMethod(call, node);
                this.visitMethodCallArguments(receiver, argumentList, true, node);
            }
        }
        if (call.isUsingAnonymousInnerClass() && !(methods = this.typeCheckingContext.methodsToBeVisited).isEmpty()) {
            this.typeCheckingContext.methodsToBeVisited = Collections.emptySet();
            ClassNode anonType = call.getType();
            this.visitClass(anonType);
            anonType.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
            this.typeCheckingContext.methodsToBeVisited = methods;
        }
        this.extension.afterMethodCall(call);
    }

    private boolean looksLikeNamedArgConstructor(ClassNode receiver, ClassNode[] argumentTypes) {
        if (argumentTypes.length == 1 || argumentTypes.length == 2 && argumentTypes[0].equals(receiver.getOuterClass())) {
            return argumentTypes[argumentTypes.length - 1].implementsInterface(ClassHelper.MAP_TYPE);
        }
        return false;
    }

    protected MethodNode typeCheckMapConstructor(ConstructorCallExpression call, ClassNode receiver, Expression arguments) {
        Expression expression;
        TupleExpression texp;
        List<Expression> expressions;
        ConstructorNode node = null;
        if (arguments instanceof TupleExpression && ((expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 || expressions.size() == 2) && (expression = expressions.get(expressions.size() - 1)) instanceof MapExpression) {
            Parameter[] parameterArray;
            MapExpression argList = (MapExpression)expression;
            this.checkGroovyConstructorMap(call, receiver, argList);
            if (expressions.size() == 1) {
                Parameter[] parameterArray2 = new Parameter[1];
                parameterArray = parameterArray2;
                parameterArray2[0] = new Parameter(ClassHelper.MAP_TYPE, "map");
            } else {
                Parameter[] parameterArray3 = new Parameter[2];
                parameterArray3[0] = new Parameter(receiver.redirect().getOuterClass(), "$p$");
                parameterArray = parameterArray3;
                parameterArray3[1] = new Parameter(ClassHelper.MAP_TYPE, "map");
            }
            Parameter[] params = parameterArray;
            node = new ConstructorNode(1, params, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
            node.setDeclaringClass(receiver);
        }
        return node;
    }

    protected ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        return (ClassNode[])args.getExpressions().stream().map(exp -> StaticTypeCheckingVisitor.isNullConstant(exp) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo((Expression)exp, this.getType((ASTNode)exp))).toArray(ClassNode[]::new);
    }

    private ClassNode getInferredTypeFromTempInfo(Expression expression, ClassNode expressionType) {
        List<ClassNode> tempTypes;
        if (expression instanceof VariableExpression && !this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (tempTypes = this.getTemporaryTypesForExpression(expression)) != null && !tempTypes.isEmpty()) {
            ArrayList<ClassNode> types = new ArrayList<ClassNode>(tempTypes.size() + 1);
            if (expressionType != null && !expressionType.equals(ClassHelper.OBJECT_TYPE) && tempTypes.stream().noneMatch(t -> StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(t, expressionType))) {
                types.add(expressionType);
            }
            types.addAll(tempTypes);
            if (types.isEmpty()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (types.size() == 1) {
                return (ClassNode)types.get(0);
            }
            return new UnionTypeClassNode(types.toArray(ClassNode.EMPTY_ARRAY));
        }
        return expressionType;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        HashMap<VariableExpression, Map<StaticTypesMarker, Object>> variableMetadata;
        boolean oldStaticContext = this.typeCheckingContext.isInStaticContext;
        this.typeCheckingContext.isInStaticContext = false;
        HashMap<VariableExpression, ClassNode> varTypes = new HashMap<VariableExpression, ClassNode>();
        expression.getCode().visit(new VariableExpressionTypeMemoizer(varTypes, true));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set<VariableExpression> closureSharedVariables = collector.getClosureSharedExpressions();
        if (!closureSharedVariables.isEmpty()) {
            for (VariableExpression ve : closureSharedVariables) {
                this.getType(ve);
            }
            variableMetadata = new HashMap<VariableExpression, Map<StaticTypesMarker, Object>>();
            this.saveVariableExpressionMetadata(closureSharedVariables, variableMetadata);
        } else {
            variableMetadata = null;
        }
        this.typeCheckingContext.pushEnclosingClosureExpression(expression);
        DelegationMetadata dmd = this.getDelegationMetadata(expression);
        this.typeCheckingContext.delegationMetadata = dmd == null ? new DelegationMetadata(this.typeCheckingContext.getEnclosingClassNode(), 0, this.typeCheckingContext.delegationMetadata) : new DelegationMetadata(dmd.getType(), dmd.getStrategy(), this.typeCheckingContext.delegationMetadata);
        super.visitClosureExpression(expression);
        this.typeCheckingContext.delegationMetadata = this.typeCheckingContext.delegationMetadata.getParent();
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, expression.getCode());
        this.returnAdder.visitMethod(node);
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (!enclosingClosure.getReturnTypes().isEmpty()) {
            ClassNode returnType = WideningCategories.lowestUpperBound(enclosingClosure.getReturnTypes());
            ClassNode expectedReturnType = this.getInferredReturnType(expression);
            if (expectedReturnType != null && ClassHelper.isPrimitiveType(returnType) && expectedReturnType.equals(ClassHelper.getWrapper(returnType))) {
                returnType = expectedReturnType;
            }
            this.storeInferredReturnType(expression, returnType);
            ClassNode inferredType = StaticTypeCheckingVisitor.wrapClosureType(returnType);
            this.storeType(enclosingClosure.getClosureExpression(), inferredType);
        }
        this.typeCheckingContext.popEnclosingClosure();
        if (this.isSecondPassNeededForControlStructure(varTypes, oldTracker)) {
            this.visitClosureExpression(expression);
        }
        this.restoreVariableExpressionMetadata(variableMetadata);
        this.typeCheckingContext.isInStaticContext = oldStaticContext;
        for (Parameter parameter : ClosureUtils.getParametersSafe(expression)) {
            this.typeCheckingContext.controlStructureVariables.remove(parameter);
        }
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        super.visitMethodPointerExpression(expression);
        Expression nameExpr = expression.getMethodName();
        if (nameExpr instanceof ConstantExpression && this.getType(nameExpr).equals(ClassHelper.STRING_TYPE)) {
            String nameText = nameExpr.getText();
            if ("new".equals(nameText)) {
                ClassNode receiverType = this.getType(expression.getExpression());
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiverType)) {
                    this.storeType(expression, StaticTypeCheckingVisitor.wrapClosureType(receiverType));
                }
                return;
            }
            ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(expression.getExpression()), false);
            List<MethodNode> candidates = EMPTY_METHODNODE_LIST;
            for (Receiver receiver : receivers) {
                ClassNode receiverType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(receiver.getType());
                candidates = this.findMethodsWithGenerated(receiverType, nameText);
                if (StaticTypeCheckingSupport.isBeingCompiled(receiverType)) {
                    candidates.addAll(ClassHelper.GROOVY_OBJECT_TYPE.getMethods(nameText));
                }
                candidates.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(this.getSourceUnit().getClassLoader(), receiverType, nameText));
                if ((candidates = StaticTypeCheckingSupport.filterMethodsByVisibility(candidates, this.typeCheckingContext.getEnclosingClassNode())).isEmpty()) continue;
                break;
            }
            if (candidates.isEmpty()) {
                candidates = this.extension.handleMissingMethod(this.getType(expression.getExpression()), nameText, null, null, null);
            } else if (candidates.size() > 1) {
                candidates = this.extension.handleAmbiguousMethods(candidates, expression);
            }
            if (!candidates.isEmpty()) {
                candidates.stream().map(MethodNode::getReturnType).reduce(WideningCategories::lowestUpperBound).filter(returnType -> !returnType.equals(ClassHelper.OBJECT_TYPE)).ifPresent(returnType -> this.storeType(expression, StaticTypeCheckingVisitor.wrapClosureType(returnType)));
                expression.putNodeMetaData(MethodNode.class, candidates);
            } else if (!(expression instanceof MethodReferenceExpression)) {
                ClassNode type = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType(expression.getExpression()));
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(type)) {
                    type = type.getGenericsTypes()[0].getType();
                }
                this.addStaticTypeError("Cannot find matching method " + type.getText() + "#" + nameText + ". Please check if the declared type is correct and if the method exists.", nameExpr);
            }
        }
    }

    private static ClassNode wrapClosureType(ClassNode returnType) {
        ClassNode inferredType = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
        inferredType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(returnType))});
        return inferredType;
    }

    protected DelegationMetadata getDelegationMetadata(ClosureExpression expression) {
        return (DelegationMetadata)expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
    }

    protected void restoreVariableExpressionMetadata(Map<VariableExpression, Map<StaticTypesMarker, Object>> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, Map<StaticTypesMarker, Object>> entry : typesBeforeVisit.entrySet()) {
                for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                    if (marker == StaticTypesMarker.INFERRED_TYPE) continue;
                    Object value = entry.getValue().get((Object)marker);
                    if (value == null) {
                        entry.getKey().removeNodeMetaData((Object)marker);
                        continue;
                    }
                    entry.getKey().putNodeMetaData((Object)marker, value);
                }
            }
        }
    }

    protected void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, Map<StaticTypesMarker, Object>> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            Variable v;
            while ((v = ve.getAccessedVariable()) != ve && v instanceof VariableExpression) {
                ve = (VariableExpression)v;
            }
            EnumMap metadata = new EnumMap(StaticTypesMarker.class);
            for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                Object value = ve.getNodeMetaData((Object)marker);
                if (value == null) continue;
                metadata.put(marker, value);
            }
            typesBeforeVisit.put(ve, metadata);
        }
    }

    protected boolean shouldSkipMethodNode(MethodNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(StaticTypeCheckingVisitor.class));
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitMethod(node)) {
            ErrorCollector collector = (ErrorCollector)node.getNodeMetaData(ERROR_COLLECTOR);
            if (collector != null) {
                this.typeCheckingContext.getErrorCollector().addCollectorContents(collector);
            } else {
                this.startMethodInference(node, this.typeCheckingContext.getErrorCollector());
            }
            node.removeNodeMetaData(ERROR_COLLECTOR);
        }
        this.extension.afterVisitMethod(node);
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        super.visitConstructor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMethodInference(MethodNode node, ErrorCollector collector) {
        if (this.isSkipMode(node)) {
            return;
        }
        if (!this.typeCheckingContext.methodsToBeVisited.isEmpty() && !this.typeCheckingContext.methodsToBeVisited.contains(node)) {
            return;
        }
        if (this.typeCheckingContext.alreadyVisitedMethods.contains(node)) {
            return;
        }
        this.typeCheckingContext.alreadyVisitedMethods.add(node);
        this.typeCheckingContext.pushErrorCollector(collector);
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isStatic();
            super.visitMethod(node);
        }
        finally {
            this.typeCheckingContext.isInStaticContext = osc;
        }
        this.typeCheckingContext.popErrorCollector();
        node.putNodeMetaData(ERROR_COLLECTOR, collector);
    }

    protected void addTypeCheckingInfoAnnotation(MethodNode node) {
        if (node instanceof ConstructorNode) {
            return;
        }
        ClassNode rtype = this.getInferredReturnType(node);
        if (rtype != null && node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            AnnotationNode anno = new AnnotationNode(TYPECHECKING_INFO_NODE);
            anno.setMember("version", CURRENT_SIGNATURE_PROTOCOL);
            SignatureCodec codec = SignatureCodecFactory.getCodec(1, this.getTransformLoader());
            String genericsSignature = codec.encode(rtype);
            if (genericsSignature != null) {
                ConstantExpression signature = new ConstantExpression(genericsSignature);
                signature.setType(ClassHelper.STRING_TYPE);
                anno.setMember("inferredType", signature);
                node.addAnnotation(anno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        String name = call.getMethod();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call);
            return;
        }
        if (this.extension.beforeMethodCall(call)) {
            this.extension.afterMethodCall(call);
            return;
        }
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = call.getOwnerType();
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        try {
            LinkedList<Receiver<String>> receivers = new LinkedList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(new ClassExpression(receiver)), false);
            List<MethodNode> mn = null;
            Receiver chosenReceiver = null;
            for (Receiver receiver2 : receivers) {
                mn = this.findMethod(receiver2.getType(), name, args);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    StaticTypeCheckingVisitor.resolvePlaceholdersFromImplicitTypeHints(args, argumentList, mn.get(0));
                    this.typeCheckMethodsWithGenericsOrFail(receiver2.getType(), args, mn.get(0), call);
                }
                chosenReceiver = receiver2;
                break;
            }
            if (mn.isEmpty()) {
                mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, call);
            }
            boolean callArgsVisited = false;
            if (mn.isEmpty()) {
                this.addNoMatchingMethodError(receiver, name, args, call);
            } else {
                if ((mn = this.disambiguateMethods(mn, receiver, args, call)).size() == 1) {
                    MethodNode methodNode = mn.get(0);
                    ClassNode returnType = this.getType(methodNode);
                    if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                        this.visitMethodCallArguments(receiver, argumentList, true, methodNode);
                        ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), methodNode, callArguments);
                        returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        callArgsVisited = true;
                    }
                    this.storeType(call, returnType);
                    this.storeTargetMethod(call, methodNode);
                } else {
                    this.addAmbiguousErrorMessage(mn, name, args, call);
                }
                if (!callArgsVisited) {
                    this.visitMethodCallArguments(receiver, argumentList, true, (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                }
            }
        }
        finally {
            this.extension.afterMethodCall(call);
        }
    }

    @Deprecated
    protected void checkClosureParameters(Expression callArguments, ClassNode receiver) {
        if (callArguments instanceof ArgumentListExpression) {
            Parameter param;
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
            Parameter[] parameters = closure.getParameters();
            if (parameters.length > 1) {
                this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
            } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
            }
            closure.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(receiver, 1, this.typeCheckingContext.delegationMetadata));
        }
    }

    protected void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector collector = new ErrorCollector(this.typeCheckingContext.getErrorCollector().getConfiguration());
        this.startMethodInference(directMethodCallCandidate, collector);
    }

    protected void visitMethodCallArguments(ClassNode receiver, ArgumentListExpression arguments, boolean visitClosures, MethodNode selectedMethod) {
        Parameter[] params = selectedMethod != null ? selectedMethod.getParameters() : Parameter.EMPTY_ARRAY;
        LinkedList<Expression> expressions = new LinkedList<Expression>(arguments.getExpressions());
        if (selectedMethod instanceof ExtensionMethodNode) {
            params = ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode().getParameters();
            expressions.add(0, GeneralUtils.varX("$self", receiver));
        }
        ArgumentListExpression newArgs = GeneralUtils.args(expressions);
        int nExpressions = expressions.size();
        for (int i = 0; i < nExpressions; ++i) {
            Expression expression = (Expression)expressions.get(i);
            if ((!visitClosures || !(expression instanceof ClosureExpression)) && (visitClosures || expression instanceof ClosureExpression)) continue;
            if (i < params.length && visitClosures) {
                Parameter target = params[i];
                ClassNode targetType = target.getType();
                ClosureExpression source = (ClosureExpression)expression;
                this.checkClosureWithDelegatesTo(receiver, selectedMethod, newArgs, params, source, target);
                if (selectedMethod instanceof ExtensionMethodNode) {
                    if (i > 0) {
                        this.inferClosureParameterTypes(receiver, arguments, source, target, selectedMethod);
                    }
                } else {
                    this.inferClosureParameterTypes(receiver, newArgs, source, target, selectedMethod);
                }
                if (ClassHelper.isFunctionalInterface(targetType)) {
                    this.storeInferredReturnType(source, GenericsUtils.parameterizeSAM(targetType).getV2());
                } else if (StaticTypeCheckingVisitor.isClosureWithType(targetType)) {
                    this.storeInferredReturnType(source, StaticTypeCheckingSupport.getCombinedBoundType(targetType.getGenericsTypes()[0]));
                }
            }
            expression.visit(this);
            expression.removeNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
        }
        if (nExpressions > 0 && expressions.get(0) instanceof MapExpression && params.length > 0) {
            this.checkNamedParamsAnnotation(params[0], (MapExpression)expressions.get(0));
        }
        if (visitClosures) {
            this.inferMethodReferenceType(receiver, arguments, selectedMethod);
        }
    }

    private void checkNamedParamsAnnotation(Parameter param, MapExpression args) {
        if (!GeneralUtils.isOrImplements(param.getType(), ClassHelper.MAP_TYPE)) {
            return;
        }
        List<MapEntryExpression> entryExpressions = args.getMapEntryExpressions();
        LinkedHashMap<Object, Expression> entries = new LinkedHashMap<Object, Expression>();
        for (MapEntryExpression entry : entryExpressions) {
            Object key = entry.getKeyExpression();
            if (key instanceof ConstantExpression) {
                key = ((ConstantExpression)key).getValue();
            }
            entries.put(key, entry.getValueExpression());
        }
        List<AnnotationNode> annotations = param.getAnnotations(NAMED_PARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            AnnotationNode an = null;
            for (AnnotationNode next : annotations) {
                if (!next.getClassNode().getName().equals(NamedParams.class.getName())) continue;
                an = next;
            }
            ArrayList<String> collectedNames = new ArrayList<String>();
            if (an != null) {
                Expression value = an.getMember("value");
                if (value instanceof AnnotationConstantExpression) {
                    this.processNamedParam((AnnotationConstantExpression)value, entries, args, collectedNames);
                } else if (value instanceof ListExpression) {
                    ListExpression le = (ListExpression)value;
                    for (Expression next : le.getExpressions()) {
                        if (!(next instanceof AnnotationConstantExpression)) continue;
                        this.processNamedParam((AnnotationConstantExpression)next, entries, args, collectedNames);
                    }
                }
                for (Map.Entry entry : entries.entrySet()) {
                    if (collectedNames.contains(entry.getKey())) continue;
                    this.addStaticTypeError("unexpected named arg: " + entry.getKey(), args);
                }
            }
        }
    }

    private void processNamedParam(AnnotationConstantExpression value, Map<Object, Expression> entries, Expression expression, List<String> collectedNames) {
        ClassNode argumentType;
        ClassExpression typeX;
        AnnotationNode namedParam = (AnnotationNode)value.getValue();
        if (!namedParam.getClassNode().getName().equals(NamedParam.class.getName())) {
            return;
        }
        String name = null;
        boolean required = false;
        ClassNode expectedType = null;
        ConstantExpression constX = (ConstantExpression)namedParam.getMember("value");
        if (constX != null) {
            name = (String)constX.getValue();
            collectedNames.add(name);
        }
        if ((constX = (ConstantExpression)namedParam.getMember("required")) != null) {
            required = (Boolean)constX.getValue();
        }
        if ((typeX = (ClassExpression)namedParam.getMember("type")) != null) {
            expectedType = typeX.getType();
        }
        if (!entries.containsKey(name)) {
            if (required) {
                this.addStaticTypeError("required named param '" + name + "' not found.", expression);
            }
        } else if (expectedType != null && !StaticTypeCheckingSupport.isAssignableTo(argumentType = this.getDeclaredOrInferredType(entries.get(name)), expectedType)) {
            this.addStaticTypeError("argument for named param '" + name + "' has type '" + StaticTypeCheckingSupport.prettyPrintType(argumentType) + "' but expected '" + StaticTypeCheckingSupport.prettyPrintType(expectedType) + "'.", expression);
        }
    }

    protected void inferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, Parameter param, MethodNode selectedMethod) {
        List<AnnotationNode> annotations = param.getAnnotations(CLOSUREPARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression hintClass = annotation.getMember("value");
                Expression options = annotation.getMember("options");
                Expression resolverClass = annotation.getMember("conflictResolutionStrategy");
                if (!(hintClass instanceof ClassExpression)) continue;
                this.doInferClosureParameterTypes(receiver, arguments, expression, selectedMethod, hintClass, resolverClass, options);
            }
        } else if (ClassHelper.isSAMType(param.getOriginType())) {
            this.inferSAMType(param, receiver, selectedMethod, InvocationWriter.makeArgumentList(arguments), expression);
        }
    }

    private void inferSAMType(Parameter param, ClassNode receiver, MethodNode methodWithSAMParameter, ArgumentListExpression originalMethodCallArguments, ClosureExpression openBlock) {
        int i;
        HashMap<GenericsType.GenericsTypeName, GenericsType> targetMethodConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        for (ClassNode face : receiver.getAllInterfaces()) {
            StaticTypeCheckingSupport.extractGenericsConnections(targetMethodConnections, StaticTypeCheckingSupport.getCorrectedClassNode(receiver, face, true), face.redirect());
        }
        if (!receiver.isInterface()) {
            StaticTypeCheckingSupport.extractGenericsConnections(targetMethodConnections, receiver, receiver.redirect());
        }
        Parameter[] parametersOfMethodContainingSAM = methodWithSAMParameter.getParameters();
        int n = parametersOfMethodContainingSAM.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Expression callArg;
            ClassNode parameterType = parametersOfMethodContainingSAM[i2].getType();
            if (i2 == n - 1 && i2 == originalMethodCallArguments.getExpressions().size() && parameterType.isArray() || (callArg = originalMethodCallArguments.getExpression(i2)) == openBlock) continue;
            StaticTypeCheckingSupport.extractGenericsConnections(targetMethodConnections, this.getType(callArg), parameterType);
        }
        ClassNode paramTypeWithReceiverInformation = StaticTypeCheckingSupport.applyGenericsContext(targetMethodConnections, param.getOriginType());
        HashMap<GenericsType.GenericsTypeName, GenericsType> samTypeConnections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        ClassNode samTypeRedirect = paramTypeWithReceiverInformation.redirect();
        StaticTypeCheckingSupport.extractGenericsConnections(samTypeConnections, paramTypeWithReceiverInformation, samTypeRedirect);
        MethodNode abstractMethod = ClassHelper.findSAM(samTypeRedirect);
        ClassNode[] abstractMethodParamTypes = StaticTypeCheckingVisitor.extractTypesFromParameters(abstractMethod.getParameters());
        ClassNode[] blockParamTypes = (ClassNode[])openBlock.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        if (blockParamTypes == null) {
            Parameter[] p = openBlock.getParameters();
            if (p == null) {
                blockParamTypes = ClassNode.EMPTY_ARRAY;
            } else if (p.length == 0 && abstractMethodParamTypes.length != 0) {
                blockParamTypes = abstractMethodParamTypes;
            } else {
                blockParamTypes = new ClassNode[p.length];
                int n2 = p.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    blockParamTypes[i3] = p[i3] != null && !p[i3].isDynamicTyped() ? p[i3].getType() : StaticTypeCheckingVisitor.typeOrNull(abstractMethodParamTypes, i3);
                }
            }
        }
        int n3 = blockParamTypes.length;
        for (i = 0; i < n3; ++i) {
            StaticTypeCheckingSupport.extractGenericsConnections(samTypeConnections, blockParamTypes[i], StaticTypeCheckingVisitor.typeOrNull(abstractMethodParamTypes, i));
        }
        n3 = blockParamTypes.length;
        for (i = 0; i < n3; ++i) {
            blockParamTypes[i] = StaticTypeCheckingSupport.applyGenericsContext(samTypeConnections, StaticTypeCheckingVisitor.typeOrNull(abstractMethodParamTypes, i));
        }
        this.tryToInferUnresolvedBlockParameterType(paramTypeWithReceiverInformation, abstractMethod, blockParamTypes);
        openBlock.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, blockParamTypes);
    }

    private void tryToInferUnresolvedBlockParameterType(ClassNode paramTypeWithReceiverInformation, MethodNode methodForSAM, ClassNode[] blockParameterTypes) {
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        int n = blockParameterTypes.length;
        for (int i = 0; i < n; ++i) {
            ClassNode blockParameterType = blockParameterTypes[i];
            if (blockParameterType == null || !blockParameterType.isGenericsPlaceHolder()) continue;
            indexList.add(i);
        }
        if (!indexList.isEmpty()) {
            Map<GenericsType, GenericsType> genericsTypeMap = GenericsUtils.makeDeclaringAndActualGenericsTypeMapOfExactType(methodForSAM.getDeclaringClass(), paramTypeWithReceiverInformation);
            block1: for (Integer index : indexList) {
                for (Map.Entry<GenericsType, GenericsType> entry : genericsTypeMap.entrySet()) {
                    if (!entry.getKey().getName().equals(blockParameterTypes[index].getUnresolvedName())) continue;
                    ClassNode type = entry.getValue().getType();
                    if (type == null || type.isGenericsPlaceHolder()) continue block1;
                    blockParameterTypes[index.intValue()] = type;
                    continue block1;
                }
            }
        }
    }

    private static ClassNode typeOrNull(ClassNode[] parameterTypesForSAM, int i) {
        return i < parameterTypesForSAM.length ? parameterTypesForSAM[i] : null;
    }

    private List<ClassNode[]> getSignaturesFromHint(ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression options) {
        List<ClassNode[]> closureSignatures;
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> hint = transformLoader.loadClass(hintClass.getText());
            ClosureSignatureHint hintInstance = (ClosureSignatureHint)hint.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            closureSignatures = hintInstance.getClosureSignatures(selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options), expression);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
        return closureSignatures;
    }

    private List<ClassNode[]> resolveWithResolver(List<ClassNode[]> candidates, ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression resolverClass, Expression options) {
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> resolver = transformLoader.loadClass(resolverClass.getText());
            ClosureSignatureConflictResolver resolverInstance = (ClosureSignatureConflictResolver)resolver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return resolverInstance.resolve(candidates, receiver, arguments, expression, selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
    }

    private ClassLoader getTransformLoader() {
        return Optional.ofNullable(this.typeCheckingContext.getCompilationUnit()).map(CompilationUnit::getTransformLoader).orElseGet(() -> this.getSourceUnit().getClassLoader());
    }

    private void doInferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression resolverClass, Expression options) {
        Parameter[] closureParams = expression.getParameters();
        if (closureParams == null) {
            return;
        }
        List<ClassNode[]> closureSignatures = this.getSignaturesFromHint(expression, selectedMethod, hintClass, options);
        List<ClassNode[]> candidates = new LinkedList<ClassNode[]>();
        for (ClassNode[] signature : closureSignatures) {
            ClassNode[] inferred = this.resolveGenericsFromTypeHint(receiver, arguments, selectedMethod, signature);
            if (signature.length != closureParams.length && (signature.length != 1 || closureParams.length != 0) && (closureParams.length <= signature.length || !inferred[inferred.length - 1].isArray())) continue;
            candidates.add(inferred);
        }
        if (candidates.size() > 1) {
            Iterator candIt = candidates.iterator();
            while (candIt.hasNext()) {
                ClassNode[] inferred = (ClassNode[])candIt.next();
                int n = closureParams.length;
                for (int i = 0; i < n; ++i) {
                    ClassNode inferredType;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            candIt.remove();
                            continue;
                        }
                    }
                    if (StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, i == n - 1)) continue;
                    candIt.remove();
                }
            }
            if (candidates.size() > 1 && resolverClass instanceof ClassExpression) {
                candidates = this.resolveWithResolver(candidates, receiver, arguments, expression, selectedMethod, resolverClass, options);
            }
            if (candidates.size() > 1) {
                this.addError("Ambiguous prototypes for closure. More than one target method matches. Please use explicit argument types.", expression);
            }
        }
        if (candidates.size() == 1) {
            ClassNode[] inferred = (ClassNode[])candidates.get(0);
            if (closureParams.length == 0 && inferred.length == 1) {
                expression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, inferred);
            } else {
                int n = closureParams.length;
                for (int i = 0; i < n; ++i) {
                    boolean lastArg;
                    Parameter closureParam = closureParams[i];
                    ClassNode originType = closureParam.getOriginType();
                    ClassNode inferredType = ClassHelper.OBJECT_TYPE;
                    if (i < inferred.length - 1 || inferred.length == closureParams.length) {
                        inferredType = inferred[i];
                    } else {
                        ClassNode lastArgInferred = inferred[inferred.length - 1];
                        if (lastArgInferred.isArray()) {
                            inferredType = lastArgInferred.getComponentType();
                        } else {
                            this.addError("Incorrect number of parameters. Expected " + inferred.length + " but found " + closureParams.length, expression);
                        }
                    }
                    boolean bl = lastArg = i == n - 1;
                    if (!StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(originType, inferredType, lastArg)) {
                        this.addError("Expected parameter of type " + inferredType.toString(false) + " but got " + originType.toString(false), closureParam.getType());
                    }
                    this.typeCheckingContext.controlStructureVariables.put(closureParam, inferredType);
                }
            }
        }
    }

    private ClassNode[] resolveGenericsFromTypeHint(ClassNode receiver, Expression arguments, MethodNode selectedMethod, ClassNode[] signature) {
        ClassNode dummyResultNode = new ClassNode("ClForInference$" + UNIQUE_LONG.incrementAndGet(), 0, ClassHelper.OBJECT_TYPE).getPlainNodeReference();
        GenericsType[] genericTypes = new GenericsType[signature.length];
        int n = signature.length;
        for (int i = 0; i < n; ++i) {
            genericTypes[i] = new GenericsType(signature[i]);
        }
        dummyResultNode.setGenericsTypes(genericTypes);
        MethodNode dummyMN = selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod;
        dummyMN = new MethodNode(dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, dummyMN.getParameters(), dummyMN.getExceptions(), EmptyStatement.INSTANCE);
        dummyMN.setDeclaringClass(selectedMethod.getDeclaringClass());
        dummyMN.setGenericsTypes(selectedMethod.getGenericsTypes());
        if (selectedMethod instanceof ExtensionMethodNode) {
            ExtensionMethodNode orig = (ExtensionMethodNode)selectedMethod;
            dummyMN = new ExtensionMethodNode(dummyMN, dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, orig.getParameters(), orig.getExceptions(), EmptyStatement.INSTANCE, orig.isStaticExtension());
            dummyMN.setDeclaringClass(orig.getDeclaringClass());
            dummyMN.setGenericsTypes(orig.getGenericsTypes());
        }
        ClassNode classNode = this.inferReturnTypeGenerics(receiver, dummyMN, arguments);
        ClassNode[] inferred = new ClassNode[classNode.getGenericsTypes().length];
        for (int i = 0; i < classNode.getGenericsTypes().length; ++i) {
            ClassNode value;
            GenericsType genericsType = classNode.getGenericsTypes()[i];
            inferred[i] = value = StaticTypeCheckingVisitor.createUsableClassNodeFromGenericsType(genericsType);
        }
        return inferred;
    }

    private static ClassNode createUsableClassNodeFromGenericsType(GenericsType genericsType) {
        ClassNode lowerBound;
        ClassNode value = genericsType.getType();
        if (genericsType.isPlaceholder()) {
            ClassNode classNode = value = value.isRedirectNode() ? value.redirect() : ClassHelper.OBJECT_TYPE;
        }
        if ((lowerBound = genericsType.getLowerBound()) != null) {
            value = lowerBound;
        } else {
            ClassNode[] upperBounds = genericsType.getUpperBounds();
            if (upperBounds != null) {
                value = WideningCategories.lowestUpperBound(Arrays.asList(upperBounds));
            }
        }
        return value;
    }

    private static String[] convertToStringArray(Expression options) {
        if (options == null) {
            return ResolveVisitor.EMPTY_STRING_ARRAY;
        }
        if (options instanceof ConstantExpression) {
            return new String[]{options.getText()};
        }
        if (options instanceof ListExpression) {
            return (String[])((ListExpression)options).getExpressions().stream().map(ASTNode::getText).toArray(String[]::new);
        }
        throw new IllegalArgumentException("Unexpected options for @ClosureParams:" + options);
    }

    private void checkClosureWithDelegatesTo(ClassNode receiver, MethodNode mn, ArgumentListExpression arguments, Parameter[] params, Expression expression, Parameter param) {
        List<AnnotationNode> annotations = param.getAnnotations(DELEGATES_TO);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                Expression strategy = annotation.getMember("strategy");
                Expression genericTypeIndex = annotation.getMember("genericTypeIndex");
                Expression type = annotation.getMember("type");
                Integer stInt = 0;
                if (strategy != null) {
                    stInt = (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(ClassHelper.Integer_TYPE, strategy), this.getSourceUnit().getConfiguration());
                }
                if (value instanceof ClassExpression && !value.getType().equals(DELEGATES_TO_TARGET)) {
                    if (genericTypeIndex != null) {
                        this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") without @DelegatesTo.Target because generic argument types are not available at runtime", value);
                    }
                    expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(value.getType(), stInt, this.typeCheckingContext.delegationMetadata));
                    continue;
                }
                if (type != null && !"".equals(type.getText()) && type instanceof ConstantExpression) {
                    String typeString = type.getText();
                    ClassNode[] resolved = GenericsUtils.parseClassNodesFromString(typeString, this.getSourceUnit(), this.typeCheckingContext.getCompilationUnit(), mn, type);
                    if (resolved == null) continue;
                    if (resolved.length == 1) {
                        resolved = this.resolveGenericsFromTypeHint(receiver, arguments, mn, resolved);
                        expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(resolved[0], stInt, this.typeCheckingContext.delegationMetadata));
                        continue;
                    }
                    this.addStaticTypeError("Incorrect type hint found in method " + mn, type);
                    continue;
                }
                List<Expression> expressions = arguments.getExpressions();
                int expressionsSize = expressions.size();
                Expression parameter = annotation.getMember("target");
                String parameterName = parameter instanceof ConstantExpression ? parameter.getText() : "";
                int paramsLength = params.length;
                for (int j = 0; j < paramsLength; ++j) {
                    String id;
                    Parameter methodParam = params[j];
                    List<AnnotationNode> targets = methodParam.getAnnotations(DELEGATES_TO_TARGET);
                    if (targets == null || targets.size() != 1) continue;
                    AnnotationNode targetAnnotation = targets.get(0);
                    Expression idMember = targetAnnotation.getMember("value");
                    String string = id = idMember instanceof ConstantExpression ? idMember.getText() : "";
                    if (!id.equals(parameterName) || j >= expressionsSize) continue;
                    Expression actualArgument = expressions.get(j);
                    ClassNode actualType = this.getType(actualArgument);
                    if (genericTypeIndex instanceof ConstantExpression) {
                        int gti = Integer.parseInt(genericTypeIndex.getText());
                        ClassNode paramType = methodParam.getType();
                        GenericsType[] genericsTypes = paramType.getGenericsTypes();
                        if (genericsTypes == null) {
                            this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") with a type that doesn't use generics", methodParam);
                        } else if (gti < 0 || gti >= genericsTypes.length) {
                            this.addStaticTypeError("Index of generic type @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") " + (gti < 0 ? "lower" : "greater") + " than those of the selected type", methodParam);
                        } else {
                            ClassNode pType = GenericsUtils.parameterizeType(actualType, paramType);
                            GenericsType[] pTypeGenerics = pType.getGenericsTypes();
                            if (pTypeGenerics != null && pTypeGenerics.length > gti) {
                                actualType = pTypeGenerics[gti].getType();
                            } else {
                                this.addStaticTypeError("Unable to map actual type [" + actualType.toString(false) + "] onto " + paramType.toString(false), methodParam);
                            }
                        }
                    }
                    expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, new DelegationMetadata(actualType, stInt, this.typeCheckingContext.delegationMetadata));
                    break;
                }
                if (expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA) != null) continue;
                this.addError("Not enough arguments found for a @DelegatesTo method call. Please check that you either use an explicit class or @DelegatesTo.Target with a correct id", annotation);
            }
        }
    }

    protected void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, boolean implicitThis) {
        if (!implicitThis || this.typeCheckingContext.delegationMetadata == null) {
            receivers.addAll(owners);
        } else {
            StaticTypeCheckingVisitor.addReceivers(receivers, owners, this.typeCheckingContext.delegationMetadata, "");
        }
    }

    private static void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, DelegationMetadata dmd, String path) {
        int strategy = dmd.getStrategy();
        switch (strategy) {
            case 1: 
            case 3: {
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
                if (strategy != 1) break;
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                    break;
                }
                StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                break;
            }
            case 0: 
            case 2: {
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                } else {
                    StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), path + "owner.");
                }
                if (strategy != 0) break;
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), path + "delegate");
            }
        }
    }

    private static void addDelegateReceiver(List<Receiver<String>> receivers, ClassNode delegate, String path) {
        if (receivers.stream().map(Receiver::getType).noneMatch(delegate::equals)) {
            receivers.add(new Receiver<String>(delegate, path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        block49: {
            String name = call.getMethodAsString();
            if (name == null) {
                this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call.getMethod());
                return;
            }
            if (this.extension.beforeMethodCall(call)) {
                this.extension.afterMethodCall(call);
                return;
            }
            this.typeCheckingContext.pushEnclosingMethodCall(call);
            Expression objectExpression = call.getObjectExpression();
            objectExpression.visit(this);
            call.getMethod().visit(this);
            if (call.isSpreadSafe()) {
                ClassNode expressionType = this.getType(objectExpression);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.isArray()) {
                    this.addStaticTypeError("Spread operator can only be used on collection types", objectExpression);
                    return;
                }
                ClassNode componentType = this.inferComponentType(expressionType, ClassHelper.int_TYPE);
                MethodCallExpression subcall = GeneralUtils.callX((Expression)GeneralUtils.castX(componentType, EmptyExpression.INSTANCE), name, call.getArguments());
                subcall.setLineNumber(call.getLineNumber());
                subcall.setColumnNumber(call.getColumnNumber());
                subcall.setImplicitThis(call.isImplicitThis());
                this.visitMethodCallExpression(subcall);
                ClassNode subcallReturnType = this.getType(subcall);
                ClassNode listNode = ClassHelper.LIST_TYPE.getPlainNodeReference();
                listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
                this.storeType(call, listNode);
                this.storeTargetMethod(call, (MethodNode)subcall.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                this.typeCheckingContext.popEnclosingMethodCall();
                return;
            }
            Expression callArguments = call.getArguments();
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
            this.checkForbiddenSpreadArgument(argumentList);
            ClassNode receiver = this.getType(objectExpression);
            this.visitMethodCallArguments(receiver, argumentList, false, null);
            ClassNode[] args = this.getArgumentTypes(argumentList);
            boolean isCallOnClosure = this.isClosureCall(name, objectExpression, callArguments);
            try {
                Parameter[] parameters;
                boolean callArgsVisited = false;
                if (isCallOnClosure) {
                    int nbOfArgs;
                    Object data;
                    if (StaticTypeCheckingVisitor.isThisExpression(objectExpression)) {
                        FieldNode field = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
                        GenericsType[] genericsTypes = field.getType().getGenericsTypes();
                        if (genericsTypes != null) {
                            ClassNode closureReturnType = genericsTypes[0].getType();
                            Object data2 = field.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                            if (data2 != null) {
                                Parameter[] parameterArray = (Parameter[])data2;
                                this.typeCheckClosureCall(callArguments, args, parameterArray);
                            }
                            this.storeType(call, closureReturnType);
                        }
                    } else if (objectExpression instanceof VariableExpression) {
                        Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                        if (variable instanceof ASTNode) {
                            ClassNode type;
                            data = ((ASTNode)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                            if (data != null) {
                                parameters = (Parameter[])data;
                                this.typeCheckClosureCall(callArguments, args, parameters);
                            }
                            if (ClassHelper.CLOSURE_TYPE.equals(type = this.getType((ASTNode)((Object)variable)))) {
                                GenericsType[] genericsTypes = type.getGenericsTypes();
                                type = genericsTypes != null && genericsTypes.length == 1 && genericsTypes[0].getLowerBound() == null ? StaticTypeCheckingSupport.getCombinedBoundType(genericsTypes[0]) : ClassHelper.OBJECT_TYPE;
                            }
                            if (type != null) {
                                this.storeType(call, type);
                            }
                        }
                    } else if (objectExpression instanceof ClosureExpression) {
                        Parameter[] parameters3 = ((ClosureExpression)objectExpression).getParameters();
                        this.typeCheckClosureCall(callArguments, args, parameters3);
                        data = this.getInferredReturnType(objectExpression);
                        if (data != null) {
                            this.storeType(call, (ClassNode)data);
                        }
                    }
                    if (callArguments instanceof ArgumentListExpression) {
                        ArgumentListExpression list = (ArgumentListExpression)callArguments;
                        nbOfArgs = list.getExpressions().size();
                    } else {
                        nbOfArgs = 0;
                    }
                    this.storeTargetMethod(call, nbOfArgs == 0 ? CLOSURE_CALL_NO_ARG : (nbOfArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
                } else {
                    ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
                    this.addReceivers(receivers, this.makeOwnerList(objectExpression), call.isImplicitThis());
                    List<MethodNode> mn = null;
                    Receiver chosenReceiver = null;
                    for (Receiver receiver2 : receivers) {
                        ClassNode receiverType = receiver2.getType();
                        mn = this.findMethod(receiverType, name, args);
                        if (!mn.isEmpty() && (call.isImplicitThis() || StaticTypeCheckingVisitor.isThisExpression(objectExpression)) && (this.typeCheckingContext.isInStaticContext || (receiverType.getModifiers() & 8) != 0)) {
                            LinkedList<MethodNode> accessibleMethods = new LinkedList<MethodNode>();
                            LinkedList<MethodNode> inaccessibleMethods = new LinkedList<MethodNode>();
                            for (MethodNode node : mn) {
                                if (node.isStatic() || !this.typeCheckingContext.isInStaticContext && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiverType, node.getDeclaringClass())) {
                                    accessibleMethods.add(node);
                                    continue;
                                }
                                inaccessibleMethods.add(node);
                            }
                            mn = accessibleMethods;
                            if (accessibleMethods.isEmpty()) {
                                MethodNode node = (MethodNode)inaccessibleMethods.get(0);
                                ClassNode owner = node.getDeclaringClass();
                                this.addStaticTypeError("Non static method " + owner.getName() + "#" + node.getName() + " cannot be called from static context", call);
                            }
                        }
                        if (mn.isEmpty()) continue;
                        chosenReceiver = receiver2;
                        break;
                    }
                    if (mn.isEmpty() && call.isImplicitThis() && StaticTypeCheckingVisitor.isThisExpression(objectExpression) && this.typeCheckingContext.getEnclosingClosure() != null && !(mn = ClassHelper.CLOSURE_TYPE.getDeclaredMethods(name)).isEmpty()) {
                        chosenReceiver = Receiver.make(ClassHelper.CLOSURE_TYPE);
                        objectExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                    }
                    if (mn.isEmpty()) {
                        mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, call);
                    }
                    if (mn.isEmpty()) {
                        this.addNoMatchingMethodError(receiver, name, args, call);
                    } else {
                        if (this.areCategoryMethodCalls(mn, name, args)) {
                            this.addCategoryMethodCallError(call);
                        }
                        if ((mn = this.disambiguateMethods(mn, chosenReceiver != null ? chosenReceiver.getType() : null, args, call)).size() == 1) {
                            ClassNode classNode;
                            MethodNode directMethodCallCandidate = mn.get(0);
                            if (call.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION) == null && !directMethodCallCandidate.isStatic() && objectExpression instanceof ClassExpression && !"java.lang.Class".equals(directMethodCallCandidate.getDeclaringClass().getName())) {
                                ClassNode classNode2 = directMethodCallCandidate.getDeclaringClass();
                                this.addStaticTypeError("Non static method " + classNode2.getName() + "#" + directMethodCallCandidate.getName() + " cannot be called from static context", call);
                            }
                            if (chosenReceiver == null) {
                                chosenReceiver = Receiver.make(directMethodCallCandidate.getDeclaringClass());
                            }
                            if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(classNode = this.getType(directMethodCallCandidate))) {
                                this.visitMethodCallArguments(chosenReceiver.getType(), argumentList, true, directMethodCallCandidate);
                                ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), directMethodCallCandidate, callArguments, call.getGenericsTypes());
                                ClassNode classNode3 = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, classNode) ? irtg : classNode;
                                callArgsVisited = true;
                            }
                            if (directMethodCallCandidate == GET_DELEGATE && this.typeCheckingContext.getEnclosingClosure() != null) {
                                DelegationMetadata md = this.getDelegationMetadata(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
                                if (md != null) {
                                    ClassNode classNode4 = md.getType();
                                } else {
                                    ClassNode classNode5 = this.typeCheckingContext.getEnclosingClassNode();
                                }
                            }
                            StaticTypeCheckingVisitor.resolvePlaceholdersFromImplicitTypeHints(args, argumentList, directMethodCallCandidate);
                            if (this.typeCheckMethodsWithGenericsOrFail(chosenReceiver.getType(), args, directMethodCallCandidate, call)) {
                                VariableExpression var;
                                void var14_33;
                                ClassNode classNode6 = StaticTypeCheckingVisitor.adjustWithTraits(directMethodCallCandidate, chosenReceiver.getType(), args, (ClassNode)var14_33);
                                this.storeType(call, classNode6);
                                this.storeTargetMethod(call, directMethodCallCandidate);
                                String data = (String)chosenReceiver.getData();
                                if (data != null) {
                                    call.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, data);
                                }
                                receiver = chosenReceiver.getType();
                                if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                                    SecondPassExpression<ClassNode[]> wrapper = new SecondPassExpression<ClassNode[]>(call, args);
                                    this.typeCheckingContext.secondPassExpressions.add(wrapper);
                                }
                            }
                        } else {
                            this.addAmbiguousErrorMessage(mn, name, args, call);
                        }
                    }
                }
                if (StaticTypeCheckingSupport.NUMBER_OPS.containsKey(name) && ClassHelper.isNumberType(receiver) && argumentList.getExpressions().size() == 1 && ClassHelper.isNumberType(this.getType(argumentList.getExpression(0)))) {
                    ClassNode right = this.getType(argumentList.getExpression(0));
                    ClassNode resultType = this.getMathResultType(StaticTypeCheckingSupport.NUMBER_OPS.get(name), receiver, right, name);
                    if (resultType != null) {
                        this.storeType(call, resultType);
                    }
                }
                MethodNode target = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                if (!callArgsVisited) {
                    this.visitMethodCallArguments(receiver, argumentList, true, target);
                }
                if (target == null) break block49;
                List<Expression> arguments = argumentList.getExpressions();
                parameters = target.getParameters();
                int n = Math.min(arguments.size(), parameters.length);
                for (int i = 0; i < n; ++i) {
                    int outgoingStrategy;
                    int incomingStrategy;
                    Expression argument = arguments.get(i);
                    ClassNode aType = this.getType(argument);
                    ClassNode pType = parameters[i].getType();
                    if (!ClassHelper.CLOSURE_TYPE.equals(aType) || !ClassHelper.CLOSURE_TYPE.equals(pType)) continue;
                    if (!StaticTypeCheckingSupport.isAssignableTo(aType, pType)) {
                        this.addNoMatchingMethodError(receiver, name, this.getArgumentTypes(argumentList), call);
                        call.removeNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                        break;
                    }
                    if (!(argument instanceof VariableExpression) || !(((VariableExpression)argument).getAccessedVariable() instanceof Parameter) || (incomingStrategy = this.getResolveStrategy((Parameter)((VariableExpression)argument).getAccessedVariable())) == (outgoingStrategy = this.getResolveStrategy(parameters[i]))) continue;
                    this.addStaticTypeError("Closure parameter with resolve strategy " + ClosureUtils.getResolveStrategyName(incomingStrategy) + " passed to method with resolve strategy " + ClosureUtils.getResolveStrategyName(outgoingStrategy), argument);
                }
            }
            finally {
                this.typeCheckingContext.popEnclosingMethodCall();
                this.extension.afterMethodCall(call);
            }
        }
    }

    private int getResolveStrategy(Parameter parameter) {
        Expression strategy;
        List<AnnotationNode> annotations = parameter.getAnnotations(DELEGATES_TO);
        if (annotations != null && !annotations.isEmpty() && (strategy = annotations.get(0).getMember("strategy")) != null) {
            return (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(ClassHelper.Integer_TYPE, strategy), this.getSourceUnit().getConfiguration());
        }
        return 0;
    }

    private void inferMethodReferenceType(ClassNode receiver, ArgumentListExpression argumentList, MethodNode selectedMethod) {
        if (receiver == null) {
            return;
        }
        if (argumentList == null) {
            return;
        }
        if (selectedMethod == null) {
            return;
        }
        List<Expression> argumentExpressions = argumentList.getExpressions();
        if (argumentExpressions == null || argumentExpressions.stream().noneMatch(e -> e instanceof MethodReferenceExpression)) {
            return;
        }
        Parameter[] parameters = selectedMethod.getParameters();
        LinkedList<Integer> methodReferenceParamIndexList = new LinkedList<Integer>();
        LinkedList<Expression> newArgumentExpressionList = new LinkedList<Expression>();
        int n = argumentExpressions.size();
        for (int i = 0; i < n; ++i) {
            Expression argumentExpression = argumentExpressions.get(i);
            if (!(argumentExpression instanceof MethodReferenceExpression)) {
                newArgumentExpressionList.add(argumentExpression);
                continue;
            }
            Parameter param = parameters[i];
            ClassNode paramType = param.getType();
            if (!ClassHelper.isFunctionalInterface(paramType.redirect())) {
                this.addError("The argument is a method reference, but the parameter type is not a functional interface", argumentExpression);
                newArgumentExpressionList.add(argumentExpression);
                continue;
            }
            LambdaExpression constructedLambdaExpression = this.constructLambdaExpressionForMethodReference(paramType);
            newArgumentExpressionList.add(constructedLambdaExpression);
            methodReferenceParamIndexList.add(i);
        }
        this.visitMethodCallArguments(receiver, new ArgumentListExpression(newArgumentExpressionList), true, selectedMethod);
        for (Integer methodReferenceParamIndex : methodReferenceParamIndexList) {
            LambdaExpression lambdaExpression = (LambdaExpression)newArgumentExpressionList.get(methodReferenceParamIndex);
            ClassNode[] argumentTypes = (ClassNode[])lambdaExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
            argumentExpressions.get(methodReferenceParamIndex).putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, argumentTypes);
        }
    }

    private LambdaExpression constructLambdaExpressionForMethodReference(ClassNode paramType) {
        Parameter[] newParameters = this.createParametersForConstructedLambdaExpression(paramType);
        return new LambdaExpression(newParameters, GeneralUtils.block(new Statement[0]));
    }

    private Parameter[] createParametersForConstructedLambdaExpression(ClassNode functionalInterfaceType) {
        MethodNode abstractMethodNode = ClassHelper.findSAM(functionalInterfaceType);
        Parameter[] abstractMethodNodeParameters = abstractMethodNode.getParameters();
        if (abstractMethodNodeParameters == null) {
            abstractMethodNodeParameters = Parameter.EMPTY_ARRAY;
        }
        Parameter[] newParameters = new Parameter[abstractMethodNodeParameters.length];
        for (int i = 0; i < newParameters.length; ++i) {
            newParameters[i] = new Parameter(ClassHelper.DYNAMIC_TYPE, "p" + System.nanoTime());
        }
        return newParameters;
    }

    private static ClassNode adjustWithTraits(MethodNode directMethodCallCandidate, ClassNode receiver, ClassNode[] args, ClassNode returnType) {
        ExtensionMethodNode emn;
        if (directMethodCallCandidate instanceof ExtensionMethodNode && "withTraits".equals((emn = (ExtensionMethodNode)directMethodCallCandidate).getName()) && "DefaultGroovyMethods".equals(emn.getExtensionMethodNode().getDeclaringClass().getNameWithoutPackage())) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            Collections.addAll(nodes, receiver.getInterfaces());
            for (ClassNode arg : args) {
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(arg)) {
                    nodes.add(arg.getGenericsTypes()[0].getType());
                    continue;
                }
                nodes.add(arg);
            }
            return new WideningCategories.LowestUpperBoundClassNode(returnType.getName() + "Composed", ClassHelper.OBJECT_TYPE, nodes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return returnType;
    }

    private static void addArrayMethods(List<MethodNode> methods, ClassNode receiver, String name, ClassNode[] args) {
        if (args.length != 1) {
            return;
        }
        if (!receiver.isArray()) {
            return;
        }
        if (!WideningCategories.isIntCategory(ClassHelper.getUnwrapper(args[0]))) {
            return;
        }
        if ("getAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, receiver.getComponentType(), new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        } else if ("setAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        }
    }

    protected ClassNode getInferredReturnTypeFromWithClosureArgument(Expression callArguments) {
        if (!(callArguments instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression argList = (ArgumentListExpression)callArguments;
        ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
        this.visitClosureExpression(closure);
        if (this.getInferredReturnType(closure) != null) {
            return this.getInferredReturnType(closure);
        }
        return null;
    }

    protected List<Receiver<String>> makeOwnerList(Expression objectExpression) {
        List<ClassNode> potentialReceiverType;
        ClassNode receiver = this.getType(objectExpression);
        ArrayList<Receiver<String>> owners = new ArrayList<Receiver<String>>();
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            ClassNode staticType = receiver.getGenericsTypes()[0].getType();
            owners.add(Receiver.make(staticType));
            StaticTypeCheckingVisitor.addTraitType(staticType, owners);
            owners.add(Receiver.make(receiver));
        } else {
            owners.add(Receiver.make(receiver));
            if (receiver.isInterface()) {
                owners.add(Receiver.make(ClassHelper.OBJECT_TYPE));
            }
            StaticTypeCheckingVisitor.addSelfTypes(receiver, owners);
            StaticTypeCheckingVisitor.addTraitType(receiver, owners);
        }
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (potentialReceiverType = this.getTemporaryTypesForExpression(objectExpression)) != null && !potentialReceiverType.isEmpty()) {
            for (ClassNode node : potentialReceiverType) {
                owners.add(Receiver.make(node));
            }
        }
        if (this.typeCheckingContext.lastImplicitItType != null && objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).getName().equals("it")) {
            owners.add(Receiver.make(this.typeCheckingContext.lastImplicitItType));
        }
        if (this.typeCheckingContext.delegationMetadata != null && objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).getName().equals("owner") && this.typeCheckingContext.delegationMetadata.getParent() != null) {
            owners.clear();
            List<Receiver<String>> enclosingClass = Collections.singletonList(Receiver.make(this.typeCheckingContext.getEnclosingClassNode()));
            StaticTypeCheckingVisitor.addReceivers(owners, enclosingClass, this.typeCheckingContext.delegationMetadata.getParent(), "owner.");
        }
        return owners;
    }

    private static void addSelfTypes(ClassNode receiver, List<Receiver<String>> owners) {
        for (ClassNode selfType : Traits.collectSelfTypes(receiver, new LinkedHashSet<ClassNode>())) {
            owners.add(Receiver.make(selfType));
        }
    }

    private static void addTraitType(ClassNode receiver, List<Receiver<String>> owners) {
        if (Traits.isTrait(receiver.getOuterClass()) && receiver.getName().endsWith("$Helper")) {
            ClassNode traitType = receiver.getOuterClass();
            owners.add(Receiver.make(traitType));
            StaticTypeCheckingVisitor.addSelfTypes(traitType, owners);
        }
    }

    protected void checkForbiddenSpreadArgument(ArgumentListExpression argumentList) {
        for (Expression arg : argumentList.getExpressions()) {
            if (!(arg instanceof SpreadExpression)) continue;
            this.addStaticTypeError("The spread operator cannot be used as argument of method or closure calls with static type checking because the number of arguments cannot be determined at compile time", arg);
        }
    }

    protected List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.typeCheckingContext.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.typeCheckingContext.temporaryIfBranchTypeInformation.get(--depth);
            Object key = objectExpression instanceof ParameterVariableExpression ? ((ParameterVariableExpression)objectExpression).parameter : this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    protected void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
        if (directMethodCallCandidate != null && directMethodCallCandidate.isStatic() && directMethodCallCandidate.getDeclaringClass().isInterface() && !(directMethodCallCandidate instanceof ExtensionMethodNode)) {
            this.typeCheckingContext.getEnclosingClassNode().putNodeMetaData("_MINIMUM_BYTECODE_VERSION", 52);
        }
        this.checkOrMarkPrivateAccess(call, directMethodCallCandidate);
        this.checkSuperCallFromClosure(call, directMethodCallCandidate);
        this.extension.onMethodSelection(call, directMethodCallCandidate);
    }

    private void checkSuperCallFromClosure(Expression call, MethodNode directCallTarget) {
        Expression objectExpression;
        if (call instanceof MethodCallExpression && this.typeCheckingContext.getEnclosingClosure() != null && StaticTypeCheckingVisitor.isSuperExpression(objectExpression = ((MethodCallExpression)call).getObjectExpression())) {
            ClassNode current = this.typeCheckingContext.getEnclosingClassNode();
            current.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, x -> new LinkedList()).add(directCallTarget);
            call.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, current);
        }
    }

    protected boolean isClosureCall(String name, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression && ("call".equals(name) || "doCall".equals(name))) {
            return true;
        }
        if (StaticTypeCheckingVisitor.isThisExpression(objectExpression)) {
            FieldNode fieldNode = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(fieldNode.getType()) && !this.typeCheckingContext.getEnclosingClassNode().hasPossibleMethod(name, arguments)) {
                return true;
            }
        } else if (!"call".equals(name) && !"doCall".equals(name)) {
            return false;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    protected void typeCheckClosureCall(Expression callArguments, ClassNode[] args, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, args) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, args) < 0) {
            StringBuilder sb = new StringBuilder("[");
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                Parameter parameter = parameters[i];
                sb.append(parameter.getType().getName());
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            this.addStaticTypeError("Closure argument types: " + sb + " do not match with parameter types: " + StaticTypeCheckingVisitor.formatArgumentList(args), callArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.typeCheckingContext.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.typeCheckingContext.popTemporaryTypeInfo();
            this.restoreTypeBeforeConditional();
            ifElse.getElseBlock().visit(this);
            Map updates = (Map)ifElse.getElseBlock().getNodeMetaData("assignments");
            if (updates != null) {
                updates.forEach(this::recordAssignment);
            }
        }
        finally {
            ifElse.putNodeMetaData("assignments", this.popAssignmentTracking(oldTracker));
        }
        if (!this.typeCheckingContext.enclosingBlocks.isEmpty()) {
            BinaryExpression instanceOfExpression = this.findInstanceOfNotReturnExpression(ifElse);
            if (instanceOfExpression == null) {
                instanceOfExpression = this.findNotInstanceOfReturnExpression(ifElse);
            }
            if (instanceOfExpression != null) {
                this.visitInstanceofNot(instanceOfExpression);
            }
        }
    }

    protected void visitInstanceofNot(BinaryExpression be) {
        BlockStatement currentBlock = this.typeCheckingContext.enclosingBlocks.getFirst();
        assert (currentBlock != null);
        if (!this.typeCheckingContext.blockStatements2Types.containsKey(currentBlock)) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            this.getTypeCheckingContext().pushTemporaryTypeInfo();
            this.typeCheckingContext.blockStatements2Types.put(currentBlock, oldTracker);
        }
        this.pushInstanceOfTypeInfo(be.getLeftExpression(), be.getRightExpression());
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        if (block != null) {
            this.typeCheckingContext.enclosingBlocks.addFirst(block);
        }
        super.visitBlockStatement(block);
        if (block != null) {
            this.visitClosingBlock(block);
        }
    }

    public void visitClosingBlock(BlockStatement block) {
        BlockStatement peekBlock = this.typeCheckingContext.enclosingBlocks.removeFirst();
        boolean found = this.typeCheckingContext.blockStatements2Types.containsKey(peekBlock);
        if (found) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.blockStatements2Types.remove(peekBlock);
            this.getTypeCheckingContext().popTemporaryTypeInfo();
            this.popAssignmentTracking(oldTracker);
        }
    }

    protected BinaryExpression findInstanceOfNotReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof NotExpression)) {
            return null;
        }
        NotExpression notExpression = (NotExpression)conditionExpression;
        Expression expression = notExpression.getExpression();
        if (!(expression instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)expression;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 544) {
            return null;
        }
        if (StaticTypeCheckingVisitor.notReturningBlock(ifElse.getIfBlock())) {
            return null;
        }
        return instanceOfExpression;
    }

    protected BinaryExpression findNotInstanceOfReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)conditionExpression;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 130) {
            return null;
        }
        if (StaticTypeCheckingVisitor.notReturningBlock(ifElse.getIfBlock())) {
            return null;
        }
        return instanceOfExpression;
    }

    private static boolean notReturningBlock(Statement statement) {
        return statement.isEmpty() || !(statement instanceof BlockStatement) || !(DefaultGroovyMethods.last(((BlockStatement)statement).getStatements()) instanceof ReturnStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSwitch(SwitchStatement statement) {
        this.typeCheckingContext.pushEnclosingSwitchStatement(statement);
        try {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            try {
                super.visitSwitch(statement);
            }
            finally {
                this.popAssignmentTracking(oldTracker);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingSwitchStatement();
        }
    }

    @Override
    protected void afterSwitchConditionExpressionVisited(SwitchStatement statement) {
        Expression conditionExpression = statement.getExpression();
        conditionExpression.putNodeMetaData((Object)StaticTypesMarker.TYPE, this.getType(conditionExpression));
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        super.visitCaseStatement(statement);
        this.restoreTypeBeforeConditional();
    }

    private void recordAssignment(VariableExpression lhsExpr, ClassNode rhsType) {
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.computeIfAbsent(lhsExpr, lhs -> {
            ClassNode lhsType = (ClassNode)lhs.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            ArrayList<ClassNode> types = new ArrayList<ClassNode>(2);
            types.add(lhsType);
            return types;
        }).add(rhsType);
    }

    private void restoreTypeBeforeConditional() {
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.forEach((var, types) -> {
            ClassNode originType = (ClassNode)types.get(0);
            this.storeType((Expression)var, originType);
        });
    }

    protected Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.forEach((var, types) -> {
            ClassNode type = types.stream().filter(Objects::nonNull).reduce(WideningCategories::lowestUpperBound).get();
            assignments.put((VariableExpression)var, type);
            this.storeType((Expression)var, type);
        });
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    protected Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.typeCheckingContext.ifElseForWhileAssignmentTracker;
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression) {
        List<Expression> expressions;
        ClassNode elementType;
        super.visitArrayExpression(expression);
        if (expression.hasInitializer()) {
            elementType = expression.getElementType();
            expressions = expression.getExpressions();
        } else {
            elementType = ClassHelper.int_TYPE;
            expressions = expression.getSizeExpression();
        }
        for (Expression elementExpr : expressions) {
            if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(elementType, this.getType(elementExpr), elementExpr, false)) continue;
            this.addStaticTypeError("Cannot convert from " + StaticTypeCheckingSupport.prettyPrintType(this.getType(elementExpr)) + " to " + StaticTypeCheckingSupport.prettyPrintType(elementType), elementExpr);
        }
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        ClassNode type = expression.getType();
        Expression target = expression.getExpression();
        if (ClassHelper.isFunctionalInterface(type)) {
            this.processFunctionalInterfaceAssignment(type, target);
        } else if (StaticTypeCheckingVisitor.isClosureWithType(type) && target instanceof ClosureExpression) {
            this.storeInferredReturnType(target, StaticTypeCheckingSupport.getCombinedBoundType(type.getGenericsTypes()[0]));
        }
        target.visit(this);
        if (!(expression.isCoerce() || this.checkCast(type, target) || this.isDelegateOrOwnerInClosure(target))) {
            this.addStaticTypeError("Inconvertible types: cannot cast " + StaticTypeCheckingSupport.prettyPrintType(this.getType(target)) + " to " + StaticTypeCheckingSupport.prettyPrintType(type), expression);
        }
    }

    private boolean isDelegateOrOwnerInClosure(Expression exp) {
        return this.typeCheckingContext.getEnclosingClosure() != null && exp instanceof VariableExpression && ("delegate".equals(((VariableExpression)exp).getName()) || "owner".equals(((VariableExpression)exp).getName()));
    }

    protected boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = StaticTypeCheckingVisitor.isNullConstant(source);
        ClassNode expressionType = this.getType(source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), GeneralUtils.varX("foo", expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || ClassHelper.char_TYPE == targetType && ClassHelper.isPrimitiveType(expressionType) && ClassHelper.isNumberType(expressionType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType) && !ClassHelper.boolean_TYPE.equals(targetType)) {
                return false;
            }
            if ((expressionType.getModifiers() & 0x10) == 0 && targetType.isInterface()) {
                return true;
            }
            if ((targetType.getModifiers() & 0x10) == 0 && expressionType.isInterface()) {
                return true;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        BinaryExpression enclosingBinaryExpression;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.typeCheckingContext.pushTemporaryTypeInfo();
        expression.getBooleanExpression().visit(this);
        Expression trueExpression = expression.getTrueExpression();
        Expression falseExpression = expression.getFalseExpression();
        ClassNode typeOfTrue = this.findCurrentInstanceOfClass(trueExpression, null);
        trueExpression.visit(this);
        if (typeOfTrue == null) {
            typeOfTrue = this.getType(trueExpression);
        }
        this.typeCheckingContext.popTemporaryTypeInfo();
        falseExpression.visit(this);
        ClassNode typeOfFalse = this.getType(falseExpression);
        if (StaticTypeCheckingVisitor.hasInferredReturnType(falseExpression)) {
            typeOfFalse = (ClassNode)falseExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        if (StaticTypeCheckingVisitor.hasInferredReturnType(trueExpression)) {
            typeOfTrue = (ClassNode)trueExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        }
        typeOfFalse = this.checkForTargetType(falseExpression, typeOfFalse);
        typeOfTrue = this.checkForTargetType(trueExpression, typeOfTrue);
        ClassNode resultType = StaticTypeCheckingVisitor.isNullConstant(trueExpression) || StaticTypeCheckingVisitor.isNullConstant(falseExpression) ? ((enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null && enclosingBinaryExpression.getRightExpression() == expression ? this.getType(enclosingBinaryExpression.getLeftExpression()) : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) && StaticTypeCheckingVisitor.isNullConstant(falseExpression) ? ClassHelper.OBJECT_TYPE : (StaticTypeCheckingVisitor.isNullConstant(trueExpression) ? StaticTypeCheckingVisitor.wrapTypeIfNecessary(typeOfFalse) : StaticTypeCheckingVisitor.wrapTypeIfNecessary(typeOfTrue)))) : WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse);
        this.storeType(expression, resultType);
        this.popAssignmentTracking(oldTracker);
    }

    private ClassNode checkForTargetType(Expression expr, ClassNode type) {
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        if (enclosingBinaryExpression instanceof DeclarationExpression && StaticTypeCheckingVisitor.isEmptyCollection(expr) && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
            VariableExpression target = (VariableExpression)enclosingBinaryExpression.getLeftExpression();
            return StaticTypeCheckingVisitor.adjustForTargetType(target.getType(), type);
        }
        if (this.currentField != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(this.currentField.getType(), type);
        }
        if (this.currentProperty != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(this.currentProperty.getType(), type);
        }
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        if (enclosingMethod != null) {
            return StaticTypeCheckingVisitor.adjustForTargetType(enclosingMethod.getReturnType(), type);
        }
        return type;
    }

    private static ClassNode adjustForTargetType(ClassNode targetType, ClassNode resultType) {
        if (targetType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType)) {
            return GenericsUtils.parameterizeType(targetType, resultType.getPlainNodeReference());
        }
        return resultType;
    }

    private static boolean isEmptyCollection(Expression expr) {
        return expr instanceof ListExpression && ((ListExpression)expr).getExpressions().isEmpty() || expr instanceof MapExpression && ((MapExpression)expr).getMapEntryExpressions().isEmpty();
    }

    private static boolean hasInferredReturnType(Expression expression) {
        ClassNode type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return type != null && !type.getName().equals("java.lang.Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        List<CatchStatement> catchStatements = statement.getCatchStatements();
        for (CatchStatement catchStatement : catchStatements) {
            ClassNode exceptionType = catchStatement.getExceptionType();
            this.typeCheckingContext.controlStructureVariables.put(catchStatement.getVariable(), exceptionType);
        }
        try {
            super.visitTryCatchFinally(statement);
        }
        finally {
            for (CatchStatement catchStatement : catchStatements) {
                this.typeCheckingContext.controlStructureVariables.remove(catchStatement.getVariable());
            }
        }
    }

    protected void storeType(Expression exp, ClassNode cn) {
        ClassNode oldValue;
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            cn = this.getOriginalDeclarationType(exp);
        }
        if (cn != null && ClassHelper.isPrimitiveType(cn)) {
            if (exp instanceof VariableExpression && ((VariableExpression)exp).isClosureSharedVariable()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof MethodCallExpression && ((MethodCallExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof PropertyExpression && ((PropertyExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            }
        }
        if ((oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn)) != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? oldDIT : WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? null : WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable != exp && accessedVariable instanceof VariableExpression) {
                this.storeType((VariableExpression)accessedVariable, cn);
            }
            if (accessedVariable instanceof Parameter || accessedVariable instanceof PropertyNode && ((PropertyNode)accessedVariable).getField().isSynthetic()) {
                ((ASTNode)((Object)accessedVariable)).putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
            }
            if (var.isClosureSharedVariable() && cn != null) {
                List assignedTypes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.computeIfAbsent(var, k -> new LinkedList());
                assignedTypes.add(cn);
            }
            if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression(exp)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    protected ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        MethodNode method;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        Expression rightExpression = expr.getRightExpression();
        if (op == 100 || op == 217) {
            if (rightRedirect.isDerivedFrom(ClassHelper.CLOSURE_TYPE)) {
                MethodNode abstractMethod;
                ClosureExpression closureExpression = null;
                if (rightExpression instanceof ClosureExpression) {
                    closureExpression = (ClosureExpression)rightExpression;
                } else if (rightExpression instanceof MethodReferenceExpression) {
                    closureExpression = (ClosureExpression)rightExpression.getNodeMetaData((Object)StaticTypesMarker.CONSTRUCTED_LAMBDA_EXPRESSION);
                }
                if (closureExpression != null && (abstractMethod = ClassHelper.findSAM(left)) != null) {
                    return this.inferSAMTypeGenericsInAssignment(left, abstractMethod, right, closureExpression);
                }
            }
            if (leftExpression instanceof VariableExpression) {
                ClassNode initialType = this.getOriginalDeclarationType(leftExpression).redirect();
                if (ClassHelper.isPrimitiveType(right) && initialType.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getWrapper(right);
                }
                if (ClassHelper.isPrimitiveType(initialType) && rightRedirect.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getUnwrapper(right);
                }
                if (ClassHelper.STRING_TYPE.equals(initialType) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType) || ClassHelper.boolean_TYPE.equals(initialType)) {
                    return initialType;
                }
            }
            if (GeneralUtils.isOrImplements(rightRedirect, StaticTypeCheckingSupport.Collection_TYPE)) {
                if (leftRedirect.isArray()) {
                    return leftRedirect;
                }
                if (GeneralUtils.isOrImplements(leftRedirect, StaticTypeCheckingSupport.Collection_TYPE) && rightExpression instanceof ListExpression && StaticTypeCheckingVisitor.isEmptyCollection(rightExpression)) {
                    return left;
                }
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            BinaryExpression newExpr = GeneralUtils.binX(leftExpression, expr.getOperation(), rightExpression);
            newExpr.setSourcePosition(expr);
            MethodNode method2 = this.findMethodOrFail(newExpr, left.getPlainNodeReference(), "getAt", right.getPlainNodeReference());
            if (method2 != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(right, ClassHelper.RANGE_TYPE)) {
                return this.inferReturnTypeGenerics(left, method2, rightExpression);
            }
            return method2 != null ? this.inferComponentType(left, right) : null;
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        String operationName = StaticTypeCheckingSupport.getOperationName(op);
        ClassNode mathResultType = this.getMathResultType(op, leftRedirect, rightRedirect, operationName);
        if (mathResultType != null) {
            return mathResultType;
        }
        if (leftExpression instanceof ClassExpression) {
            left = ClassHelper.CLASS_Type.getPlainNodeReference();
        }
        if ((method = this.findMethodOrFail(expr, left, operationName, right)) != null) {
            this.storeTargetMethod(expr, method);
            this.typeCheckMethodsWithGenericsOrFail(left, new ClassNode[]{right}, method, expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (op == 128) {
                return ClassHelper.int_TYPE;
            }
            return this.inferReturnTypeGenerics(left, method, GeneralUtils.args(rightExpression));
        }
        return null;
    }

    private ClassNode getMathResultType(int op, ClassNode leftRedirect, ClassNode rightRedirect, String operationName) {
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op) || op == 204 || op == 214) {
                    if (WideningCategories.isIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isLongCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        } else if (ClassHelper.char_TYPE.equals(leftRedirect) && ClassHelper.char_TYPE.equals(rightRedirect) && (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (203 == op || 213 == op)) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && (205 == op || 215 == op)) {
            return leftRedirect;
        }
        return null;
    }

    private ClassNode inferSAMTypeGenericsInAssignment(ClassNode samType, MethodNode abstractMethod, ClassNode closureType, ClosureExpression closureExpression) {
        GenericsType[] samTypeGenerics = samType.getGenericsTypes();
        GenericsType[] closureGenerics = closureType.getGenericsTypes();
        if (samTypeGenerics == null || closureGenerics == null) {
            return samType;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getInferredReturnType(closureExpression)), abstractMethod.getReturnType());
        if (closureExpression.isParameterSpecified()) {
            Parameter[] closureParams = closureExpression.getParameters();
            Parameter[] methodParams = abstractMethod.getParameters();
            int n = Math.min(closureParams.length, methodParams.length);
            for (int i = 0; i < n; ++i) {
                ClassNode closureParamType = closureParams[i].getType();
                ClassNode methodParamType = methodParams[i].getType();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, closureParamType, methodParamType);
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(connections, samType.redirect());
    }

    protected static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassNode inferComponentType(ClassNode containerType, ClassNode indexType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            this.typeCheckingContext.pushErrorCollector();
            MethodCallExpression vcall = GeneralUtils.callX((Expression)GeneralUtils.localVarX("_hash_", containerType), "getAt", (Expression)GeneralUtils.varX("_index_", indexType));
            vcall.setImplicitThis(false);
            try {
                this.visitMethodCallExpression(vcall);
            }
            finally {
                this.typeCheckingContext.popErrorCollector();
            }
            return this.getType(vcall);
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty() && expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            MethodCallExpression call = GeneralUtils.callX(be.getLeftExpression(), name, be.getRightExpression());
            methods = this.extension.handleMissingMethod(receiver, name, GeneralUtils.args(be.getLeftExpression()), args, call);
        }
        if (methods.isEmpty()) {
            this.addNoMatchingMethodError(receiver, name, args, expr);
        } else {
            if (this.areCategoryMethodCalls(methods, name, args)) {
                this.addCategoryMethodCallError(expr);
            }
            if ((methods = this.disambiguateMethods(methods, receiver, args, expr)).size() == 1) {
                return methods.get(0);
            }
            this.addAmbiguousErrorMessage(methods, name, args, expr);
        }
        return null;
    }

    private List<MethodNode> disambiguateMethods(List<MethodNode> methods, ClassNode receiver, ClassNode[] argTypes, Expression call) {
        if (methods.size() > 1 && receiver != null && argTypes != null) {
            LinkedList<MethodNode> filteredWithGenerics = new LinkedList<MethodNode>();
            for (MethodNode methodNode : methods) {
                if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, argTypes, methodNode) || (methodNode.getModifiers() & 0x40) != 0) continue;
                filteredWithGenerics.add(methodNode);
            }
            if (filteredWithGenerics.size() == 1) {
                return filteredWithGenerics;
            }
            methods = this.extension.handleAmbiguousMethods(methods, call);
        }
        if (methods.size() > 1 && call instanceof MethodCall) {
            LinkedList<MethodNode> methodNodeList = new LinkedList<MethodNode>();
            String methodName = ((MethodCall)((Object)call)).getMethodAsString();
            for (MethodNode methodNode : methods) {
                if (!methodNode.getName().equals(methodName)) continue;
                methodNodeList.add(methodNode);
            }
            methods = methodNodeList;
        }
        return methods;
    }

    protected static String prettyPrintMethodList(List<MethodNode> nodes) {
        StringBuilder sb = new StringBuilder("[");
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            MethodNode node = nodes.get(i);
            sb.append(node.getReturnType().toString(false));
            sb.append(" ");
            sb.append(node.getDeclaringClass().toString(false));
            sb.append("#");
            sb.append(StaticTypeCheckingSupport.toMethodParametersString(node.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(node.getParameters())));
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean areCategoryMethodCalls(List<MethodNode> foundMethods, String name, ClassNode[] args) {
        boolean category = false;
        if ("use".equals(name) && args != null && args.length == 2 && args[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
                break;
            }
        }
        return category;
    }

    protected List<MethodNode> findMethodsWithGenerated(ClassNode receiver, String name) {
        List<MethodNode> methods = receiver.getMethods(name);
        if (receiver.isAbstract()) {
            this.collectAllInterfaceMethodsByName(receiver, name, methods);
        } else {
            ArrayList<MethodNode> interfaceMethods = new ArrayList<MethodNode>();
            this.collectAllInterfaceMethodsByName(receiver, name, interfaceMethods);
            interfaceMethods.stream().filter(MethodNode::isDefault).forEach(methods::add);
        }
        if (receiver.isInterface()) {
            methods.addAll(ClassHelper.OBJECT_TYPE.getMethods(name));
        }
        if (methods.isEmpty() || receiver.isResolved()) {
            return methods;
        }
        return StaticTypeCheckingVisitor.addGeneratedMethods(receiver, methods);
    }

    private static List<MethodNode> addGeneratedMethods(ClassNode receiver, List<MethodNode> methods) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        for (MethodNode method : methods) {
            result.add(method);
            Parameter[] parameters = method.getParameters();
            int counter = 0;
            int size = parameters.length;
            for (int i = size - 1; i >= 0; --i) {
                Parameter parameter = parameters[i];
                if (parameter == null || !parameter.hasInitialExpression()) continue;
                ++counter;
            }
            for (int j = 1; j <= counter; ++j) {
                MethodNode stubbed;
                Parameter[] newParams = new Parameter[parameters.length - j];
                int index = 0;
                int k = 1;
                for (Parameter parameter : parameters) {
                    if (k > counter - j && parameter != null && parameter.hasInitialExpression()) {
                        ++k;
                        continue;
                    }
                    if (parameter != null && parameter.hasInitialExpression()) {
                        newParams[index++] = parameter;
                        ++k;
                        continue;
                    }
                    newParams[index++] = parameter;
                }
                if ("<init>".equals(method.getName())) {
                    stubbed = new ConstructorNode(method.getModifiers(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                } else {
                    stubbed = new MethodNode(method.getName(), method.getModifiers(), method.getReturnType(), newParams, method.getExceptions(), GENERATED_EMPTY_STATEMENT);
                    stubbed.setGenericsTypes(method.getGenericsTypes());
                }
                stubbed.setDeclaringClass(method.getDeclaringClass());
                result.add(stubbed);
            }
        }
        return result;
    }

    protected List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> result;
        MethodNode constructor;
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if (!receiver.isInterface() && "<init>".equals(name)) {
            methods = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, new ArrayList<MethodNode>(receiver.getDeclaredConstructors()));
            if (methods.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                node.setDeclaringClass(receiver);
                methods = Collections.singletonList(node);
                if (receiver.isArray()) {
                    return methods;
                }
            }
        } else {
            String pname;
            methods = this.findMethodsWithGenerated(receiver, name);
            if (receiver.isInterface() && "call".equals(name) && ClassHelper.isFunctionalInterface(receiver)) {
                MethodNode sam = ClassHelper.findSAM(receiver);
                MethodNode callMethod = new MethodNode("call", sam.getModifiers(), sam.getReturnType(), sam.getParameters(), sam.getExceptions(), sam.getCode());
                callMethod.setDeclaringClass(sam.getDeclaringClass());
                callMethod.setSourcePosition(sam);
                methods.add(callMethod);
            }
            if (this.typeCheckingContext.getEnclosingClosure() == null || receiver.getOuterClass() != null && !receiver.getName().endsWith("$Trait$Helper")) {
                ClassNode parent = receiver;
                while (parent.getOuterClass() != null && !parent.isStaticClass()) {
                    parent = parent.getOuterClass();
                    methods.addAll(this.findMethodsWithGenerated(parent, name));
                }
            }
            if (methods.isEmpty()) {
                StaticTypeCheckingVisitor.addArrayMethods(methods, receiver, name, args);
            }
            if (methods.isEmpty() && (args == null || args.length == 0)) {
                pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("get", name);
                if (pname == null) {
                    pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("is", name);
                }
                if (pname != null) {
                    PropertyNode property = null;
                    block1: for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                        property = curNode.getProperty(pname);
                        ClassNode svCur = curNode;
                        while (property == null && svCur.getOuterClass() != null && !svCur.isStaticClass()) {
                            property = (svCur = svCur.getOuterClass()).getProperty(pname);
                            if (property == null) continue;
                            receiver = svCur;
                            continue block1;
                        }
                    }
                    if (property != null) {
                        int mods = 1 | (property.isStatic() ? 8 : 0);
                        MethodNode node = new MethodNode(name, mods, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                        node.setDeclaringClass(property.getDeclaringClass());
                        return Collections.singletonList(node);
                    }
                }
            } else if (methods.isEmpty() && args != null && args.length == 1 && (pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("set", name)) != null) {
                PropertyNode property = null;
                for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                    property = curNode.getProperty(pname);
                }
                if (property != null) {
                    ClassNode type = property.getOriginType();
                    if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(args[0]), StaticTypeCheckingVisitor.wrapTypeIfNecessary(type))) {
                        int mods = 1 | (property.isStatic() ? 8 : 0);
                        MethodNode node = new MethodNode(name, mods, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, name)}, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                        node.setDeclaringClass(property.getDeclaringClass());
                        return Collections.singletonList(node);
                    }
                }
            }
        }
        if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
            StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(this.getSourceUnit().getClassLoader(), receiver, name, args, methods);
        }
        if (!(chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods = StaticTypeCheckingSupport.filterMethodsByVisibility(methods, this.typeCheckingContext.getEnclosingClassNode()), args)).isEmpty()) {
            return chosen;
        }
        if (receiver instanceof InnerClassNode && ((InnerClassNode)receiver).isAnonymous() && methods.size() == 1 && args != null && "<init>".equals(name) && (constructor = methods.get(0)).getParameters().length == args.length) {
            return methods;
        }
        if (receiver.equals(ClassHelper.CLASS_Type) && receiver.getGenericsTypes() != null && !(result = this.findMethod(receiver.getGenericsTypes()[0].getType(), name, args)).isEmpty()) {
            return result;
        }
        if (ClassHelper.GSTRING_TYPE.equals(receiver)) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        if (StaticTypeCheckingSupport.isBeingCompiled(receiver) && !(chosen = this.findMethod(ClassHelper.GROOVY_OBJECT_TYPE, name, args)).isEmpty()) {
            return chosen;
        }
        return EMPTY_METHODNODE_LIST;
    }

    public static String extractPropertyNameFromMethodName(String prefix, String methodName) {
        String propertyName;
        String result;
        if (prefix == null || methodName == null) {
            return null;
        }
        if (methodName.startsWith(prefix) && prefix.length() < methodName.length() && (result = methodName.substring(prefix.length())).equals(BeanUtils.capitalize(propertyName = BeanUtils.decapitalize(result)))) {
            return propertyName;
        }
        return null;
    }

    protected void collectAllInterfaceMethodsByName(ClassNode type, String name, List<MethodNode> methods) {
        LinkedHashSet<ClassNode> done = new LinkedHashSet<ClassNode>();
        for (ClassNode next = type; next != null; next = next.getSuperClass()) {
            done.add(next);
            for (ClassNode face : next.getAllInterfaces()) {
                if (!done.add(face)) continue;
                methods.addAll(face.getDeclaredMethods(name));
            }
        }
    }

    protected ClassNode getType(ASTNode exp) {
        MethodNode target;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)exp).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression vexp = (VariableExpression)exp;
            ClassNode selfTrait = StaticTypeCheckingSupport.isTraitSelf(vexp);
            if (selfTrait != null) {
                return StaticTypeCheckingVisitor.makeSelf(selfTrait);
            }
            if (vexp.isThisExpression()) {
                return this.makeThis();
            }
            if (vexp.isSuperExpression()) {
                return this.makeSuper();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable instanceof FieldNode) {
                ClassNode fieldType = variable.getOriginType();
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(fieldType)) {
                    boolean isStatic = (variable.getModifiers() & 8) != 0;
                    ClassNode thisType = this.typeCheckingContext.getEnclosingClassNode();
                    ClassNode declType = ((FieldNode)variable).getDeclaringClass();
                    Map<GenericsType.GenericsTypeName, GenericsType> placeholders = this.resolvePlaceHoldersFromDeclaration(thisType, declType, null, isStatic);
                    fieldType = this.resolveGenericsWithContext(placeholders, fieldType);
                }
                return fieldType;
            }
            if (variable != vexp && variable instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable));
            }
            if (variable instanceof Parameter) {
                Parameter parameter = (Parameter)variable;
                ClassNode type = null;
                List<ClassNode> temporaryTypesForExpression = this.getTemporaryTypesForExpression(vexp);
                if (temporaryTypesForExpression == null || temporaryTypesForExpression.isEmpty()) {
                    type = this.typeCheckingContext.controlStructureVariables.get(parameter);
                }
                TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
                if (type == null && enclosingClosure != null && temporaryTypesForExpression == null) {
                    type = this.getTypeFromClosureArguments(parameter, enclosingClosure);
                }
                if (type != null) {
                    this.storeType(vexp, type);
                    return type;
                }
                return this.getType((Parameter)variable);
            }
            return vexp.getOriginType();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)exp).getType();
        }
        if (exp instanceof MethodNode) {
            if ((exp == GET_DELEGATE || exp == GET_OWNER || exp == GET_THISOBJECT) && this.typeCheckingContext.getEnclosingClosure() != null) {
                return this.typeCheckingContext.getEnclosingClassNode();
            }
            ClassNode ret = this.getInferredReturnType(exp);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof FieldNode || exp instanceof PropertyNode) {
            return ((Variable)((Object)exp)).getOriginType();
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType(re.getFrom());
            if (fromType.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType, toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType(((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType(((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType(((BitwiseNegationExpression)exp).getExpression());
        }
        if (exp instanceof Parameter) {
            return ((Parameter)exp).getOriginType();
        }
        if (exp instanceof ClosureExpression) {
            ClassNode irt = this.getInferredReturnType(exp);
            if (irt != null) {
                irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
                ClassNode result = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
                result.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
                return result;
            }
        } else if (exp instanceof MethodCall && (target = (MethodNode)exp.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
            return this.getType(target);
        }
        return ((Expression)exp).getType();
    }

    private ClassNode getTypeFromClosureArguments(Parameter parameter, TypeCheckingContext.EnclosingClosure enclosingClosure) {
        ClosureExpression closureExpression = enclosingClosure.getClosureExpression();
        ClassNode[] closureParamTypes = (ClassNode[])closureExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        if (closureParamTypes == null) {
            return null;
        }
        Parameter[] parameters = closureExpression.getParameters();
        String name = parameter.getName();
        if (parameters != null) {
            if (parameters.length == 0) {
                return "it".equals(name) && closureParamTypes.length != 0 ? closureParamTypes[0] : null;
            }
            for (int index = 0; index < parameters.length; ++index) {
                if (!name.equals(parameters[index].getName())) continue;
                return closureParamTypes.length > index ? closureParamTypes[index] : null;
            }
        }
        return null;
    }

    private static ClassNode makeSelf(ClassNode trait) {
        ClassNode selfType = trait;
        LinkedHashSet<ClassNode> selfTypes = Traits.collectSelfTypes(selfType, new LinkedHashSet<ClassNode>());
        if (!selfTypes.isEmpty()) {
            selfTypes.add(selfType);
            selfType = new UnionTypeClassNode(selfTypes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return selfType;
    }

    private ClassNode makeSuper() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode().getUnresolvedSuperClass(), this.typeCheckingContext.isInStaticContext);
    }

    private ClassNode makeThis() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode(), this.typeCheckingContext.isInStaticContext);
    }

    private static ClassNode makeType(ClassNode cn, boolean usingClass) {
        if (usingClass) {
            ClassNode clazzType = ClassHelper.CLASS_Type.getPlainNodeReference();
            clazzType.setGenericsTypes(new GenericsType[]{new GenericsType(cn)});
            return clazzType;
        }
        return cn;
    }

    protected ClassNode storeInferredReturnType(ASTNode node, ClassNode type) {
        if (!(node instanceof ClosureExpression)) {
            throw new IllegalArgumentException("Storing inferred return type is only allowed on closures but found " + node.getClass());
        }
        return (ClassNode)node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
    }

    protected ClassNode getInferredReturnType(ASTNode exp) {
        return (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
    }

    protected ClassNode inferListExpressionType(ListExpression list) {
        List<Expression> expressions = list.getExpressions();
        int nExpressions = expressions.size();
        if (nExpressions == 0) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) {
            ArrayList<ClassNode> nodes = new ArrayList<ClassNode>(nExpressions);
            for (Expression expression : expressions) {
                if (StaticTypeCheckingVisitor.isNullConstant(expression)) continue;
                nodes.add(this.getType(expression));
            }
            if (!nodes.isEmpty()) {
                ClassNode itemType = WideningCategories.lowestUpperBound(nodes);
                listType = listType.getPlainNodeReference();
                listType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(itemType))});
            }
        }
        return listType;
    }

    protected static boolean isNullConstant(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNullExpression();
    }

    protected static boolean isThisExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isThisExpression();
    }

    protected static boolean isSuperExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isSuperExpression();
    }

    protected ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = LINKEDHASHMAP_CLASSNODE.getPlainNodeReference();
        List<MapEntryExpression> entryExpressions = map.getMapEntryExpressions();
        int nExpressions = entryExpressions.size();
        if (nExpressions == 0) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            ArrayList<ClassNode> keyTypes = new ArrayList<ClassNode>(nExpressions);
            ArrayList<ClassNode> valueTypes = new ArrayList<ClassNode>(nExpressions);
            for (MapEntryExpression entryExpression : entryExpressions) {
                keyTypes.add(this.getType(entryExpression.getKeyExpression()));
                valueTypes.add(this.getType(entryExpression.getValueExpression()));
            }
            ClassNode keyType = WideningCategories.lowestUpperBound(keyTypes);
            ClassNode valueType = WideningCategories.lowestUpperBound(valueTypes);
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                mapType = mapType.getPlainNodeReference();
                mapType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
            }
        }
        return mapType;
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        return this.inferReturnTypeGenerics(receiver, method, arguments, null);
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments, GenericsType[] explicitTypeHints) {
        ClassNode returnType = method.getReturnType();
        if (StaticTypeCheckingSupport.getGenericsWithoutArray(returnType) == null) {
            return returnType;
        }
        if (method instanceof ExtensionMethodNode) {
            ExtensionMethodNode emn = (ExtensionMethodNode)method;
            MethodNode dgm = emn.getExtensionMethodNode();
            ArgumentListExpression args = new ArgumentListExpression();
            VariableExpression vexp = GeneralUtils.varX("$self", receiver);
            args.addExpression(vexp);
            vexp.setNodeMetaData(ExtensionMethodDeclaringClass.class, emn.getDeclaringClass());
            if (arguments instanceof ArgumentListExpression) {
                for (Expression argument : (ArgumentListExpression)arguments) {
                    args.addExpression(argument);
                }
            } else {
                args.addExpression(arguments);
            }
            return this.inferReturnTypeGenerics(receiver, dgm, args, explicitTypeHints);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = this.resolvePlaceHoldersFromDeclaration(receiver, StaticTypeCheckingVisitor.getDeclaringClass(method, arguments), method, method.isStatic());
        StaticTypeCheckingVisitor.resolvePlaceholdersFromExplicitTypeHints(method, explicitTypeHints, resolvedPlaceholders);
        if (resolvedPlaceholders.isEmpty()) {
            return StaticTypeCheckingSupport.boundUnboundedWildcards(returnType);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
        StaticTypeCheckingSupport.applyGenericsConnections(placeholdersFromContext, resolvedPlaceholders);
        List<Expression> expressions = InvocationWriter.makeArgumentList(arguments).getExpressions();
        Parameter[] parameters = method.getParameters();
        boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
        int paramLength = parameters.length;
        if (expressions.size() >= paramLength) {
            for (int i = 0; i < paramLength; ++i) {
                MethodNode sam;
                if (StaticTypeCheckingVisitor.isNullConstant(expressions.get(i))) continue;
                boolean lastArg = i == paramLength - 1;
                ClassNode paramType = parameters[i].getType();
                ClassNode argumentType = this.getDeclaredOrInferredType(expressions.get(i));
                while (paramType.isArray() && argumentType.isArray()) {
                    paramType = paramType.getComponentType();
                    argumentType = argumentType.getComponentType();
                }
                if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(paramType)) continue;
                if (argumentType.isDerivedFrom(ClassHelper.CLOSURE_TYPE) && (sam = ClassHelper.findSAM(paramType)) != null) {
                    ClassNode classNode = argumentType = !paramType.isUsingGenerics() ? paramType : StaticTypeCheckingVisitor.convertClosureTypeToSAMType(expressions.get(i), argumentType, sam, paramType, StaticTypeCheckingSupport.applyGenericsContextToParameterClass(resolvedPlaceholders, paramType));
                }
                if (isVargs && lastArg && paramType.isArray() && !argumentType.isArray()) {
                    paramType = paramType.getComponentType();
                }
                argumentType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(argumentType);
                HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, argumentType, paramType);
                StaticTypeCheckingVisitor.extractGenericsConnectionsForSuperClassAndInterfaces(resolvedPlaceholders, connections);
                StaticTypeCheckingSupport.applyGenericsConnections(connections, resolvedPlaceholders);
                StaticTypeCheckingSupport.applyGenericsConnections(placeholdersFromContext, resolvedPlaceholders);
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(resolvedPlaceholders, returnType);
    }

    private static void resolvePlaceholdersFromExplicitTypeHints(MethodNode method, GenericsType[] explicitTypeHints, Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders) {
        GenericsType[] methodGenericTypes;
        if (explicitTypeHints != null && (methodGenericTypes = method.getGenericsTypes()) != null && methodGenericTypes.length == explicitTypeHints.length) {
            int n = methodGenericTypes.length;
            for (int i = 0; i < n; ++i) {
                GenericsType methodGenericType = methodGenericTypes[i];
                GenericsType explicitTypeHint = explicitTypeHints[i];
                resolvedPlaceholders.put(new GenericsType.GenericsTypeName(methodGenericType.getName()), explicitTypeHint);
            }
        }
    }

    private static void resolvePlaceholdersFromImplicitTypeHints(ClassNode[] actuals, ArgumentListExpression argumentList, MethodNode inferredMethod) {
        int n = actuals.length;
        for (int i = 0; i < n; ++i) {
            ClassNode at;
            MethodNode aNode;
            Expression a = argumentList.getExpression(i);
            if (!(a instanceof MethodCallExpression) || ((MethodCallExpression)a).isUsingGenerics() || (aNode = (MethodNode)a.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) == null || aNode.getGenericsTypes() == null || !GenericsUtils.hasUnresolvedGenerics(at = actuals[i])) continue;
            int np = inferredMethod.getParameters().length;
            Parameter p = inferredMethod.getParameters()[Math.min(i, np - 1)];
            ClassNode pt = p.getOriginType();
            if (i >= np - 1 && pt.isArray() && !at.isArray()) {
                pt = pt.getComponentType();
            }
            HashMap<GenericsType.GenericsTypeName, GenericsType> linked = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            Map<GenericsType.GenericsTypeName, GenericsType> source = GenericsUtils.extractPlaceholders(at);
            Map<GenericsType.GenericsTypeName, GenericsType> target = GenericsUtils.extractPlaceholders(pt);
            block1: for (GenericsType placeholder : aNode.getGenericsTypes()) {
                for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> e : source.entrySet()) {
                    if (e.getValue() != placeholder) continue;
                    Optional.ofNullable(target.get(e.getKey())).filter(gt -> StaticTypeCheckingSupport.isAssignableTo(gt.getType(), placeholder.getType())).ifPresent(gt -> linked.put(new GenericsType.GenericsTypeName(placeholder.getName()), (GenericsType)gt));
                    continue block1;
                }
            }
            actuals[i] = StaticTypeCheckingSupport.applyGenericsContext(linked, at);
        }
    }

    private static void extractGenericsConnectionsForSuperClassAndInterfaces(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, Map<GenericsType.GenericsTypeName, GenericsType> connections) {
        for (GenericsType value : new HashSet<GenericsType>(connections.values())) {
            if (value.isPlaceholder() || value.isWildcard()) continue;
            ClassNode valueType = value.getType();
            LinkedList<ClassNode> deepNodes = new LinkedList<ClassNode>();
            ClassNode unresolvedSuperClass = valueType.getUnresolvedSuperClass();
            if (unresolvedSuperClass != null && unresolvedSuperClass.isUsingGenerics()) {
                deepNodes.add(unresolvedSuperClass);
            }
            for (ClassNode classNode : valueType.getUnresolvedInterfaces()) {
                if (!classNode.isUsingGenerics()) continue;
                deepNodes.add(classNode);
            }
            if (deepNodes.isEmpty()) continue;
            for (GenericsType genericsType : resolvedPlaceholders.values()) {
                ClassNode[] classNodeArray;
                ClassNode lowerBound = genericsType.getLowerBound();
                if (lowerBound != null) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!lowerBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, lowerBound);
                    }
                }
                if ((classNodeArray = genericsType.getUpperBounds()) == null) continue;
                for (ClassNode upperBound : classNodeArray) {
                    for (ClassNode deepNode : deepNodes) {
                        if (!upperBound.equals(deepNode)) continue;
                        StaticTypeCheckingSupport.extractGenericsConnections(connections, deepNode, upperBound);
                    }
                }
            }
        }
    }

    private static MethodNode chooseMethod(MethodPointerExpression source, Supplier<ClassNode[]> samSignature) {
        List options = (List)source.getNodeMetaData(MethodNode.class);
        if (options == null || options.isEmpty()) {
            return null;
        }
        ClassNode[] paramTypes = samSignature.get();
        return options.stream().filter(option -> {
            ClassNode[] types = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(source, option);
            if (types.length == paramTypes.length) {
                int n = types.length;
                for (int i = 0; i < n; ++i) {
                    if (types[i].isGenericsPlaceHolder() || StaticTypeCheckingSupport.isAssignableTo(types[i], paramTypes[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }).findFirst().orElse(null);
    }

    private static ClassNode[] collateMethodReferenceParameterTypes(MethodPointerExpression source, MethodNode target) {
        Parameter[] params;
        if (target instanceof ExtensionMethodNode && !((ExtensionMethodNode)target).isStaticExtension()) {
            params = ((ExtensionMethodNode)target).getExtensionMethodNode().getParameters();
        } else if (!target.isStatic() && source.getExpression() instanceof ClassExpression) {
            ClassNode thisType = ((ClassExpression)source.getExpression()).getType();
            int n = target.getParameters().length;
            params = new Parameter[n + 1];
            params[0] = new Parameter(thisType, "");
            System.arraycopy(target.getParameters(), 0, params, 1, n);
        } else {
            params = target.getParameters();
        }
        return StaticTypeCheckingVisitor.extractTypesFromParameters(params);
    }

    private static ClassNode convertClosureTypeToSAMType(Expression expression, ClassNode closureType, MethodNode sam, ClassNode samType, Map<GenericsType.GenericsTypeName, GenericsType> placeholders) {
        if (closureType.isUsingGenerics()) {
            MethodPointerExpression mp;
            MethodNode mn;
            ClassNode closureReturnType = closureType.getGenericsTypes()[0].getType();
            Parameter[] parameters = sam.getParameters();
            if (parameters.length > 0 && expression instanceof MethodPointerExpression && StaticTypeCheckingSupport.isUsingUncheckedGenerics(closureReturnType) && (mn = StaticTypeCheckingVisitor.chooseMethod(mp = (MethodPointerExpression)expression, () -> StaticTypeCheckingSupport.applyGenericsContext(placeholders, StaticTypeCheckingVisitor.extractTypesFromParameters(parameters)))) != null) {
                ClassNode[] pTypes = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(mp, mn);
                HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                int n = parameters.length;
                for (int i = 0; i < n; ++i) {
                    StaticTypeCheckingSupport.extractGenericsConnections(connections, parameters[i].getOriginType(), pTypes[i]);
                }
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(connections, closureReturnType);
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(placeholders, closureReturnType);
            }
            StaticTypeCheckingSupport.extractGenericsConnections(placeholders, closureReturnType, sam.getReturnType());
            if (parameters.length > 0 && expression instanceof ClosureExpression) {
                ArrayList<ClassNode[]> genericsToConnect = new ArrayList<ClassNode[]>();
                Parameter[] closureParams = ((ClosureExpression)expression).getParameters();
                ClassNode[] closureParamTypes = (ClassNode[])expression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                if (closureParamTypes == null) {
                    closureParamTypes = StaticTypeCheckingVisitor.extractTypesFromParameters(closureParams);
                }
                int n = parameters.length;
                for (int i = 0; i < n; ++i) {
                    Parameter parameter = parameters[i];
                    if (!parameter.getOriginType().isUsingGenerics() || closureParamTypes.length <= i) continue;
                    genericsToConnect.add(new ClassNode[]{closureParamTypes[i], parameter.getOriginType()});
                }
                for (ClassNode[] classNodes : genericsToConnect) {
                    ClassNode expected;
                    ClassNode found = classNodes[0];
                    if (!StaticTypeCheckingSupport.isAssignableTo(found, expected = classNodes[1])) continue;
                    ClassNode generifiedType = GenericsUtils.parameterizeType(found, expected);
                    while (expected.isArray()) {
                        expected = expected.getComponentType();
                        generifiedType = generifiedType.getComponentType();
                    }
                    if (expected.isGenericsPlaceHolder()) {
                        placeholders.put(new GenericsType.GenericsTypeName(expected.getGenericsTypes()[0].getName()), new GenericsType(generifiedType));
                        continue;
                    }
                    GenericsType[] expectedGenericsTypes = expected.getGenericsTypes();
                    GenericsType[] foundGenericsTypes = generifiedType.getGenericsTypes();
                    int n2 = expectedGenericsTypes.length;
                    for (int i = 0; i < n2; ++i) {
                        GenericsType type = expectedGenericsTypes[i];
                        if (!type.isPlaceholder()) continue;
                        String name = type.getName();
                        placeholders.put(new GenericsType.GenericsTypeName(name), foundGenericsTypes[i]);
                    }
                }
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(placeholders, samType.redirect());
    }

    private ClassNode resolveGenericsWithContext(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, ClassNode currentType) {
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
        return StaticTypeCheckingSupport.resolveClassNodeGenerics(resolvedPlaceholders, placeholdersFromContext, currentType);
    }

    private ClassNode getDeclaredOrInferredType(Expression expression) {
        ClassNode declaredOrInferred = expression instanceof Variable && !((Variable)((Object)expression)).isDynamicTyped() ? this.getOriginalDeclarationType(expression) : this.getType(expression);
        return this.getInferredTypeFromTempInfo(expression, declaredOrInferred);
    }

    private static ClassNode getDeclaringClass(MethodNode method, Expression arguments) {
        ClassNode declaringClass = method.getDeclaringClass();
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression al = (ArgumentListExpression)arguments;
            List<Expression> list = al.getExpressions();
            if (list.isEmpty()) {
                return declaringClass;
            }
            Expression exp = list.get(0);
            ClassNode cn = (ClassNode)exp.getNodeMetaData(ExtensionMethodDeclaringClass.class);
            if (cn != null) {
                return cn;
            }
        }
        return declaringClass;
    }

    private Map<GenericsType.GenericsTypeName, GenericsType> resolvePlaceHoldersFromDeclaration(ClassNode receiver, ClassNode declaration, MethodNode method, boolean isStaticTarget) {
        if (isStaticTarget && ClassHelper.CLASS_Type.equals(receiver) && receiver.isUsingGenerics() && receiver.getGenericsTypes().length > 0 && !ClassHelper.OBJECT_TYPE.equals(receiver.getGenericsTypes()[0].getType())) {
            return this.resolvePlaceHoldersFromDeclaration(receiver.getGenericsTypes()[0].getType(), declaration, method, isStaticTarget);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = StaticTypeCheckingVisitor.extractPlaceHolders(method, receiver, declaration);
        return resolvedPlaceholders;
    }

    private static boolean isGenericsPlaceHolderOrArrayOf(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(cn.getComponentType());
        }
        return cn.isGenericsPlaceHolder();
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> extractPlaceHolders(MethodNode method, ClassNode receiver, ClassNode declaringClass) {
        if (declaringClass.equals(ClassHelper.OBJECT_TYPE)) {
            HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            if (method != null) {
                StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, resolvedPlaceholders);
            }
            return resolvedPlaceholders;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = null;
        if (ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(declaringClass)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        ClassNode[] todo = receiver instanceof UnionTypeClassNode ? ((UnionTypeClassNode)receiver).getDelegates() : new ClassNode[]{receiver};
        ClassNode[] classNodeArray = todo;
        int n = classNodeArray.length;
        block0: for (int i = 0; i < n; ++i) {
            ClassNode type;
            ClassNode current = type = classNodeArray[i];
            while (current != null) {
                boolean continueLoop = true;
                HashMap<GenericsType.GenericsTypeName, GenericsType> currentPlaceHolders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                if (StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(declaringClass) || declaringClass.equals(current)) {
                    StaticTypeCheckingSupport.extractGenericsConnections(currentPlaceHolders, current, declaringClass);
                    if (method != null) {
                        StaticTypeCheckingSupport.addMethodLevelDeclaredGenerics(method, currentPlaceHolders);
                    }
                    continueLoop = false;
                } else {
                    GenericsUtils.extractPlaceholders(current, currentPlaceHolders);
                }
                if (resolvedPlaceholders != null) {
                    Set entries = currentPlaceHolders.entrySet();
                    for (Map.Entry entry : entries) {
                        GenericsType referenced;
                        GenericsType gt = (GenericsType)entry.getValue();
                        if (!gt.isPlaceholder() || (referenced = (GenericsType)resolvedPlaceholders.get(new GenericsType.GenericsTypeName(gt.getName()))) == null) continue;
                        entry.setValue(referenced);
                    }
                }
                resolvedPlaceholders = currentPlaceHolders;
                if (!continueLoop) continue block0;
                if ((current = ClassHelper.getNextSuperClass(current, declaringClass)) != null || !declaringClass.equals(ClassHelper.CLASS_Type)) continue;
                current = declaringClass;
            }
        }
        if (resolvedPlaceholders == null) {
            String descriptor = "<>";
            if (method != null) {
                descriptor = method.getTypeDescriptor();
            }
            throw new GroovyBugError("Declaring class for method call to '" + descriptor + "' declared in " + declaringClass.getName() + " was not matched with found receiver " + receiver.getName() + ". This should not have happened!");
        }
        return resolvedPlaceholders;
    }

    protected boolean typeCheckMethodsWithGenericsOrFail(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, arguments, candidateMethod)) {
            Map<GenericsType.GenericsTypeName, GenericsType> classGTs = GenericsUtils.extractPlaceholders(receiver);
            Parameter[] parameters = candidateMethod.getParameters();
            ClassNode[] paramTypes = new ClassNode[parameters.length];
            int n = parameters.length;
            for (int i = 0; i < n; ++i) {
                paramTypes[i] = StaticTypeCheckingSupport.fullyResolveType(parameters[i].getType(), classGTs);
                if (i >= arguments.length || !this.hasGStringStringError(paramTypes[i], arguments[i], location)) continue;
                return false;
            }
            this.addStaticTypeError("Cannot call " + StaticTypeCheckingVisitor.toMethodGenericTypesString(candidateMethod) + receiver.toString(false) + "#" + StaticTypeCheckingSupport.toMethodParametersString(candidateMethod.getName(), paramTypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(arguments), location);
            return false;
        }
        return true;
    }

    private static String toMethodGenericTypesString(MethodNode node) {
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (genericsTypes == null) {
            return "";
        }
        return GenericsUtils.toGenericTypesString(genericsTypes);
    }

    protected static String formatArgumentList(ClassNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(24 * nodes.length);
        sb.append('[');
        for (ClassNode node : nodes) {
            sb.append(StaticTypeCheckingSupport.prettyPrintType(node));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 2, ']');
        }
        return sb.toString();
    }

    private static void putSetterInfo(Expression exp, SetterInfo info) {
        exp.putNodeMetaData(SetterInfo.class, info);
    }

    private static SetterInfo removeSetterInfo(Expression exp) {
        Object nodeMetaData = exp.getNodeMetaData(SetterInfo.class);
        if (nodeMetaData != null) {
            exp.removeNodeMetaData(SetterInfo.class);
            return (SetterInfo)nodeMetaData;
        }
        return null;
    }

    @Override
    public void addError(String msg, ASTNode expr) {
        Long err = (long)expr.getLineNumber() << 16 + expr.getColumnNumber();
        if (DEBUG_GENERATED_CODE && expr.getLineNumber() < 0 || !this.typeCheckingContext.reportedErrors.contains(err)) {
            this.typeCheckingContext.getErrorCollector().addErrorAndContinue(msg + '\n', expr, this.getSourceUnit());
            this.typeCheckingContext.reportedErrors.add(err);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        } else if (DEBUG_GENERATED_CODE) {
            this.addError("[Static type checking] - Error in generated code [" + expr.getText() + "] - " + msg, expr);
        }
    }

    protected void addNoMatchingMethodError(ClassNode receiver, String name, ClassNode[] args, Expression call) {
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            receiver = receiver.getGenericsTypes()[0].getType();
        }
        this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args) + ". Please check if the declared type is correct and if the method exists.", call);
    }

    protected void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
        this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + StaticTypeCheckingVisitor.prettyPrintMethodList(foundMethods), expr);
    }

    protected void addCategoryMethodCallError(Expression call) {
        this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", call);
    }

    protected void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.toString(false) + " to variable of type " + leftType.toString(false), assignmentExpression);
    }

    protected void addUnsupportedPreOrPostfixExpressionError(Expression expression) {
        if (expression instanceof PostfixExpression) {
            this.addStaticTypeError("Unsupported postfix operation type [" + ((PostfixExpression)expression).getOperation() + "]", expression);
        } else if (expression instanceof PrefixExpression) {
            this.addStaticTypeError("Unsupported prefix operation type [" + ((PrefixExpression)expression).getOperation() + "]", expression);
        } else {
            throw new IllegalArgumentException("Method should be called with a PostfixExpression or a PrefixExpression");
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.typeCheckingContext.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (SecondPassExpression wrapper : this.typeCheckingContext.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call;
            Expression objectExpression;
            Expression expression = wrapper.getExpression();
            if (expression instanceof BinaryExpression) {
                List<MethodNode> method;
                VariableExpression var2;
                List<ClassNode> classNodes2;
                Variable target2;
                Expression left = ((BinaryExpression)expression).getLeftExpression();
                if (!(left instanceof VariableExpression) || !((target2 = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)left)) instanceof VariableExpression) || (classNodes2 = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var2 = (VariableExpression)target2)) == null || classNodes2.size() <= 1) continue;
                ClassNode lub = WideningCategories.lowestUpperBound(classNodes2);
                String message = StaticTypeCheckingSupport.getOperationName(((BinaryExpression)expression).getOperation().getType());
                if (message == null || !(method = this.findMethod(lub, message, this.getType(((BinaryExpression)expression).getRightExpression()))).isEmpty()) continue;
                this.addStaticTypeError("A closure shared variable [" + target2.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(message, this.getType(((BinaryExpression)expression).getRightExpression())) + "] does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", expression);
                continue;
            }
            if (!(expression instanceof MethodCallExpression) || !((objectExpression = (call = (MethodCallExpression)expression).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params = StaticTypeCheckingVisitor.extractTypesFromParameters(parameters);
            ClassNode[] argTypes = (ClassNode[])wrapper.getData();
            List<MethodNode> method = this.findMethod(lub, methodNode.getName(), argTypes);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params) + "] does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call);
        }
        this.extension.finish();
    }

    protected static ClassNode[] extractTypesFromParameters(Parameter[] parameters) {
        return (ClassNode[])Arrays.stream(parameters).map(Parameter::getType).toArray(ClassNode[]::new);
    }

    protected static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    protected static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        ClassNode outer = start.getOuterClass();
        if (outer != null) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, outer);
        }
        return false;
    }

    private static BinaryExpression assignX(Expression lhs, Expression rhs, ASTNode pos) {
        BinaryExpression exp = (BinaryExpression)GeneralUtils.assignX(lhs, rhs);
        exp.setSourcePosition(pos);
        return exp;
    }

    protected class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final boolean onlySharedVariables;
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this(varOrigType, false);
        }

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType, boolean onlySharedVariables) {
            this.varOrigType = varOrigType;
            this.onlySharedVariables = onlySharedVariables;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.getSourceUnit();
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression);
            if ((!this.onlySharedVariables || var.isClosureSharedVariable()) && var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                ClassNode cn = (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                if (cn == null) {
                    cn = ve.getOriginType();
                }
                this.varOrigType.put(ve, cn);
            }
            super.visitVariableExpression(expression);
        }
    }

    private static class ParameterVariableExpression
    extends VariableExpression {
        private final Parameter parameter;

        ParameterVariableExpression(Parameter parameter) {
            super(parameter);
            this.parameter = parameter;
            ClassNode inferred = (ClassNode)parameter.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (inferred == null) {
                inferred = ParameterVariableExpression.infer(parameter);
                parameter.setNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, inferred);
            }
        }

        private static ClassNode infer(Variable variable) {
            GenericsType gt;
            ClassNode[] upperBounds;
            GenericsType[] genericsTypes;
            ClassNode originType = variable.getOriginType();
            if (originType.isGenericsPlaceHolder() && (genericsTypes = originType.getGenericsTypes()) != null && genericsTypes.length > 0 && (upperBounds = (gt = genericsTypes[0]).getUpperBounds()) != null && upperBounds.length > 0) {
                return upperBounds[0];
            }
            return originType;
        }

        @Override
        public void copyNodeMetaData(ASTNode other) {
            this.parameter.copyNodeMetaData(other);
        }

        @Override
        public Object putNodeMetaData(Object key, Object value) {
            return this.parameter.putNodeMetaData(key, value);
        }

        @Override
        public void removeNodeMetaData(Object key) {
            this.parameter.removeNodeMetaData(key);
        }

        @Override
        public Map<?, ?> getNodeMetaData() {
            return this.parameter.getNodeMetaData();
        }

        @Override
        public <T> T getNodeMetaData(Object key) {
            return this.parameter.getNodeMetaData(key);
        }

        @Override
        public void setNodeMetaData(Object key, Object value) {
            this.parameter.setNodeMetaData(key, value);
        }

        public int hashCode() {
            return this.parameter.hashCode();
        }

        public boolean equals(Object other) {
            return this.parameter.equals(other);
        }
    }

    private static class SetterInfo {
        final ClassNode receiverType;
        final String name;
        final List<MethodNode> setters;

        private SetterInfo(ClassNode receiverType, String name, List<MethodNode> setters) {
            this.receiverType = receiverType;
            this.setters = setters;
            this.name = name;
        }
    }

    public static class SignatureCodecFactory {
        public static SignatureCodec getCodec(int version, ClassLoader classLoader) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1(classLoader);
                }
            }
            return null;
        }
    }

    private static class ExtensionMethodDeclaringClass {
        private ExtensionMethodDeclaringClass() {
        }
    }
}

