/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas.resolver;

import com.dscalzi.claritas.exception.UnknownLibraryException;
import com.dscalzi.claritas.resolver.MetadataResolver;
import com.dscalzi.claritas.resolver.ResolverConfiguration;
import com.dscalzi.claritas.resolver.library.LibraryType;
import com.dscalzi.claritas.resolver.library.forge.ForgeConfiguration;

public final class ResolverRegistry {
    private static ResolverConfiguration getLibraryConfiguration(LibraryType type) {
        switch (type) {
            case FORGE: {
                return new ForgeConfiguration();
            }
        }
        throw new UnknownLibraryException(type.name());
    }

    public static MetadataResolver getMetadataResolver(LibraryType type, String libraryVersion) {
        return ResolverRegistry.getLibraryConfiguration(type).withMinecraftVersion(libraryVersion).getResolver();
    }
}

