"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntersectionTypeFormatter = void 0;
const IntersectionType_1 = require("../Type/IntersectionType");
const allOfDefinition_1 = require("../Utils/allOfDefinition");
const uniqueArray_1 = require("../Utils/uniqueArray");
class IntersectionTypeFormatter {
    constructor(childTypeFormatter) {
        this.childTypeFormatter = childTypeFormatter;
    }
    supportsType(type) {
        return type instanceof IntersectionType_1.IntersectionType;
    }
    getDefinition(type) {
        const types = type.getTypes();
        return types.length > 1
            ? types.reduce((0, allOfDefinition_1.getAllOfDefinitionReducer)(this.childTypeFormatter), {
                type: "object",
                additionalProperties: false,
            })
            : this.childTypeFormatter.getDefinition(types[0]);
    }
    getChildren(type) {
        return (0, uniqueArray_1.uniqueArray)(type
            .getTypes()
            .reduce((result, item) => [...result, ...this.childTypeFormatter.getChildren(item)], []));
    }
}
exports.IntersectionTypeFormatter = IntersectionTypeFormatter;
//# sourceMappingURL=IntersectionTypeFormatter.js.map