/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas;

import com.dscalzi.claritas.discovery.LibraryAnalyzer;
import com.dscalzi.claritas.discovery.dto.ModuleMetadata;
import com.dscalzi.claritas.exception.UnknownLibraryException;
import com.dscalzi.claritas.resolver.library.LibraryType;
import com.dscalzi.claritas.util.FileUtil;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String VM_OPTION_ARG_FILE = "claritas.argFile";
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        LibraryType type;
        String[] workingArgs = Main.resolveArgSource(args);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> absoluteJarPathsOpt = parser.accepts("absoluteJarPaths").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> libraryTypeOpt = parser.accepts("libraryType").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> mcVersionOpt = parser.accepts("mcVersion").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> outputFileOpt = parser.accepts("outputFile").withOptionalArg().defaultsTo("./output.json", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> previewOutputOpt = parser.accepts("previewOutput").withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        OptionSet options = parser.parse(workingArgs);
        String libRaw = options.valueOf(libraryTypeOpt);
        try {
            type = LibraryType.valueOf(libRaw);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownLibraryException(libRaw);
        }
        String mcVersion = options.valueOf(mcVersionOpt);
        String[] absoluteJarPaths = options.valueOf(absoluteJarPathsOpt).split(",");
        String outputFile = options.valueOf(outputFileOpt);
        if (!outputFile.endsWith(".json")) {
            outputFile = outputFile + ".json";
        }
        File realOutputFile = new File(outputFile);
        FileUtil.ensureParentsExist(realOutputFile);
        log.debug("TYPE       = {}", (Object)type.name());
        log.debug("MC VERSION = {}", (Object)mcVersion);
        log.debug("JAR PATHS  = {}", (Object)absoluteJarPaths);
        log.debug("OUTPUT     = {}", (Object)outputFile);
        LinkedHashMap<String, ModuleMetadata> results = new LinkedHashMap<String, ModuleMetadata>();
        for (String pth : absoluteJarPaths) {
            LibraryAnalyzer analyzer = new LibraryAnalyzer(type, mcVersion, pth);
            ModuleMetadata md = analyzer.analyze();
            results.put(pth.replace("\\\\", "\\"), md);
        }
        try (FileWriter writer = new FileWriter(realOutputFile);){
            new Gson().toJson(results, (Appendable)writer);
            log.info("Result saved to {}", (Object)FileUtil.getNormalizedAbsolute(realOutputFile));
            if (options.valueOf(previewOutputOpt).booleanValue()) {
                System.out.println("results::" + new Gson().toJson(results));
            }
        }
        catch (Exception e) {
            log.error("Failed to save output.", e);
            System.exit(-1);
        }
    }

    protected static String[] resolveArgSource(String[] mainArgs) {
        String argFilePath = System.getProperty(VM_OPTION_ARG_FILE);
        if (argFilePath == null) {
            return mainArgs;
        }
        File argFile = new File(argFilePath);
        if (!argFile.exists()) {
            log.error("Resolved argFile: {}", (Object)FileUtil.getNormalizedAbsolute(argFile));
            throw new IllegalArgumentException(String.format("ArgFile %s does not exist!", argFilePath));
        }
        try {
            log.info("Pulling arguments from argFile at {}", (Object)FileUtil.getNormalizedAbsolute(argFile));
            String argFileContent = new String(Files.readAllBytes(argFile.toPath()));
            return argFileContent.split("\\r?\\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("IOException while processing argFile");
            System.exit(-1);
            return null;
        }
    }
}

