"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibRepoStructure = void 0;
const BaseMavenRepo_1 = require("./BaseMavenRepo");
class LibRepoStructure extends BaseMavenRepo_1.BaseMavenRepo {
    constructor(absoluteRoot, relativeRoot) {
        super(absoluteRoot, relativeRoot, 'lib');
    }
    getLoggerName() {
        return 'LibRepoStructure';
    }
    getLocalForge(version, classifier) {
        return this.getArtifactByComponents(LibRepoStructure.FORGE_GROUP, LibRepoStructure.FORGE_ARTIFACT, version, classifier, 'jar');
    }
}
exports.LibRepoStructure = LibRepoStructure;
LibRepoStructure.MINECRAFT_GROUP = 'net.minecraft';
LibRepoStructure.MINECRAFT_CLIENT_ARTIFACT = 'client';
LibRepoStructure.FORGE_GROUP = 'net.minecraftforge';
LibRepoStructure.FORGE_ARTIFACT = 'forge';
//# sourceMappingURL=LibRepo.struct.js.map