"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JarExecutor = void 0;
const javautil_1 = require("./javautil");
const child_process_1 = require("child_process");
const LoggerUtil_1 = require("../LoggerUtil");
class JarExecutor {
    constructor(loggerName) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.stdoutListeners = [];
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.stderrListeners = [];
        this.onCloseListeners = [];
        this.logger = LoggerUtil_1.LoggerUtil.getLogger(loggerName);
    }
    executeJar(vmOptions, ...args) {
        this.lastExecutionResult = undefined;
        return new Promise((resolve, reject) => {
            const child = (0, child_process_1.spawn)(javautil_1.JavaUtil.getJavaExecutable(), [
                ...vmOptions,
                '-jar',
                this.getJarPath(),
                ...args
            ]);
            child.stdout.on('data', (data) => this.logger.info(data.toString('utf8').trim()));
            this.stdoutListeners.forEach(l => child.stdout.on('data', l));
            child.stderr.on('data', (data) => this.logger.error(data.toString('utf8').trim()));
            this.stderrListeners.forEach(l => child.stderr.on('data', l));
            child.on('close', async (code) => {
                this.logger.info('Exited with code', code);
                for (const l of this.onCloseListeners) {
                    await l(code);
                }
                resolve(this.lastExecutionResult);
            });
            child.on('error', (err) => {
                this.logger.info('Error during process execution', err);
                reject(err);
            });
        });
    }
}
exports.JarExecutor = JarExecutor;
//# sourceMappingURL=JarExecutor.js.map