"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryStructure = void 0;
const Module_struct_1 = require("./Module.struct");
const helios_distribution_types_1 = require("helios-distribution-types");
const path_1 = require("path");
const url_1 = require("url");
class LibraryStructure extends Module_struct_1.ModuleStructure {
    constructor(absoluteRoot, relativeRoot, baseUrl, minecraftVersion, untrackedFiles) {
        super(absoluteRoot, relativeRoot, 'libraries', baseUrl, minecraftVersion, helios_distribution_types_1.Type.Library, untrackedFiles, (name) => {
            return name.toLowerCase().endsWith(helios_distribution_types_1.TypeMetadata[this.type].defaultExtension);
        });
    }
    getLoggerName() {
        return 'LibraryStructure';
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModuleId(name, path) {
        const inference = this.attemptCrudeInference(name);
        return this.generateMavenIdentifier(this.getDefaultGroup(), inference.name, inference.version);
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModuleName(name, path) {
        const inference = this.attemptCrudeInference(name);
        return inference.name;
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModuleUrl(name, path, stats) {
        return new url_1.URL((0, path_1.join)(this.relativeRoot, name), this.baseUrl).toString();
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async getModulePath(name, path, stats) {
        return null;
    }
}
exports.LibraryStructure = LibraryStructure;
//# sourceMappingURL=Library.struct.js.map