/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.claritas.asm;

import com.dscalzi.claritas.asm.AccumulatingAnnotationVisitor;
import com.dscalzi.claritas.asm.dto.AnnotationData;
import com.dscalzi.claritas.util.Tuple;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class ClaritasClassVisitor
extends ClassVisitor {
    private Type classType;
    private Type superType;
    private final LinkedList<Type> interfaceTypes = new LinkedList();
    private final LinkedList<AnnotationData> annotations = new LinkedList();

    public ClaritasClassVisitor() {
        super(589824);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classType = Type.getObjectType(name);
        Type type = this.superType = superName != null && !superName.isEmpty() ? Type.getObjectType(superName) : null;
        if (interfaces != null) {
            Arrays.stream(interfaces).map(Type::getObjectType).forEach(this.interfaceTypes::add);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        Type t = Type.getType(descriptor);
        AnnotationData ann = new AnnotationData(t.getClassName(), this.getClassName());
        this.annotations.addFirst(ann);
        return new AccumulatingAnnotationVisitor(ann);
    }

    public String getClassName() {
        return this.classType.getClassName();
    }

    public String getSuperClassName() {
        return this.superType != null ? this.superType.getClassName() : null;
    }

    public Tuple<String, List<String>> getInterfaces() {
        return new Tuple<String, List<String>>(this.getClassName(), this.interfaceTypes.stream().map(Type::getClassName).collect(Collectors.toList()));
    }

    public LinkedList<AnnotationData> getAnnotations() {
        return this.annotations;
    }
}

