"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerUtil = void 0;
const winston_1 = require("winston");
const triple_beam_1 = require("triple-beam");
const luxon_1 = require("luxon");
const util_1 = require("util");
// Workaround until fixed.
// https://github.com/winstonjs/logform/issues/111
const SPLAT = triple_beam_1.SPLAT;
class LoggerUtil {
    static getLogger(label) {
        return (0, winston_1.createLogger)({
            format: winston_1.format.combine(winston_1.format.label(), winston_1.format.colorize(), winston_1.format.label({ label }), winston_1.format.printf(info => {
                if (info[SPLAT]) {
                    if (info[SPLAT].length === 1 && info[SPLAT][0] instanceof Error) {
                        const err = info[SPLAT][0];
                        if (info.message.length > err.message.length && info.message.endsWith(err.message)) {
                            info.message = info.message.substring(0, info.message.length - err.message.length);
                        }
                    }
                    else if (info[SPLAT].length > 0) {
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        info.message += ' ' + info[SPLAT].map((it) => {
                            if (typeof it === 'object' && it != null) {
                                return (0, util_1.inspect)(it, false, 4, true);
                            }
                            return it;
                        }).join(' ');
                    }
                }
                if (typeof info.message === 'object') {
                    info.message = (0, util_1.inspect)(info.message, false, 4, true);
                }
                return `[${luxon_1.DateTime.local().toFormat('yyyy-MM-dd TT').trim()}] [${info.level}] [${info.label}]: ${info.message}${info.stack ? `\n${info.stack}` : ''}`;
            })),
            level: 'debug',
            transports: [
                new winston_1.transports.Console()
            ]
        });
    }
}
exports.LoggerUtil = LoggerUtil;
//# sourceMappingURL=LoggerUtil.js.map