"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinecraftVersion = void 0;
class MinecraftVersion {
    constructor(version) {
        const res = MinecraftVersion.MINECRAFT_VERSION_REGEX.exec(version);
        if (res != null) {
            this.major = Number(res[1]);
            this.minor = Number(res[2]);
            this.revision = Number(res[3]);
        }
        else {
            throw new Error(`${version} is not a valid minecraft version!`);
        }
    }
    static isMinecraftVersion(version) {
        return MinecraftVersion.MINECRAFT_VERSION_REGEX.test(version);
    }
    getMajor() { return this.major; }
    getMinor() { return this.minor; }
    getRevision() { return this.revision; }
    toString() { return `${this.major}.${this.minor}.${this.revision}`; }
}
exports.MinecraftVersion = MinecraftVersion;
MinecraftVersion.MINECRAFT_VERSION_REGEX = /(\d+).(\d+).(\d+)/;
//# sourceMappingURL=MinecraftVersion.js.map