"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateSchemas = exports.addSchemaToObject = exports.SchemaTypes = void 0;
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const ts_json_schema_generator_1 = require("ts-json-schema-generator");
const url_1 = require("url");
const LoggerUtil_1 = require("./LoggerUtil");
const logger = LoggerUtil_1.LoggerUtil.getLogger('SchemaUtil');
var SchemaTypes;
(function (SchemaTypes) {
    SchemaTypes["DistroMetaSchema"] = "DistroMetaSchema";
    SchemaTypes["ServerMetaSchema"] = "ServerMetaSchema";
})(SchemaTypes = exports.SchemaTypes || (exports.SchemaTypes = {}));
function getSchemaFileName(typeName) {
    return `${typeName}.schema.json`;
}
function getSchemaDirectory(absoluteRoot) {
    return (0, path_1.resolve)(absoluteRoot, 'schemas');
}
function getSchemaLocation(typeName, absoluteRoot) {
    return (0, path_1.resolve)(getSchemaDirectory(absoluteRoot), getSchemaFileName(typeName));
}
function addSchemaToObject(obj, typeName, absoluteRoot) {
    return {
        $schema: new url_1.URL(`file:${getSchemaLocation(typeName, absoluteRoot)}`).href,
        ...obj
    };
}
exports.addSchemaToObject = addSchemaToObject;
async function generateSchemas(absoluteRoot) {
    const selfPath = __filename.replace('dist', 'src').replace('.js', '.ts');
    const schemaDir = getSchemaDirectory(absoluteRoot);
    if (await (0, fs_extra_1.pathExists)(schemaDir)) {
        await (0, fs_extra_1.remove)(schemaDir);
    }
    await (0, fs_extra_1.mkdirs)(schemaDir);
    for (const typeName of Object.values(SchemaTypes)) {
        logger.info(`Generating schema for ${typeName}`);
        const schema = (0, ts_json_schema_generator_1.createGenerator)({
            tsconfig: (0, path_1.join)(__dirname, '..', '..', 'tsconfig.json'),
            path: selfPath,
            type: typeName
        }).createSchema(typeName);
        const schemaString = JSON.stringify(schema);
        const schemaLoc = getSchemaLocation(typeName, absoluteRoot);
        await (0, fs_extra_1.writeFile)(schemaLoc, schemaString);
        logger.info(`Schema for ${typeName} saved to ${schemaLoc}`);
    }
}
exports.generateSchemas = generateSchemas;
//# sourceMappingURL=SchemaUtil.js.map