"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionUtil = void 0;
const got_1 = __importDefault(require("got"));
const LoggerUtil_1 = require("./LoggerUtil");
class VersionUtil {
    static isVersionAcceptable(version, acceptable) {
        if (version.getMajor() === 1) {
            return acceptable.find((element) => version.getMinor() === element) != null;
        }
        return false;
    }
    static isOneDotTwelveFG2(libraryVersion) {
        const maxFG2 = [14, 23, 5, 2847];
        const verSplit = libraryVersion.split('.').map(v => Number(v));
        for (let i = 0; i < maxFG2.length; i++) {
            if (verSplit[i] > maxFG2[i]) {
                return false;
            }
        }
        return true;
    }
    static isPromotionVersion(version) {
        return VersionUtil.PROMOTION_TYPE.indexOf(version.toLowerCase()) > -1;
    }
    static async getPromotionIndex() {
        const response = await got_1.default.get({
            method: 'get',
            url: 'https://files.minecraftforge.net/maven/net/minecraftforge/forge/promotions_slim.json',
            responseType: 'json'
        });
        return response.body;
    }
    static getPromotedVersionStrict(index, minecraftVersion, promotion) {
        const workingPromotion = promotion.toLowerCase();
        return index.promos[`${minecraftVersion}-${workingPromotion}`];
    }
    static async getPromotedForgeVersion(minecraftVersion, promotion) {
        const workingPromotion = promotion.toLowerCase();
        const res = await VersionUtil.getPromotionIndex();
        let version = res.promos[`${minecraftVersion}-${workingPromotion}`];
        if (version == null) {
            VersionUtil.logger.warn(`No ${workingPromotion} version found for Forge ${minecraftVersion}.`);
            VersionUtil.logger.warn('Attempting to pull latest version instead.');
            version = res.promos[`${minecraftVersion}-latest`];
            if (version == null) {
                throw new Error(`No latest version found for Forge ${minecraftVersion}.`);
            }
        }
        return version;
    }
    static versionGte(version, min) {
        const left = version.split('.').map(x => Number(x));
        const right = min.split('.').map(x => Number(x));
        if (left.length != right.length) {
            throw new Error('Cannot compare mismatched versions.');
        }
        for (let i = 0; i < left.length; i++) {
            if (left[i] < right[i]) {
                return false;
            }
        }
        return true;
    }
}
exports.VersionUtil = VersionUtil;
VersionUtil.logger = LoggerUtil_1.LoggerUtil.getLogger('VersionUtil');
VersionUtil.PROMOTION_TYPE = [
    'recommended',
    'latest'
];
VersionUtil.MINECRAFT_VERSION_REGEX = /(\d+).(\d+).(\d+)/;
//# sourceMappingURL=versionutil.js.map