"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeMetadata = exports.Type = void 0;
var Type;
(function (Type) {
    Type["Library"] = "Library";
    Type["ForgeHosted"] = "ForgeHosted";
    Type["Forge"] = "Forge";
    Type["LiteLoader"] = "LiteLoader";
    Type["ForgeMod"] = "ForgeMod";
    Type["LiteMod"] = "LiteMod";
    Type["File"] = "File";
    Type["VersionManifest"] = "VersionManifest";
})(Type = exports.Type || (exports.Type = {}));
exports.TypeMetadata = {
    Library: {
        id: Type.Library,
        defaultExtension: 'jar'
    },
    /**
     * @deprecated Will be replaced by Types.Forge.
     */
    ForgeHosted: {
        id: Type.ForgeHosted,
        defaultExtension: 'jar'
    },
    Forge: {
        id: Type.Forge,
        defaultExtension: 'jar'
    },
    LiteLoader: {
        id: Type.LiteLoader,
        defaultExtension: 'jar'
    },
    ForgeMod: {
        id: Type.ForgeMod,
        defaultExtension: 'jar'
    },
    LiteMod: {
        id: Type.LiteMod,
        defaultExtension: 'litemod'
    },
    File: {
        id: Type.File
    },
    VersionManifest: {
        id: Type.VersionManifest,
        defaultExtension: 'json'
    }
};
