/*
 * Decompiled with CFR 0.152.
 */
package com.dscalzi.packxzextract;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import org.tukaani.xz.XZInputStream;

public class PXZEMain {
    private static final Pattern xz = Pattern.compile("(?i)\\.xz");
    private static final Pattern pack = Pattern.compile("(?i)\\.pack");

    public static void main(String[] args) {
        ArrayList<File> xzQueue = new ArrayList<File>();
        ArrayList<File> unpackQueue = new ArrayList<File>();
        ArrayList<File> packXZQueue = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            String[] paths;
            if (args[i].equalsIgnoreCase("-packxz")) {
                if (i + 1 >= args.length) continue;
                for (String s : paths = args[++i].split(",")) {
                    packXZQueue.add(new File(s));
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-xz")) {
                if (i + 1 >= args.length) continue;
                for (String s : paths = args[++i].split(",")) {
                    xzQueue.add(new File(s));
                }
                continue;
            }
            if (!args[i].equalsIgnoreCase("-pack") || i + 1 >= args.length) continue;
            for (String s : paths = args[++i].split(",")) {
                unpackQueue.add(new File(s));
            }
        }
        for (File f : packXZQueue) {
            PXZEMain.unpack(PXZEMain.extractXZ(f));
        }
        for (File f : xzQueue) {
            PXZEMain.extractXZ(f);
        }
        for (File f : unpackQueue) {
            PXZEMain.unpack(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractXZ(File compressedFile) {
        if (compressedFile == null) {
            return null;
        }
        File unpacked = new File(compressedFile.getParentFile(), xz.matcher(compressedFile.getName()).replaceAll(""));
        try (XZInputStream input = new XZInputStream(new FileInputStream(compressedFile));
             FileOutputStream output = new FileOutputStream(unpacked);){
            byte[] buf = new byte[65536];
            int read = input.read(buf);
            while (read >= 1) {
                ((OutputStream)output).write(buf, 0, read);
                read = input.read(buf);
            }
        }
        catch (Exception e) {
            System.err.println("Unable to extract xz: " + e.getMessage());
            File file = null;
            return file;
        }
        finally {
            compressedFile.delete();
        }
        System.out.println("Successfully extracted " + compressedFile.getName());
        return unpacked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File unpack(File compressedFile) {
        if (compressedFile == null) {
            return null;
        }
        File unpacked = new File(compressedFile.getParentFile(), pack.matcher(compressedFile.getName()).replaceAll(""));
        try (JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(unpacked));){
            Pack200.newUnpacker().unpack(compressedFile, jarStream);
        }
        catch (Exception e) {
            System.err.println("Unable to unpack: " + e.getMessage());
            File file = null;
            return file;
        }
        finally {
            compressedFile.delete();
        }
        System.out.println("Successfully unpacked " + compressedFile.getName());
        return unpacked;
    }
}

