"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionRepoStructure = void 0;
const path_1 = require("path");
const url_1 = require("url");
const BaseFileStructure_1 = require("../BaseFileStructure");
class VersionRepoStructure extends BaseFileStructure_1.BaseFileStructure {
    constructor(absoluteRoot, relativeRoot) {
        super(absoluteRoot, relativeRoot, 'versions');
    }
    getLoggerName() {
        return 'VersionRepoStructure';
    }
    getFileName(minecraftVersion, forgeVersion) {
        return `${minecraftVersion}-forge-${forgeVersion}`;
    }
    getVersionManifest(minecraftVersion, forgeVersion) {
        const fileName = this.getFileName(minecraftVersion, forgeVersion);
        return (0, path_1.join)(this.containerDirectory, fileName, `${fileName}.json`);
    }
    getVersionManifestURL(url, minecraftVersion, forgeVersion) {
        const fileName = this.getFileName(minecraftVersion, forgeVersion);
        return new url_1.URL((0, path_1.join)(this.relativeRoot, fileName, `${fileName}.json`), url).toString();
    }
}
exports.VersionRepoStructure = VersionRepoStructure;
//# sourceMappingURL=VersionRepo.struct.js.map