"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionSegmentedRegistry = void 0;
const ForgeMod113_struct_1 = require("../structure/spec_model/module/forgemod/ForgeMod113.struct");
const ForgeMod17_struct_1 = require("../structure/spec_model/module/forgemod/ForgeMod17.struct");
const ForgeGradle3_resolver_1 = require("../resolver/forge/adapter/ForgeGradle3.resolver");
const ForgeGradle2_resolver_1 = require("../resolver/forge/adapter/ForgeGradle2.resolver");
class VersionSegmentedRegistry {
    static getForgeResolver(minecraftVersion, forgeVersion, absoluteRoot, relativeRoot, baseURL, discardOutput, invalidateCache) {
        for (const impl of VersionSegmentedRegistry.FORGE_ADAPTER_IMPL) {
            if (impl.isForVersion(minecraftVersion, forgeVersion)) {
                return new impl(absoluteRoot, relativeRoot, baseURL, minecraftVersion, forgeVersion, discardOutput, invalidateCache);
            }
        }
        throw new Error(`No forge resolver found for Minecraft ${minecraftVersion}!`);
    }
    static getForgeModStruct(minecraftVersion, forgeVersion, absoluteRoot, relativeRoot, baseUrl, untrackedFiles) {
        for (const impl of VersionSegmentedRegistry.FORGEMOD_STRUCT_IML) {
            if (impl.isForVersion(minecraftVersion, forgeVersion)) {
                return new impl(absoluteRoot, relativeRoot, baseUrl, minecraftVersion, untrackedFiles);
            }
        }
        throw new Error(`No forge mod structure found for Minecraft ${minecraftVersion}!`);
    }
}
exports.VersionSegmentedRegistry = VersionSegmentedRegistry;
VersionSegmentedRegistry.FORGE_ADAPTER_IMPL = [
    ForgeGradle2_resolver_1.ForgeGradle2Adapter,
    ForgeGradle3_resolver_1.ForgeGradle3Adapter
];
VersionSegmentedRegistry.FORGEMOD_STRUCT_IML = [
    ForgeMod17_struct_1.ForgeModStructure17,
    ForgeMod113_struct_1.ForgeModStructure113
];
//# sourceMappingURL=VersionSegmentedRegistry.js.map