"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClaritasWrapper = void 0;
const JarExecutor_1 = require("./JarExecutor");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
class ClaritasWrapper extends JarExecutor_1.JarExecutor {
    constructor(cwd) {
        super('Claritas');
        this.WORK_DIR = (0, path_1.resolve)(cwd, 'claritasWork');
        this.ARG_FILE = (0, path_1.resolve)(this.WORK_DIR, 'claritasArgFile.txt');
        this.OUTPUT_FILE = (0, path_1.resolve)(this.WORK_DIR, 'claritasOutput.json');
        this.onCloseListeners.push(async (code) => {
            if (code !== 0) {
                this.logger.error('Claritas finished with non-zero exit code, ', code);
                this.lastExecutionResult = undefined;
            }
            else {
                if (await (0, fs_extra_1.pathExists)(this.OUTPUT_FILE)) {
                    this.lastExecutionResult = JSON.parse((await (0, fs_extra_1.readFile)(this.OUTPUT_FILE)).toString('utf8'));
                }
                else {
                    this.logger.error('Claritas output file not found when exit code is 0, is this a bug?');
                    this.lastExecutionResult = undefined;
                }
            }
            await this.cleanOutput();
        });
    }
    getJarPath() {
        return (0, path_1.join)(process.cwd(), 'libraries', 'java', 'Claritas.jar');
    }
    async writeArgFile(...programArgs) {
        await (0, fs_extra_1.mkdirs)(this.WORK_DIR);
        await (0, fs_extra_1.writeFile)(this.ARG_FILE, programArgs.join('\n'));
    }
    async execute(libraryType, mcVersion, absoluteJarPaths) {
        await this.writeArgFile('--absoluteJarPaths', absoluteJarPaths.join(','), '--libraryType', libraryType, '--mcVersion', mcVersion.toString(), '--outputFile', this.OUTPUT_FILE, '--previewOutput', 'true');
        return await super.executeJar([`-Dclaritas.argFile=${this.ARG_FILE}`]);
    }
    async cleanOutput() {
        if (await (0, fs_extra_1.pathExists)(this.WORK_DIR)) {
            (0, fs_extra_1.remove)(this.WORK_DIR);
        }
    }
}
exports.ClaritasWrapper = ClaritasWrapper;
//# sourceMappingURL=ClaritasWrapper.js.map