"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributionStructure = void 0;
const fs_extra_1 = require("fs-extra");
const Server_struct_1 = require("./Server.struct");
const path_1 = require("path");
const distrometa_1 = require("../../model/nebula/distrometa");
const SchemaUtil_1 = require("../../util/SchemaUtil");
const LoggerUtil_1 = require("../../util/LoggerUtil");
const logger = LoggerUtil_1.LoggerUtil.getLogger('DistributionStructure');
class DistributionStructure {
    constructor(absoluteRoot, baseUrl, discardOutput, invalidateCache) {
        this.absoluteRoot = absoluteRoot;
        this.baseUrl = baseUrl;
        this.DISTRO_META_FILE = 'distrometa.json';
        this.serverStruct = new Server_struct_1.ServerStructure(this.absoluteRoot, this.baseUrl, discardOutput, invalidateCache);
        this.metaPath = (0, path_1.join)(this.absoluteRoot, 'meta');
    }
    async init() {
        await (0, fs_extra_1.mkdirs)(this.absoluteRoot);
        await (0, fs_extra_1.mkdirs)(this.metaPath);
        const distroMetaFile = (0, path_1.resolve)(this.metaPath, this.DISTRO_META_FILE);
        if (await (0, fs_extra_1.pathExists)(distroMetaFile)) {
            logger.warn(`Distro Meta file already exists at ${distroMetaFile}!`);
            logger.warn('If you wish to regenerate this file, you must delete the existing one!');
        }
        else {
            const distroMeta = (0, SchemaUtil_1.addSchemaToObject)((0, distrometa_1.getDefaultDistroMeta)(), SchemaUtil_1.SchemaTypes.DistroMetaSchema, this.absoluteRoot);
            await (0, fs_extra_1.writeFile)(distroMetaFile, JSON.stringify(distroMeta, null, 2));
        }
        await this.serverStruct.init();
    }
    async getSpecModel() {
        const distroMeta = JSON.parse(await (0, fs_extra_1.readFile)((0, path_1.resolve)(this.metaPath, this.DISTRO_META_FILE), 'utf-8'));
        return {
            version: '1.0.0',
            rss: distroMeta.meta.rss,
            ...(distroMeta.meta.discord ? { discord: distroMeta.meta.discord } : {}),
            servers: await this.serverStruct.getSpecModel()
        };
    }
}
exports.DistributionStructure = DistributionStructure;
//# sourceMappingURL=Distribution.struct.js.map