/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

public class ByteBufUtils {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(ByteBuf buf, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i2 = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i2 |= (b0 & 0x7F) << j++ * 7;
            if (j <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i2;
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((ByteBufUtils.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }

    public static String readUTF8String(ByteBuf from) {
        int len = ByteBufUtils.readVarInt(from, 2);
        String str = from.toString(from.readerIndex(), len, StandardCharsets.UTF_8);
        from.readerIndex(from.readerIndex() + len);
        return str;
    }

    public static void writeUTF8String(ByteBuf to, String string) {
        byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
        Validate.isTrue((ByteBufUtils.varIntByteCount(utf8Bytes.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        ByteBufUtils.writeVarInt(to, utf8Bytes.length, 2);
        to.writeBytes(utf8Bytes);
    }

    public static void writeItemStack(ByteBuf to, aip stack) {
        gy pb = new gy(to);
        pb.a(stack);
    }

    public static aip readItemStack(ByteBuf from) {
        gy pb = new gy(from);
        try {
            return pb.k();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeTag(ByteBuf to, fy tag) {
        gy pb = new gy(to);
        pb.a(tag);
    }

    @Nullable
    public static fy readTag(ByteBuf from) {
        gy pb = new gy(from);
        try {
            return pb.j();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void writeRegistryEntry(@Nonnull ByteBuf out, @Nonnull T entry) {
        ForgeRegistry registry = (ForgeRegistry)GameRegistry.findRegistry(entry.getRegistryType());
        ByteBufUtils.writeUTF8String(out, RegistryManager.ACTIVE.getName(registry).toString());
        ByteBufUtils.writeVarInt(out, registry.getID(entry), 5);
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry<T>> T readRegistryEntry(@Nonnull ByteBuf in, @Nonnull IForgeRegistry<T> registry) {
        String registryName = ByteBufUtils.readUTF8String(in);
        int id = ByteBufUtils.readVarInt(in, 5);
        nf expectedRegistryName = RegistryManager.ACTIVE.getName(registry);
        if (!expectedRegistryName.toString().equals(registryName)) {
            throw new IllegalArgumentException("Registry mismatch: " + registryName + " != " + expectedRegistryName);
        }
        Object thing = ((ForgeRegistry)registry).getRaw(id);
        if (thing == null) {
            throw new IllegalArgumentException("Unknown ID " + id + " for registry " + expectedRegistryName + " received.");
        }
        return (T)thing;
    }

    public static <T extends IForgeRegistryEntry<T>> void writeRegistryEntries(@Nonnull ByteBuf out, @Nonnull Collection<T> entries) {
        ByteBufUtils.writeVarInt(out, entries.size(), 5);
        Iterator<T> it = entries.iterator();
        if (it.hasNext()) {
            IForgeRegistryEntry first = (IForgeRegistryEntry)it.next();
            ForgeRegistry registry = (ForgeRegistry)GameRegistry.findRegistry(first.getRegistryType());
            ByteBufUtils.writeUTF8String(out, RegistryManager.ACTIVE.getName(registry).toString());
            ByteBufUtils.writeVarInt(out, registry.getID(first), 5);
            while (it.hasNext()) {
                int id = registry.getID((IForgeRegistryEntry)it.next());
                if (id == -1) {
                    throw new IllegalArgumentException("Unregistered IForgeRegistryEntry in collection " + entries + ".");
                }
                ByteBufUtils.writeVarInt(out, id, 5);
            }
        }
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry<T>> List<T> readRegistryEntries(@Nonnull ByteBuf in, @Nonnull IForgeRegistry<T> registry) {
        int size = ByteBufUtils.readVarInt(in, 5);
        if (size == 0) {
            return ImmutableList.of();
        }
        String registryName = ByteBufUtils.readUTF8String(in);
        nf expectedRegistryName = RegistryManager.ACTIVE.getName(registry);
        if (!expectedRegistryName.toString().equals(registryName)) {
            throw new IllegalArgumentException("Registry mismatch: " + registryName + " != " + expectedRegistryName);
        }
        ImmutableList.Builder b2 = ImmutableList.builder();
        for (int i2 = 0; i2 < size; ++i2) {
            int id = ByteBufUtils.readVarInt(in, 5);
            Object thing = ((ForgeRegistry)registry).getRaw(id);
            if (thing == null) {
                throw new IllegalArgumentException("Unknown ID " + id + " for registry " + expectedRegistryName + " received.");
            }
            b2.add(thing);
        }
        return b2.build();
    }

    public static String getContentDump(ByteBuf buffer) {
        int j;
        int i2;
        int currentLength = buffer.readableBytes();
        StringBuffer returnString = new StringBuffer(currentLength * 3 + currentLength + currentLength / 4 + 30);
        for (i2 = 0; i2 < currentLength; ++i2) {
            if (i2 != 0 && i2 % 16 == 0) {
                returnString.append('\t');
                for (j = i2 - 16; j < i2; ++j) {
                    if (buffer.getByte(j) < 32 || buffer.getByte(j) > 127) {
                        returnString.append('.');
                        continue;
                    }
                    returnString.append((char)buffer.getByte(j));
                }
                returnString.append("\n");
            }
            returnString.append(Integer.toString((buffer.getByte(i2) & 0xF0) >> 4, 16) + Integer.toString((buffer.getByte(i2) & 0xF) >> 0, 16));
            returnString.append(' ');
        }
        if (i2 != 0 && i2 % 16 != 0) {
            for (j = 0; j < (16 - i2 % 16) * 3; ++j) {
                returnString.append(' ');
            }
        }
        returnString.append('\t');
        for (j = i2 > 0 && i2 % 16 == 0 ? i2 - 16 : i2 - i2 % 16; i2 >= 0 && j < i2; ++j) {
            if (buffer.getByte(j) < 32 || buffer.getByte(j) > 127) {
                returnString.append('.');
                continue;
            }
            returnString.append((char)buffer.getByte(j));
        }
        returnString.append('\n');
        returnString.append("Length: " + currentLength);
        return returnString.toString();
    }
}

