/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.crafting.FluidExtract;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import com.mrcrayfish.vehicle.init.ModFluids;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidMixerRecipes {
    private static final FluidMixerRecipes INSTANCE = new FluidMixerRecipes();
    private final HashMap<FluidMixerRecipe, FluidExtract> mixingMap = Maps.newHashMap();

    public static FluidMixerRecipes getInstance() {
        return INSTANCE;
    }

    private FluidMixerRecipes() {
        this.mixingMap.put(new FluidMixerRecipe(ModFluids.BLAZE_JUICE, 200, ModFluids.ENDER_SAP, 200, new ItemStack(Items.field_151114_aO)), new FluidExtract(ModFluids.FUELIUM, 400));
    }

    public HashMap<FluidMixerRecipe, FluidExtract> getMixingMap() {
        return this.mixingMap;
    }

    @Nullable
    public FluidMixerRecipe getRecipe(Fluid fluidOne, Fluid fluidTwo, ItemStack ingredient) {
        int hashCode = fluidOne.hashCode() + fluidTwo.hashCode() + ingredient.func_77973_b().hashCode() + ingredient.func_77952_i();
        Optional<FluidMixerRecipe> optional = this.mixingMap.keySet().stream().filter(fluidMixerRecipe -> fluidMixerRecipe.hashCode() == hashCode).findFirst();
        return optional.orElse(null);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return this.mixingMap.keySet().stream().anyMatch(recipe -> FluidMixerRecipe.areItemStacksEqual(recipe.getIngredient(), ingredient));
    }

    @Nullable
    public FluidExtract getRecipeResult(FluidMixerRecipe recipe) {
        return this.mixingMap.get(recipe);
    }
}

