/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.network.message.MessageVehicleInteract;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageFuelVehicle
extends MessageVehicleInteract
implements IMessageHandler<MessageFuelVehicle, IMessage> {
    private EnumHand hand;

    public MessageFuelVehicle() {
    }

    public MessageFuelVehicle(EntityPlayer player, EnumHand hand, Entity targetEntity) {
        super(targetEntity);
        this.hand = hand;
        this.fuelVehicle(player, hand, targetEntity);
    }

    private void fuelVehicle(EntityPlayer player, EnumHand hand, Entity targetEntity) {
        if (targetEntity instanceof EntityPoweredVehicle) {
            ((EntityPoweredVehicle)targetEntity).fuelVehicle(player, hand);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.hand.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.hand = EnumHand.values()[buf.readInt()];
    }

    public IMessage onMessage(MessageFuelVehicle message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            Entity targetEntity;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null && (targetEntity = server.func_175576_a(message.targetEntityID)) != null) {
                this.fuelVehicle((EntityPlayer)player, message.hand, targetEntity);
            }
        });
        return null;
    }
}

