/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.model.layer;

import artifacts.client.model.layer.LayerBauble;
import artifacts.common.init.ModItems;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;

public class LayerGloves
extends LayerBauble {
    public final ResourceLocation feralClawsTextures;
    public final ResourceLocation powerGloveTextures;
    public final ResourceLocation mechanicalGloveTextures;
    public final ResourceLocation fireGauntletTextures;
    public final ResourceLocation fireGauntletOverlayTextures;
    public final ResourceLocation pocketPistonTextures;

    public LayerGloves(boolean smallArms, RenderPlayer renderPlayer) {
        super(renderPlayer, new ModelPlayer(0.5f, smallArms));
        this.model.func_178719_a(false);
        this.feralClawsTextures = new ResourceLocation("artifacts", "textures/entity/layer/feral_claws_" + (smallArms ? "slim" : "normal") + ".png");
        this.powerGloveTextures = new ResourceLocation("artifacts", "textures/entity/layer/power_glove_" + (smallArms ? "slim" : "normal") + ".png");
        this.mechanicalGloveTextures = new ResourceLocation("artifacts", "textures/entity/layer/mechanical_glove_" + (smallArms ? "slim" : "normal") + ".png");
        this.fireGauntletTextures = new ResourceLocation("artifacts", "textures/entity/layer/fire_gauntlet_" + (smallArms ? "slim" : "normal") + ".png");
        this.fireGauntletOverlayTextures = new ResourceLocation("artifacts", "textures/entity/layer/fire_gauntlet_overlay_" + (smallArms ? "slim" : "normal") + ".png");
        this.pocketPistonTextures = new ResourceLocation("artifacts", "textures/entity/layer/pocket_piston_" + (smallArms ? "slim" : "normal") + ".png");
    }

    @Override
    protected void renderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        float lastLightmapX = OpenGlHelper.lastBrightnessX;
        float lastLightmapY = OpenGlHelper.lastBrightnessY;
        int light = 0xF000F0;
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        this.renderArm(EnumHandSide.LEFT, player, false, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.renderArm(EnumHandSide.RIGHT, player, false, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        GlStateManager.func_179140_f();
        this.renderArm(EnumHandSide.LEFT, player, true, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.renderArm(EnumHandSide.RIGHT, player, true, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastLightmapX, (float)lastLightmapY);
    }

    private void renderArm(EnumHandSide hand, @Nonnull EntityPlayer player, boolean overlay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!this.setTextures(player, hand, overlay)) {
            return;
        }
        if (hand == EnumHandSide.LEFT) {
            this.model.field_178724_i.field_78806_j = true;
            this.model.field_178734_a.field_78806_j = true;
        } else {
            this.model.field_178723_h.field_78806_j = true;
            this.model.field_178732_b.field_78806_j = true;
        }
        this.model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (hand == EnumHandSide.LEFT) {
            this.model.field_178734_a.field_78806_j = false;
            this.model.field_178724_i.field_78806_j = false;
        } else {
            this.model.field_178732_b.field_78806_j = false;
            this.model.field_178723_h.field_78806_j = false;
        }
    }

    private boolean setTextures(EntityPlayer player, EnumHandSide hand, boolean overlay) {
        ResourceLocation textures;
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.RING.getValidSlots()[hand == EnumHandSide.LEFT ? 0 : 1]);
        ResourceLocation resourceLocation = textures = overlay ? this.getOverlayTextures(stack) : this.getTextures(stack);
        if (textures != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textures);
            return true;
        }
        return false;
    }

    @Nullable
    private ResourceLocation getTextures(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.POWER_GLOVE) {
            return this.powerGloveTextures;
        }
        if (stack.func_77973_b() == ModItems.FERAL_CLAWS) {
            return this.feralClawsTextures;
        }
        if (stack.func_77973_b() == ModItems.MECHANICAL_GLOVE) {
            return this.mechanicalGloveTextures;
        }
        if (stack.func_77973_b() == ModItems.FIRE_GAUNTLET) {
            return this.fireGauntletTextures;
        }
        if (stack.func_77973_b() == ModItems.POCKET_PISTON) {
            return this.pocketPistonTextures;
        }
        return null;
    }

    @Nullable
    private ResourceLocation getOverlayTextures(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.FIRE_GAUNTLET || stack.func_77973_b() == ModItems.MAGMA_STONE) {
            return this.fireGauntletOverlayTextures;
        }
        return null;
    }
}

