/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.entity;

import artifacts.common.ModConfig;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class EntityHallowStar
extends Entity {
    @Nullable
    public EntityLivingBase shootingEntity;
    public int ticksAlive;

    public EntityHallowStar(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityHallowStar(World world, EntityLivingBase shooter) {
        this(world);
        this.shootingEntity = shooter;
        double offSetX = 8.0 * (2.0 * this.field_70146_Z.nextDouble() - 1.0);
        double offSetZ = 8.0 * (2.0 * this.field_70146_Z.nextDouble() - 1.0);
        double offSetY = 25.0 + this.field_70146_Z.nextDouble() * 15.0;
        this.func_70107_b(shooter.field_70165_t + offSetX - 1.0 + (double)(this.field_70146_Z.nextFloat() * 2.0f), shooter.field_70163_u + offSetY, shooter.field_70161_v + offSetZ - 1.0 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
        double velocity = Math.sqrt(offSetX * offSetX + offSetY * offSetY + offSetZ * offSetZ);
        this.field_70159_w = -offSetX * 1.5 / velocity;
        this.field_70181_x = -offSetY * 1.5 / velocity;
        this.field_70179_y = -offSetZ * 1.5 / velocity;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d = this.func_174813_aQ().func_72320_b() * 6.0;
        if (Double.isNaN(d)) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shootingEntity == null || !this.shootingEntity.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this)) && this.ticksAlive < 200) {
            super.func_70071_h_();
            ++this.ticksAlive;
            RayTraceResult raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)true, (Entity)this.shootingEntity);
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksAlive = compound.func_74762_e("tickAlive");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).func_74745_c() == 3) {
            NBTTagList nbtTagList = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbtTagList.func_150309_d(0);
            this.field_70181_x = nbtTagList.func_150309_d(1);
            this.field_70179_y = nbtTagList.func_150309_d(2);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        compound.func_74768_a("ticksAlive", this.ticksAlive);
    }

    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result.field_72308_g != this.shootingEntity && !(result.field_72308_g instanceof EntityHallowStar)) {
            if (result.field_72308_g != null && !result.field_72308_g.func_70045_F()) {
                result.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("artifacts.hallow_star", (Entity)this, (Entity)this.shootingEntity).func_76349_b(), (float)ModConfig.general.starCloakDamage);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        }
        this.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
        this.func_70106_y();
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u - 0.5 * this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

