/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.common.inventory.ContainerChiselHitech;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.SoundUtil;

public class PacketChiselButton
implements IMessage {
    private int[] slotIds;

    public PacketChiselButton(int ... slots) {
        this.slotIds = slots;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slotIds.length);
        for (int i : this.slotIds) {
            buf.writeByte(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        byte len = buf.readByte();
        this.slotIds = new int[len];
        for (int i = 0; i < this.slotIds.length; ++i) {
            this.slotIds[i] = buf.readByte();
        }
    }

    public static void chiselAll(EntityPlayer player, int[] slots) {
        if (player.field_71070_bA instanceof ContainerChiselHitech) {
            ContainerChiselHitech container = (ContainerChiselHitech)player.field_71070_bA;
            ItemStack chisel = container.getChisel();
            ItemStack originalChisel = chisel.func_77946_l();
            ItemStack target = container.getTargetStack();
            if (!(chisel.func_77973_b() instanceof IChiselItem)) {
                return;
            }
            ICarvingRegistry carving = CarvingUtils.getChiselRegistry();
            if (chisel.func_190926_b() || target.func_190926_b()) {
                return;
            }
            boolean playSound = false;
            for (int i : slots) {
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (!s.func_190926_b()) {
                    if (carving.getGroup(target) != carving.getGroup(s)) {
                        return;
                    }
                    container.getInventoryChisel().setStackInSpecialSlot(s);
                    ItemStack res = SlotChiselSelection.craft(container, player, target.func_77946_l(), false);
                    if (!res.func_190926_b()) {
                        player.field_71071_by.func_70299_a(i, res);
                        playSound = true;
                    }
                }
                if (!chisel.func_190926_b()) continue;
                return;
            }
            container.getInventoryChisel().setStackInSpecialSlot(container.getSelectionStack());
            container.getInventoryChisel().updateItems();
            if (playSound) {
                SoundUtil.playSound(player, originalChisel, target);
            }
        }
    }

    public PacketChiselButton() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselButton, IMessage> {
        public IMessage onMessage(PacketChiselButton message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> PacketChiselButton.chiselAll((EntityPlayer)player, message.slotIds));
            return null;
        }
    }
}

