/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.api.block.VariationData;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.entity.EntityFallingBlockCarvable;
import team.chisel.common.init.ChiselBlocks;

public class BlockCarvableFalling
extends BlockCarvable {
    private static boolean fallInstantly;

    public BlockCarvableFalling(Material material, int index, int max, VariationData ... variations) {
        super(material, index, max, variations);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)).func_185904_a() == Material.field_151586_h) {
            worldIn.func_180501_a(pos, ChiselBlocks.concrete.func_176203_a(ChiselBlocks.concrete_powder.func_176201_c(state)), 3);
        } else if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)).func_185904_a() == Material.field_151586_h) {
            worldIn.func_180501_a(pos, ChiselBlocks.concrete.func_176203_a(ChiselBlocks.concrete_powder.func_176201_c(state)), 3);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockCarvableFalling.canFallThrough(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            boolean i = true;
            if (!fallInstantly && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlockCarvable state1 = new EntityFallingBlockCarvable(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.onStartFalling(state1);
                    worldIn.func_72838_d((Entity)state1);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockCarvableFalling.canFallThrough(worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    protected void onStartFalling(EntityFallingBlockCarvable fallingEntity) {
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a;
    }

    public void onEndFalling(World worldIn, BlockPos pos) {
    }

    public void onBroken(World worldIn, BlockPos p_190974_2_) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (rand.nextInt(16) == 0 && BlockCarvableFalling.canFallThrough(worldIn.func_180495_p(blockpos = pos.func_177977_b()))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getDustColor(IBlockState p_189876_1_) {
        return -16777216;
    }
}

