/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.lang;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.client.lang.RemoteLanguageContainer;
import net.ilexiconn.llibrary.server.core.plugin.LLibraryPlugin;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum LanguageHandler {
    INSTANCE;

    private Map<String, Map<String, String>> localizations = new HashMap<String, Map<String, String>>();

    public RemoteLanguageContainer loadRemoteLocalization(String modId) throws Exception {
        try (InputStream in = LanguageHandler.class.getResourceAsStream("/assets/" + modId.toLowerCase() + "/lang.json");){
            if (in != null) {
                RemoteLanguageContainer remoteLanguageContainer = (RemoteLanguageContainer)new Gson().fromJson((Reader)new InputStreamReader(in), RemoteLanguageContainer.class);
                return remoteLanguageContainer;
            }
        }
        return null;
    }

    public void load() {
        File cacheDir = new File("llibrary/lang");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        for (File child : cacheDir.listFiles()) {
            if (!child.isFile()) continue;
            try (FileInputStream cachedStream = new FileInputStream(child);){
                Map lang = LanguageMap.parseLangFile((InputStream)cachedStream);
                this.localizations.put(child.getName().substring(0, child.getName().length() - ".lang".length()), lang);
            }
            catch (Exception e) {
                LLibraryPlugin.LOGGER.error("An exception occurred while loading {} from cache.", (Object)child.getName(), (Object)e);
            }
        }
        for (ModContainer modContainer : Loader.instance().getModList()) {
            String modId = modContainer.getModId();
            try {
                RemoteLanguageContainer container = this.loadRemoteLocalization(modId);
                if (container == null) continue;
                for (RemoteLanguageContainer.LangContainer language : container.languages) {
                    Map lang = LanguageMap.parseLangFile((InputStream)new URL(language.downloadURL).openStream());
                    String locale = language.locale;
                    if (this.localizations.containsKey(locale)) {
                        lang.putAll(this.localizations.get(locale));
                    }
                    this.localizations.put(locale, lang);
                }
            }
            catch (Exception e) {
                LLibraryPlugin.LOGGER.error("An exception occurred while loading remote lang container for {}", (Object)modId, (Object)e);
            }
        }
        for (Map.Entry entry : this.localizations.entrySet()) {
            String language = (String)entry.getKey();
            File cache = new File(cacheDir, language + ".lang");
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache), Charsets.UTF_8));
                Throwable throwable = null;
                try {
                    for (Map.Entry langEntry : ((Map)entry.getValue()).entrySet()) {
                        writer.append((CharSequence)langEntry.getKey()).append("=").append((CharSequence)langEntry.getValue()).append("\n");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Exception e) {
                LLibraryPlugin.LOGGER.error("An exception occurred while saving cache for {}", (Object)language);
            }
        }
    }

    public void addRemoteLocalizations(String language, Map<String, String> properties) {
        Map<String, String> localizationsForLang = this.localizations.get(language);
        if (localizationsForLang != null) {
            properties.putAll(localizationsForLang);
        }
    }
}

