/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ModItems;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.ItemCamera;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="camera", value={Side.CLIENT})
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    public static final float MAX_FOV = 90.0f;
    public static final float MIN_FOV = 5.0f;
    private Minecraft mc = Minecraft.func_71410_x();
    private ResourceLocation currentShader;
    private boolean inCameraMode;
    private float fov;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        this.mc.field_71474_y.field_74320_O = 0;
        this.setShader(this.getShader((EntityPlayer)this.mc.field_71439_g));
        this.drawViewFinder();
        this.drawZoom(this.getFOVPercentage());
    }

    private void drawViewFinder() {
        float hnew;
        float wnew;
        GlStateManager.func_179094_E();
        this.mc.func_110434_K().func_110577_a(VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        float ws = scaledresolution.func_78326_a();
        float hs = scaledresolution.func_78328_b();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + hnew), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)(top + hnew), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void drawZoom(float percent) {
        GlStateManager.func_179094_E();
        this.mc.func_110434_K().func_110577_a(ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        int percWidth = (int)(Math.max(Math.min(percent, 1.0f), 0.0f) * (float)zoomWidth);
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0 * (double)percent, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)top, 0.0).func_187315_a(1.0 * (double)percent, 0.5).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.inCameraMode && event.getGui() instanceof GuiIngameMenu) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(EntityPlayer player) {
        ItemStack stack = this.mc.field_71439_g.func_184614_ca();
        if (!stack.func_77973_b().equals((Object)ModItems.CAMERA)) {
            return null;
        }
        return Shaders.getShader(ModItems.CAMERA.getShader(stack));
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            this.mc.field_71460_t.func_181022_b();
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.field_71460_t.func_175069_a(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof ItemCamera) || !ModItems.CAMERA.isActive(stack)) continue;
            player.func_184598_c(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getEntityPlayer().func_184602_cy();
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (event.getDwheel() == 0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getDwheel() < 0 ? Math.min(this.fov + 5.0f, 90.0f) : Math.max(this.fov - 5.0f, 5.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (event.getEntity() != this.mc.field_71439_g) {
            return;
        }
        if (!this.inCameraMode) {
            this.fov = event.getFOV();
            return;
        }
        this.mc.field_71439_g.func_70080_a(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u + 1.0E-9, this.mc.field_71439_g.field_70161_v, this.mc.field_71439_g.field_70177_z, this.mc.field_71439_g.field_70125_A);
        event.setFOV(this.fov);
    }

    public float getFOVPercentage() {
        return 1.0f - (this.fov - 5.0f) / 85.0f;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.field_71439_g == null) {
            return null;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)ModItems.CAMERA) || !ModItems.CAMERA.isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

