/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.ItemTools;
import de.maxhenkel.camera.ModItems;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.proxy.CommonProxy;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemCamera
extends Item {
    public ItemCamera() {
        this.setRegistryName(new ResourceLocation("camera", "camera"));
        this.func_77655_b("camera");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78031_c);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && !this.isActive(stack)) {
            playerIn.openGui((Object)"camera", 0, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (worldIn.field_72995_K || !(playerIn instanceof EntityPlayerMP)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!this.isActive(stack)) {
            ModItems.CAMERA.setActive(stack, true);
        } else if (CommonProxy.packetManager.canTakeImage(playerIn.func_110124_au())) {
            if (this.consumePaper(playerIn)) {
                worldIn.func_184133_a(null, playerIn.func_180425_c(), ModSounds.TAKE_IMAGE, SoundCategory.AMBIENT, 1.0f, 1.0f);
                UUID uuid = UUID.randomUUID();
                CommonProxy.simpleNetworkWrapper.sendTo((IMessage)new MessageTakeImage(uuid), (EntityPlayerMP)playerIn);
                ModItems.CAMERA.setActive(stack, false);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.no_paper", new Object[0]), true);
            }
        } else {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.image_cooldown", new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        if (!this.isActive(stack)) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            this.func_77659_a(entity.field_70170_p, (EntityPlayer)entity, EnumHand.MAIN_HAND);
        }
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 50000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    private boolean consumePaper(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack paper = this.findPaper(player);
        if (paper == null) {
            return false;
        }
        ItemTools.decrItemStack(paper, null);
        return true;
    }

    private ItemStack findPaper(EntityPlayer player) {
        if (this.isPaper(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isPaper(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isPaper(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isPaper(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151121_aF);
    }

    public boolean isActive(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            stack.func_77982_d(new NBTTagCompound());
            compound = stack.func_77978_p();
        }
        if (!compound.func_74764_b("active")) {
            compound.func_74757_a("active", false);
        }
        return compound.func_74767_n("active");
    }

    public void setActive(ItemStack stack, boolean active) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            stack.func_77982_d(new NBTTagCompound());
            compound = stack.func_77978_p();
        }
        compound.func_74757_a("active", active);
    }

    public String getShader(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            stack.func_77982_d(new NBTTagCompound());
            compound = stack.func_77978_p();
        }
        if (!compound.func_74764_b("shader")) {
            return null;
        }
        return compound.func_74779_i("shader");
    }

    public void setShader(ItemStack stack, String shader) {
        if (shader != null) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                stack.func_77982_d(new NBTTagCompound());
                compound = stack.func_77978_p();
            }
            compound.func_74778_a("shader", shader);
        }
    }
}

