/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.proxy.CommonProxy;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemImage
extends Item {
    public ItemImage() {
        this.setRegistryName(new ResourceLocation("camera", "image"));
        this.func_77655_b("image");
        this.func_77656_e(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.openGui((Object)"camera", 1, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        long time;
        String name = ItemImage.getOwner(stack);
        if (!name.isEmpty()) {
            tooltip.add(new TextComponentTranslation("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + name}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
        }
        if ((time = ItemImage.getTime(stack)) > 0L) {
            tooltip.add(new TextComponentTranslation("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + CommonProxy.imageDateFormat.format(new Date(time))}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private static NBTTagCompound getImageTag(ItemStack stack) {
        NBTTagCompound compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("image")) {
            compound.func_74782_a("image", (NBTBase)new NBTTagCompound());
        }
        return compound.func_74775_l("image");
    }

    public static void setUUID(ItemStack stack, UUID uuid) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74772_a("image_id_most", uuid.getMostSignificantBits());
        compound.func_74772_a("image_id_least", uuid.getLeastSignificantBits());
    }

    public static UUID getUUID(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("image_id_most") || !compound.func_74764_b("image_id_least")) {
            return null;
        }
        long most = compound.func_74763_f("image_id_most");
        long least = compound.func_74763_f("image_id_least");
        return new UUID(most, least);
    }

    public static void setTime(ItemStack stack, long time) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74772_a("image_time", time);
    }

    public static long getTime(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("image_time")) {
            return 0L;
        }
        return compound.func_74763_f("image_time");
    }

    public static void setOwner(ItemStack stack, String name) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74778_a("owner", name);
    }

    public static String getOwner(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("owner")) {
            return "";
        }
        return compound.func_74779_i("owner");
    }
}

