/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.item.BaubleBackpackItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Baubles {
    private Map<UUID, ItemStack> backpackMap = new HashMap<UUID, ItemStack>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDeathHigh(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        this.backpackMap.remove(player.func_110124_au());
        ItemStack stack = Backpacked.getBackpackStack(player);
        if (stack.func_77973_b() instanceof BaubleBackpackItem) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            int index = BaubleType.BODY.getValidSlots()[0];
            handler.setStackInSlot(index, ItemStack.field_190927_a);
            this.backpackMap.put(player.func_110124_au(), stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeathLow(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (this.backpackMap.containsKey(player.func_110124_au())) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            int index = BaubleType.BODY.getValidSlots()[0];
            handler.setStackInSlot(index, this.backpackMap.get(player.func_110124_au()));
            this.backpackMap.remove(player.func_110124_au());
        }
    }

    public static ItemStack getBackpackStack(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack stack = handler.getStackInSlot(BaubleType.BODY.getValidSlots()[0]);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BaubleBackpackItem) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void setBackpackStack(EntityPlayer player, ItemStack stack) {
        int index;
        IBaublesItemHandler handler;
        ItemStack remainder;
        if (stack.func_77973_b() instanceof BaubleBackpackItem && (remainder = (handler = BaublesApi.getBaublesHandler((EntityPlayer)player)).insertItem(index = BaubleType.BODY.getValidSlots()[0], stack.func_77946_l(), true)).func_190916_E() < stack.func_190916_E()) {
            handler.insertItem(index, stack.func_77946_l(), false);
        }
    }

    public static Item getBaubleBackpackItem() {
        return new BaubleBackpackItem();
    }
}

