/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.Artifacts;
import artifacts.common.ModConfig;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
public class BaubleBase
extends Item
implements IBauble {
    public final BaubleType type;
    public final String name;
    protected SoundEvent equipSound = SoundEvents.field_187716_o;
    protected SoundEvent unequipSound = SoundEvents.field_187716_o;
    protected float equipPitch = 1.0f;

    public BaubleBase(String name, BaubleType type) {
        this.setRegistryName(name);
        this.func_77655_b("artifacts." + name);
        this.func_77637_a(Artifacts.CREATIVE_TAB);
        this.func_77625_d(1);
        this.type = type;
        this.name = name;
    }

    public BaubleBase setEquipSound(SoundEvent equipSound, SoundEvent unequipSound, float equipPitch) {
        this.equipSound = equipSound;
        this.unequipSound = unequipSound;
        this.equipPitch = equipPitch;
        return this;
    }

    public BaubleBase setEquipSound(SoundEvent equipSound, float pitch) {
        return this.setEquipSound(equipSound, equipSound, pitch);
    }

    public BaubleBase setEquipSound(SoundEvent equipSound, SoundEvent unequipSound) {
        return this.setEquipSound(equipSound, unequipSound, 1.0f);
    }

    public BaubleBase setEquipSound(SoundEvent equipSound) {
        return this.setEquipSound(equipSound, equipSound, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (GuiScreen.func_146272_n() || ModConfig.client.alwaysShowTooltip) {
            tooltip.add(I18n.func_74838_a((String)("tooltip.artifacts." + this.name + ".name")));
        } else {
            tooltip.add(I18n.func_74838_a((String)"tooltip.artifacts.shiftinfo.name"));
        }
    }

    public void registerModel() {
        Artifacts.proxy.registerItemRenderer(this, 0, this.name);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return this.type;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            if (!baubles.getStackInSlot(i).func_190926_b() || !baubles.isItemValidForSlot(i, player.func_184586_b(hand), (EntityLivingBase)player)) continue;
            baubles.setStackInSlot(i, player.func_184586_b(hand).func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_190920_e(0);
            }
            this.onEquipped(player.func_184586_b(hand), (EntityLivingBase)player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(this.equipSound, 0.75f, 0.95f * this.equipPitch);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(this.unequipSound, 0.75f, this.equipPitch);
    }
}

