/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemIEShield
extends ItemUpgradeableTool
implements EnergyHelper.IIEEnergyItem,
IOBJModelCallback<ItemStack> {
    public ItemIEShield() {
        super("shield", 1, "SHIELD", new String[0]);
        this.func_77656_e(1024);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                final CapabilityShader.ShaderWrapper_Item shaders;
                {
                    super(stack2);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                    this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:shield", stack);
                }

                @Override
                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
                }

                @Override
                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return (T)this.shaders;
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.func_77989_b((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (this.getMaxEnergyStored(stack) > 0) {
            String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        boolean blocking;
        super.func_77663_a(stack, world, ent, slot, inHand);
        if (world.field_72995_K) {
            return;
        }
        if (ent instanceof EntityLivingBase) {
            inHand |= ((EntityLivingBase)ent).func_184586_b(EnumHand.OFF_HAND) == stack;
        }
        boolean bl = blocking = ent instanceof EntityLivingBase && ((EntityLivingBase)ent).func_184585_cz();
        if (!inHand || !blocking) {
            int cooldown;
            if (this.getUpgrades(stack).func_74764_b("flash_cooldown") && this.extractEnergy(stack, 20, true) == 20) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).func_74762_e("flash_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).func_82580_o("flash_cooldown");
                } else {
                    this.getUpgrades(stack).func_74768_a("flash_cooldown", cooldown);
                }
            }
            if (this.getUpgrades(stack).func_74764_b("shock_cooldown") && this.extractEnergy(stack, 20, true) == 20) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).func_74762_e("shock_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).func_82580_o("shock_cooldown");
                } else {
                    this.getUpgrades(stack).func_74768_a("shock_cooldown", cooldown);
                }
            }
        }
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    public void hitShield(ItemStack stack, EntityPlayer player, DamageSource source, float amount, LivingAttackEvent event) {
        if (this.getUpgrades(stack).func_74767_n("flash") && this.getUpgrades(stack).func_74762_e("flash_cooldown") <= 0) {
            Vec3d look = player.func_70040_Z();
            List<EntityLivingBase> targets = Utils.getTargetsInCone(player.func_130014_f_(), player.func_174791_d().func_178788_d(look), player.func_70040_Z().func_186678_a(9.0), 1.57079f, 0.5f);
            for (EntityLivingBase t : targets) {
                if (player.equals((Object)t)) continue;
                t.func_70690_d(new PotionEffect(IEPotions.flashed, 100, 1));
                if (!(t instanceof EntityLiving)) continue;
                ((EntityLiving)t).func_70624_b(null);
            }
            this.getUpgrades(stack).func_74768_a("flash_cooldown", 40);
        }
        if (this.getUpgrades(stack).func_74767_n("shock") && this.getUpgrades(stack).func_74762_e("shock_cooldown") <= 0) {
            boolean b = false;
            if (event.getSource().func_76352_a() && event.getSource().func_76364_f() != null) {
                Entity projectile = event.getSource().func_76364_f();
                projectile.func_70106_y();
                event.setCanceled(true);
                b = true;
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && event.getSource().func_76346_g().func_70068_e((Entity)player) < 4.0) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(1.0f, true);
                dmgsrc.apply(event.getSource().func_76346_g());
                b = true;
            }
            if (b) {
                this.getUpgrades(stack).func_74768_a("shock_cooldown", 40);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, IESounds.spark, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat());
            }
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName(material, "ingotSteel");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getUpgrades(container).func_74767_n("flash") || this.getUpgrades(container).func_74767_n("shock") ? 1600 : 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public boolean shouldRenderGroup(ItemStack object, String group) {
        if ("flash".equals(group)) {
            return this.getUpgrades(object).func_74767_n("flash");
        }
        if ("shock".equals(group)) {
            return this.getUpgrades(object).func_74767_n("shock");
        }
        return true;
    }

    @Override
    public Matrix4 handlePerspective(ItemStack Object2, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective, EntityLivingBase entity) {
        if (entity != null && entity.func_184587_cr()) {
            if (entity.func_184600_cs() == EnumHand.MAIN_HAND == (entity.func_184591_cq() == EnumHandSide.RIGHT)) {
                if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    perspective.rotate(-0.15, 1.0, 0.0, 0.0).translate(-0.25, 0.5, -0.4375);
                } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                    perspective.rotate(0.52359, 1.0, 0.0, 0.0).rotate(0.78539, 0.0, 1.0, 0.0).translate(0.40625, -0.125, -0.125);
                }
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                perspective.rotate(0.15, 1.0, 0.0, 0.0).translate(0.25, 0.375, 0.4375);
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                perspective.rotate(-0.52359, 1.0, 0.0, 0.0).rotate(0.78539, 0.0, 1.0, 0.0).translate(0.1875, 0.3125, 0.5625);
            }
        }
        return perspective;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "SHIELD", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "SHIELD", stack, true)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

