/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.commons.lang3.tuple.Pair;

public class IEIMCHandler {
    private static final HashMap<String, Pair<Predicate<FMLInterModComms.IMCMessage>, Consumer<FMLInterModComms.IMCMessage>>> MESSAGE_HANDLERS = new HashMap();

    public static void init() {
        MESSAGE_HANDLERS.put("fluidpipe_cover", (Pair<Predicate<FMLInterModComms.IMCMessage>, Consumer<FMLInterModComms.IMCMessage>>)Pair.of(FMLInterModComms.IMCMessage::isFunctionMessage, imcMessage -> {
            Optional opFunc = imcMessage.getFunctionValue(ItemStack.class, Boolean.class);
            opFunc.ifPresent(itemStackBooleanFunction -> TileEntityFluidPipe.validPipeCovers.add((Function<ItemStack, Boolean>)itemStackBooleanFunction));
        }));
        MESSAGE_HANDLERS.put("fluidpipe_cover_climb", (Pair<Predicate<FMLInterModComms.IMCMessage>, Consumer<FMLInterModComms.IMCMessage>>)Pair.of(FMLInterModComms.IMCMessage::isFunctionMessage, imcMessage -> {
            Optional opFunc = imcMessage.getFunctionValue(ItemStack.class, Boolean.class);
            opFunc.ifPresent(itemStackBooleanFunction -> TileEntityFluidPipe.climbablePipeCovers.add((Function<ItemStack, Boolean>)itemStackBooleanFunction));
        }));
        MESSAGE_HANDLERS.put("shaderbag_exclude", (Pair<Predicate<FMLInterModComms.IMCMessage>, Consumer<FMLInterModComms.IMCMessage>>)Pair.of(FMLInterModComms.IMCMessage::isStringMessage, imcMessage -> {
            String s = imcMessage.getStringValue();
            try {
                Class<?> clazz = Class.forName(s);
                if (EntityLiving.class.isAssignableFrom(clazz)) {
                    EventHandler.listOfBoringBosses.add(clazz);
                } else {
                    IELogger.error("IMC Handling: " + s + " is not an instance of EntityLiving.");
                }
            }
            catch (ClassNotFoundException e) {
                IELogger.error("IMC Handling: " + s + " is not a valid classname.");
            }
        }));
    }

    public static void handleIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            Pair<Predicate<FMLInterModComms.IMCMessage>, Consumer<FMLInterModComms.IMCMessage>> handler;
            if (!MESSAGE_HANDLERS.containsKey(message.key) || !((Predicate)(handler = MESSAGE_HANDLERS.get(message.key)).getLeft()).test(message)) continue;
            ((Consumer)handler.getRight()).accept(message);
        }
    }
}

