/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.utils.ClassUtils;
import de.matthiasmann.twl.utils.SimpleMathParser;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMathInterpreter
implements SimpleMathParser.Interpreter {
    private final ArrayList<Object> stack = new ArrayList();
    private final HashMap<String, Function> functions = new HashMap();

    public AbstractMathInterpreter() {
        this.registerFunction("min", new FunctionMin());
        this.registerFunction("max", new FunctionMax());
    }

    public final void registerFunction(String name, Function function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        this.functions.put(name, function);
    }

    public Number execute(String str) throws ParseException {
        this.stack.clear();
        SimpleMathParser.interpret(str, this);
        if (this.stack.size() != 1) {
            throw new IllegalStateException("Expected one return value on the stack");
        }
        return this.popNumber();
    }

    public int[] executeIntArray(String str) throws ParseException {
        this.stack.clear();
        int count = SimpleMathParser.interpretArray(str, this);
        if (this.stack.size() != count) {
            throw new IllegalStateException("Expected " + count + " return values on the stack");
        }
        int[] result = new int[count];
        int i = count;
        while (i-- > 0) {
            result[i] = this.popNumber().intValue();
        }
        return result;
    }

    public <T> T executeCreateObject(String str, Class<T> type) throws ParseException {
        this.stack.clear();
        int count = SimpleMathParser.interpretArray(str, this);
        if (this.stack.size() != count) {
            throw new IllegalStateException("Expected " + count + " return values on the stack");
        }
        if (count == 1 && type.isInstance(this.stack.get(0))) {
            return type.cast(this.stack.get(0));
        }
        for (Constructor<?> c : type.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            if (params.length != count) continue;
            boolean match = true;
            for (int i = 0; i < count; ++i) {
                if (ClassUtils.isParamCompatible(params[i], this.stack.get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            try {
                return type.cast(c.newInstance(this.stack.toArray(new Object[count])));
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractMathInterpreter.class.getName()).log(Level.SEVERE, "can't instantiate object", ex);
            }
        }
        throw new IllegalArgumentException("Can't construct a " + type + " from expression: \"" + str + "\"");
    }

    protected void push(Object obj) {
        this.stack.add(obj);
    }

    protected Object pop() {
        int size = this.stack.size();
        if (size == 0) {
            throw new IllegalStateException("stack underflow");
        }
        return this.stack.remove(size - 1);
    }

    protected Number popNumber() {
        Object obj = this.pop();
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalStateException("expected number on stack - found: " + (obj != null ? obj.getClass() : "null"));
    }

    @Override
    public void loadConst(Number n) {
        this.push(n);
    }

    @Override
    public void add() {
        boolean isFloat;
        Number b = this.popNumber();
        Number a = this.popNumber();
        boolean bl = isFloat = AbstractMathInterpreter.isFloat(a) || AbstractMathInterpreter.isFloat(b);
        if (isFloat) {
            this.push(Float.valueOf(a.floatValue() + b.floatValue()));
        } else {
            this.push(a.intValue() + b.intValue());
        }
    }

    @Override
    public void sub() {
        boolean isFloat;
        Number b = this.popNumber();
        Number a = this.popNumber();
        boolean bl = isFloat = AbstractMathInterpreter.isFloat(a) || AbstractMathInterpreter.isFloat(b);
        if (isFloat) {
            this.push(Float.valueOf(a.floatValue() - b.floatValue()));
        } else {
            this.push(a.intValue() - b.intValue());
        }
    }

    @Override
    public void mul() {
        boolean isFloat;
        Number b = this.popNumber();
        Number a = this.popNumber();
        boolean bl = isFloat = AbstractMathInterpreter.isFloat(a) || AbstractMathInterpreter.isFloat(b);
        if (isFloat) {
            this.push(Float.valueOf(a.floatValue() * b.floatValue()));
        } else {
            this.push(a.intValue() * b.intValue());
        }
    }

    @Override
    public void div() {
        boolean isFloat;
        Number b = this.popNumber();
        Number a = this.popNumber();
        boolean bl = isFloat = AbstractMathInterpreter.isFloat(a) || AbstractMathInterpreter.isFloat(b);
        if (isFloat) {
            if (Math.abs(b.floatValue()) == 0.0f) {
                throw new IllegalStateException("division by zero");
            }
            this.push(Float.valueOf(a.floatValue() / b.floatValue()));
        } else {
            if (b.intValue() == 0) {
                throw new IllegalStateException("division by zero");
            }
            this.push(a.intValue() / b.intValue());
        }
    }

    @Override
    public void negate() {
        Number a = this.popNumber();
        if (AbstractMathInterpreter.isFloat(a)) {
            this.push(Float.valueOf(-a.floatValue()));
        } else {
            this.push(-a.intValue());
        }
    }

    @Override
    public void accessArray() {
        Number idx = this.popNumber();
        Object obj = this.pop();
        if (obj == null) {
            throw new IllegalStateException("null pointer");
        }
        if (!obj.getClass().isArray()) {
            throw new IllegalStateException("array expected");
        }
        try {
            this.push(Array.get(obj, idx.intValue()));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalStateException("array index out of bounds", ex);
        }
    }

    @Override
    public void accessField(String field) {
        Object obj = this.pop();
        if (obj == null) {
            throw new IllegalStateException("null pointer");
        }
        Object result = this.accessField(obj, field);
        this.push(result);
    }

    protected Object accessField(Object obj, String field) {
        Class<?> clazz = obj.getClass();
        try {
            if (clazz.isArray()) {
                if ("length".equals(field)) {
                    return Array.getLength(obj);
                }
            } else {
                Method m = AbstractMathInterpreter.findGetter(clazz, field);
                if (m == null) {
                    Class<?> i;
                    Class<?>[] arr$ = clazz.getInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (m = AbstractMathInterpreter.findGetter(i = arr$[i$], field)) == null; ++i$) {
                    }
                }
                if (m != null) {
                    return m.invoke(obj, new Object[0]);
                }
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("error accessing field '" + field + "' of class '" + clazz + "'", ex);
        }
        throw new IllegalStateException("unknown field '" + field + "' of class '" + clazz + "'");
    }

    private static Method findGetter(Class<?> clazz, String field) {
        for (Method m : clazz.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getReturnType() == Void.TYPE || !Modifier.isPublic(m.getDeclaringClass().getModifiers()) || m.getParameterTypes().length != 0 || !AbstractMathInterpreter.cmpName(m, field, "get") && !AbstractMathInterpreter.cmpName(m, field, "is")) continue;
            return m;
        }
        return null;
    }

    private static boolean cmpName(Method m, String fieldName, String prefix) {
        String methodName = m.getName();
        int prefixLength = prefix.length();
        int fieldNameLength = fieldName.length();
        return methodName.length() == prefixLength + fieldNameLength && methodName.startsWith(prefix) && methodName.charAt(prefixLength) == Character.toUpperCase(fieldName.charAt(0)) && methodName.regionMatches(prefixLength + 1, fieldName, 1, fieldNameLength - 1);
    }

    @Override
    public void callFunction(String name, int args) {
        Object[] values = new Object[args];
        int i = args;
        while (i-- > 0) {
            values[i] = this.pop();
        }
        Function function = this.functions.get(name);
        if (function == null) {
            throw new IllegalArgumentException("Unknown function");
        }
        this.push(function.execute(values));
    }

    protected static boolean isFloat(Number n) {
        return !(n instanceof Integer);
    }

    static class FunctionMax
    extends NumberFunction {
        FunctionMax() {
        }

        @Override
        protected Object execute(int ... values) {
            int result = values[0];
            for (int i = 1; i < values.length; ++i) {
                result = Math.max(result, values[i]);
            }
            return result;
        }

        @Override
        protected Object execute(float ... values) {
            float result = values[0];
            for (int i = 1; i < values.length; ++i) {
                result = Math.max(result, values[i]);
            }
            return Float.valueOf(result);
        }
    }

    static class FunctionMin
    extends NumberFunction {
        FunctionMin() {
        }

        @Override
        protected Object execute(int ... values) {
            int result = values[0];
            for (int i = 1; i < values.length; ++i) {
                result = Math.min(result, values[i]);
            }
            return result;
        }

        @Override
        protected Object execute(float ... values) {
            float result = values[0];
            for (int i = 1; i < values.length; ++i) {
                result = Math.min(result, values[i]);
            }
            return Float.valueOf(result);
        }
    }

    public static abstract class NumberFunction
    implements Function {
        protected abstract Object execute(int ... var1);

        protected abstract Object execute(float ... var1);

        @Override
        public Object execute(Object ... args) {
            for (Object o : args) {
                if (o instanceof Integer) continue;
                float[] values = new float[args.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = ((Number)args[i]).floatValue();
                }
                return this.execute(values);
            }
            int[] values = new int[args.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Number)args[i]).intValue();
            }
            return this.execute(values);
        }
    }

    public static interface Function {
        public Object execute(Object ... var1);
    }
}

