/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.gui;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.client.gui.DisplayProperty;
import com.mrcrayfish.guns.client.gui.GuiCheckBox;
import com.mrcrayfish.guns.common.WorkbenchRegistry;
import com.mrcrayfish.guns.common.container.ContainerWorkbench;
import com.mrcrayfish.guns.item.ItemColored;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageCraft;
import com.mrcrayfish.guns.tileentity.TileEntityWorkbench;
import com.mrcrayfish.guns.util.InventoryUtil;
import com.mrcrayfish.guns.util.ItemStackHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.DyeUtils;

public class GuiWorkbench
extends GuiContainer {
    private static final int MAX_TRANSITION_TICKS = 5;
    private static final ResourceLocation GUI = new ResourceLocation("cgm:textures/gui/workbench.png");
    private static final Map<ItemStack, DisplayProperty> DISPLAY_PROPERTIES = new HashMap<ItemStack, DisplayProperty>();
    private List<MaterialItem> materials;
    private static int currentIndex = 0;
    private static int previousIndex = 0;
    private static boolean showRemaining = false;
    private NonNullList<ItemStack> cachedItems;
    private IInventory playerInventory;
    private TileEntityWorkbench workbench;
    private GuiButton btnCraft;
    private GuiCheckBox checkBoxMaterials;
    private boolean transitioning;
    private int transitionProgress = 5;
    private int prevTransitionProgress = 5;
    private DisplayProperty displayProperty;
    private DisplayProperty prevDisplayProperty;

    public static void addDisplayProperty(ItemStack stack, DisplayProperty property) {
        for (ItemStack key : DISPLAY_PROPERTIES.keySet()) {
            if (!ItemStackHelper.areItemStackEqualIgnoreTag(key, stack)) continue;
            return;
        }
        DISPLAY_PROPERTIES.put(stack, property);
    }

    @Nullable
    private static DisplayProperty getDisplayProperty(ItemStack find) {
        for (ItemStack stack : DISPLAY_PROPERTIES.keySet()) {
            if (!ItemStackHelper.areItemStackSameItem(stack, find)) continue;
            return DISPLAY_PROPERTIES.get(stack);
        }
        return null;
    }

    public GuiWorkbench(IInventory playerInventory, TileEntityWorkbench workbench) {
        super((Container)new ContainerWorkbench(playerInventory, workbench));
        this.playerInventory = playerInventory;
        this.workbench = workbench;
        this.field_146999_f = 289;
        this.field_147000_g = 202;
        this.materials = new ArrayList<MaterialItem>();
        this.cachedItems = NonNullList.func_191197_a((int)WorkbenchRegistry.getRecipeMap().size(), (Object)ItemStack.field_190927_a);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(1, startX, startY, 15, 20, "<"));
        this.field_146292_n.add(new GuiButton(2, startX + 161, startY, 15, 20, ">"));
        this.btnCraft = new GuiButton(3, startX + 186, startY + 6, 97, 20, "Assemble");
        this.field_146292_n.add(this.btnCraft);
        this.btnCraft.field_146124_l = false;
        this.checkBoxMaterials = new GuiCheckBox(186, 90, "Show Remaining");
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadItem(currentIndex);
    }

    public void func_73876_c() {
        Item item;
        super.func_73876_c();
        for (MaterialItem materialItem : this.materials) {
            materialItem.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        this.btnCraft.field_146124_l = canCraft;
        ItemStack itemStack = (ItemStack)this.cachedItems.get(currentIndex);
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof ItemColored) {
            ItemColored colored = (ItemColored)item;
            if (!this.workbench.func_70301_a(0).func_190926_b()) {
                ItemStack dyeStack = this.workbench.func_70301_a(0);
                if (dyeStack.func_77973_b() == Items.field_151100_aR) {
                    Optional optional = DyeUtils.colorFromStack((ItemStack)dyeStack);
                    if (optional.isPresent()) {
                        float[] color = ((EnumDyeColor)optional.get()).func_193349_f();
                        int red = (int)(color[0] * 255.0f);
                        int green = (int)(color[1] * 255.0f);
                        int blue = (int)(color[2] * 255.0f);
                        colored.setColor(itemStack, (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
                    }
                } else {
                    colored.removeColor(itemStack);
                }
            } else {
                colored.removeColor(itemStack);
            }
        }
        this.prevTransitionProgress = this.transitionProgress;
        if (this.transitioning) {
            if (this.transitionProgress > 0) {
                this.transitionProgress = Math.max(0, this.transitionProgress - 1);
            } else {
                this.transitioning = false;
            }
        } else if (this.transitionProgress < 5) {
            this.transitionProgress = Math.min(5, this.transitionProgress + 1);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.checkBoxMaterials.handleClick(startX, startY, mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        ResourceLocation registryName;
        ItemStack currentWeapon;
        if (button.field_146127_k == 1) {
            if (currentIndex - 1 < 0) {
                this.loadItem(this.cachedItems.size() - 1);
            } else {
                this.loadItem(currentIndex - 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (button.field_146127_k == 2) {
            if (currentIndex + 1 >= this.cachedItems.size()) {
                this.loadItem(0);
            } else {
                this.loadItem(currentIndex + 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (button.field_146127_k == 3 && !(currentWeapon = (ItemStack)this.cachedItems.get(currentIndex)).func_190926_b() && (registryName = currentWeapon.func_77973_b().getRegistryName()) != null) {
            MessageCraft message = new MessageCraft(currentWeapon, this.workbench.func_174877_v());
            PacketHandler.INSTANCE.sendToServer((IMessage)message);
        }
    }

    private void loadItem(int index) {
        previousIndex = currentIndex;
        this.prevDisplayProperty = this.displayProperty;
        ItemStack stack = (ItemStack)WorkbenchRegistry.getRecipeMap().keySet().asList().get(index);
        if (((ItemStack)this.cachedItems.get(index)).func_190926_b()) {
            this.cachedItems.set(index, (Object)stack.func_77946_l());
        }
        if (stack != null) {
            this.materials.clear();
            this.displayProperty = GuiWorkbench.getDisplayProperty(stack);
            List<ItemStack> materials = WorkbenchRegistry.getMaterialsForStack(stack);
            if (materials != null) {
                for (ItemStack material : materials) {
                    MaterialItem item = new MaterialItem(material);
                    item.update();
                    this.materials.add(item);
                }
                currentIndex = index;
                if (GunConfig.CLIENT.display.workbenchAnimation && previousIndex != currentIndex) {
                    this.transitioning = true;
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        DisplayProperty property;
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.func_146276_q_();
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(startX, startY + 80, 0, 134, 176, 122);
        this.func_73729_b(startX + 180, startY, 176, 54, 6, 208);
        this.func_73729_b(startX + 186, startY, 182, 54, 57, 208);
        this.func_73729_b(startX + 186 + 57, startY, 220, 54, 23, 208);
        this.func_73729_b(startX + 186 + 57 + 23, startY, 220, 54, 3, 208);
        this.func_73729_b(startX + 186 + 57 + 23 + 3, startY, 236, 54, 20, 208);
        if (this.workbench.func_70301_a(0).func_190926_b()) {
            this.func_73729_b(startX + 187, startY + 30, 80, 0, 16, 16);
        }
        this.checkBoxMaterials.draw(this.field_146297_k, this.field_147003_i, this.field_147009_r);
        ItemStack currentItem = (ItemStack)this.cachedItems.get(currentIndex);
        StringBuilder builder = new StringBuilder(currentItem.func_82833_r());
        if (currentItem.func_190916_E() > 1) {
            builder.append(" x ");
            builder.append(currentItem.func_190916_E());
        }
        this.func_73732_a(this.field_146289_q, builder.toString(), startX + 88, startY + 6, Color.WHITE.getRGB());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(startX + 88), (float)(startY + 90), (float)100.0f);
        float transitionPercent = ((float)this.prevTransitionProgress + (float)(this.transitionProgress - this.prevTransitionProgress) * partialTicks) / 5.0f;
        float scale = 40.0f * transitionPercent;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        GlStateManager.func_179114_b((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        DisplayProperty displayProperty = property = this.transitioning ? this.prevDisplayProperty : this.displayProperty;
        if (property != null) {
            GlStateManager.func_179139_a((double)property.getScale(), (double)property.getScale(), (double)property.getScale());
            GlStateManager.func_179114_b((float)((float)property.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)property.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)property.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)property.getX(), (double)property.getY(), (double)property.getZ());
        }
        int vehicleIndex = this.transitioning ? previousIndex : currentIndex;
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175599_af().func_181564_a((ItemStack)this.cachedItems.get(vehicleIndex), ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
        List<MaterialItem> materials = this.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(GUI);
            MaterialItem materialItem = materials.get(i);
            ItemStack stack = materialItem.stack;
            if (stack.func_190926_b()) {
                RenderHelper.func_74518_a();
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 95, 0, 19, 80, 19);
                continue;
            }
            RenderHelper.func_74518_a();
            if (materialItem.isEnabled()) {
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 95, 0, 0, 80, 19);
            } else {
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 95, 0, 38, 80, 19);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = stack.func_82833_r();
            if (this.field_146289_q.func_78256_a(name) > 55) {
                name = this.field_146289_q.func_78269_a(stack.func_82833_r(), 50).trim() + "...";
            }
            this.field_146289_q.func_78276_b(name, startX + 186 + 22, startY + i * 19 + 6 + 6 + 95, Color.WHITE.getRGB());
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 95);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack);
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() - count);
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.field_146289_q, stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 95, null);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.func_191197_a((int)5, (Object)((Object)new MaterialItem(ItemStack.field_190927_a)));
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !((MaterialItem)materialItem).stack.func_190926_b()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, filteredMaterials.get(i));
        }
        return materials;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, 109, 0x404040);
    }

    public static class MaterialItem
    extends Gui {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private ItemStack stack = ItemStack.field_190927_a;

        private MaterialItem() {
        }

        private MaterialItem(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (!this.stack.func_190926_b()) {
                this.enabled = InventoryUtil.hasItemStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.stack);
            }
        }

        public boolean isEnabled() {
            return this.stack.func_190926_b() || this.enabled;
        }
    }
}

