/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityFluidTrailer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;

public class RenderFluidTrailer
extends AbstractRenderTrailer<EntityFluidTrailer> {
    @Override
    public void render(EntityFluidTrailer entity, float partialTicks) {
        this.renderDamagedPart(entity, SpecialModels.FLUID_TRAILER.getModel());
        this.renderWheel(entity, false, -0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks);
        this.renderWheel(entity, true, 0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks);
        double height = 9.9 * ((double)entity.getTank().getFluidAmount() / (double)entity.getTank().getCapacity()) * 0.0625;
        this.drawFluid(entity.getTank(), -0.3875, -0.1875, -0.99, 0.7625, height, 1.67);
    }

    private void drawFluid(FluidTank tank, double x, double y, double z, double width, double height, double depth) {
        if (tank.getFluid() == null) {
            return;
        }
        ResourceLocation resource = tank.getFluid().getFluid().getStill();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(resource.toString());
        if (sprite != null) {
            double minU = sprite.func_94209_e();
            double maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * width, (double)sprite.func_94212_f());
            double minV = sprite.func_94206_g();
            double maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * height, (double)sprite.func_94210_h());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179140_f();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x + width, y, z).func_187315_a(maxU, minV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(minU, minV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z).func_187315_a(minU, maxV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z).func_187315_a(maxU, maxV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x, y, z + depth).func_187315_a(maxU, minV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y, z + depth).func_187315_a(minU, minV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(minU, maxV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z + depth).func_187315_a(maxU, maxV).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * depth, (double)sprite.func_94212_f());
            maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * width, (double)sprite.func_94210_h());
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x, y + height, z).func_187315_a(maxU, minV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z + depth).func_187315_a(minU, minV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(minU, maxV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z).func_187315_a(maxU, maxV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

