/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVehicleTrailer
extends EntityTrailer
implements EntityRaytracer.IEntityRaytraceable {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(EntityVehicleTrailer.createScaledBoundingBox(-0.4375, 0.26875, 0.875, 0.4375, 0.53125, 1.5, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();

    public EntityVehicleTrailer(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 0.75f);
    }

    @Override
    public double func_70042_X() {
        return 0.5;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (passenger instanceof EntityVehicle) {
            Vec3d offset = ((EntityVehicle)passenger).getProperties().getTrailerOffset().func_178785_b((float)Math.toRadians(-this.field_70177_z));
            passenger.func_70107_b(this.field_70165_t + offset.field_72450_a, this.field_70163_u + this.func_70042_X() + offset.field_72448_b, this.field_70161_v + offset.field_72449_c);
            passenger.field_70126_B = this.field_70126_B;
            passenger.field_70177_z = this.field_70177_z;
        }
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return passenger instanceof EntityVehicle && this.func_184188_bt().size() == 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return Collections.singletonList(CONNECTION_BOX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        RenderGlobal.func_189697_a((AxisAlignedBB)CONNECTION_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (result.getPartHit() == CONNECTION_BOX && rightClick) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public double getHitchOffset() {
        return -25.0;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        }
    }
}

