/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.util.CommonUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageInteractKey
implements IMessage,
IMessageHandler<MessageInteractKey, IMessage> {
    private UUID targetEntity;

    public MessageInteractKey() {
    }

    public MessageInteractKey(Entity targetEntity) {
        this.targetEntity = targetEntity.func_110124_au();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetEntity.toString());
    }

    public void fromBytes(ByteBuf buf) {
        this.targetEntity = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public IMessage onMessage(MessageInteractKey message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            EntityPoweredVehicle poweredVehicle;
            Entity targetEntity;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null && (targetEntity = server.func_175576_a(message.targetEntity)) != null && targetEntity instanceof EntityPoweredVehicle && (poweredVehicle = (EntityPoweredVehicle)targetEntity).isKeyNeeded()) {
                ItemStack stack = player.func_184614_ca();
                if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.WRENCH) {
                    if (poweredVehicle.isOwner((EntityPlayer)player)) {
                        poweredVehicle.ejectKey();
                        poweredVehicle.setKeyNeeded(false);
                        CommonUtils.sendInfoMessage((EntityPlayer)player, "vehicle.status.key_removed");
                    } else {
                        CommonUtils.sendInfoMessage((EntityPlayer)player, "vehicle.status.invalid_owner");
                    }
                    return;
                }
                if (poweredVehicle.getKeyStack().func_190926_b()) {
                    if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.KEY) {
                        if (poweredVehicle.func_110124_au().equals(CommonUtils.getItemTagCompound(stack).func_186857_a("vehicleId"))) {
                            poweredVehicle.setKeyStack(stack.func_77946_l());
                            player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                        } else {
                            CommonUtils.sendInfoMessage((EntityPlayer)player, "vehicle.status.key_invalid");
                        }
                    }
                } else {
                    poweredVehicle.ejectKey();
                }
            }
        });
        return null;
    }
}

