/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.common.inventory.IAttachableChest;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.init.ModItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageOpenStorage
implements IMessage,
IMessageHandler<MessageOpenStorage, IMessage> {
    private int entityId;

    public MessageOpenStorage() {
    }

    public MessageOpenStorage(int entityId) {
        this.entityId = entityId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public IMessage onMessage(MessageOpenStorage message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            Entity targetEntity = world.func_73045_a(message.entityId);
            if (targetEntity instanceof IStorage && !player.func_70093_af()) {
                float reachDistance = (float)player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
                if (player.func_70032_d(targetEntity) < reachDistance) {
                    if (targetEntity instanceof IAttachableChest) {
                        IAttachableChest attachableChest = (IAttachableChest)targetEntity;
                        if (attachableChest.hasChest()) {
                            ItemStack stack = player.field_71071_by.func_70448_g();
                            if (stack.func_77973_b() == ModItems.WRENCH) {
                                ((IAttachableChest)targetEntity).removeChest();
                            } else {
                                attachableChest.getInventory().openGui(player, targetEntity);
                            }
                        }
                    } else {
                        ((IStorage)targetEntity).getInventory().openGui(player, targetEntity);
                    }
                }
            }
        });
        return null;
    }
}

