/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidUtils {
    private static final Map<Fluid, Integer> CACHE_FLUID_COLOR = new HashMap<Fluid, Integer>();

    @SideOnly(value=Side.CLIENT)
    public static void clearCacheFluidColor() {
        CACHE_FLUID_COLOR.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static int getAverageFluidColor(Fluid fluid) {
        int fluidColor = -1;
        Integer colorCashed = CACHE_FLUID_COLOR.get(fluid);
        if (colorCashed != null) {
            fluidColor = colorCashed;
        } else {
            ResourceLocation resource = fluid.getStill();
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(resource.toString());
            if (sprite != null) {
                int[][] frameTextureData;
                long aveRed = 0L;
                long aveGreen = 0L;
                long aveBlue = 0L;
                long pixelCount = 0L;
                for (int[] column : frameTextureData = sprite.func_147965_a(0)) {
                    pixelCount += (long)column.length;
                    for (int color : column) {
                        int red = color >> 16 & 0xFF;
                        int green = color >> 8 & 0xFF;
                        int blue = color & 0xFF;
                        aveRed += (long)(red * red);
                        aveGreen += (long)(green * green);
                        aveBlue += (long)(blue * blue);
                    }
                }
                fluidColor = ((int)Math.sqrt(aveRed / pixelCount) & 0xFF) << 16 | ((int)Math.sqrt(aveGreen / pixelCount) & 0xFF) << 8 | (int)Math.sqrt(aveBlue / pixelCount) & 0xFF;
            }
            CACHE_FLUID_COLOR.put(fluid, fluidColor);
        }
        return fluidColor;
    }

    public static int transferFluid(IFluidHandler source, IFluidHandler target, int maxAmount) {
        int filled;
        FluidStack drained = source.drain(maxAmount, false);
        if (drained != null && drained.amount > 0 && (filled = target.fill(drained, false)) > 0) {
            drained = source.drain(filled, true);
            return target.fill(drained, true);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluidTankInGUI(FluidStack fluid, double x, double y, double percent, int height) {
        if (fluid == null) {
            return;
        }
        ResourceLocation resource = fluid.getFluid().getStill();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(resource.toString());
        if (sprite != null) {
            double minU = sprite.func_94209_e();
            double maxU = sprite.func_94212_f();
            double minV = sprite.func_94206_g();
            double maxV = sprite.func_94210_h();
            double deltaV = maxV - minV;
            double tankLevel = percent * (double)height;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179147_l();
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int i = 0; i < count; ++i) {
                double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                double offsetY = (double)height - 16.0 * (double)i - subHeight;
                FluidUtils.drawQuad(x, y + offsetY, 16.0, subHeight, minU, maxV - deltaV * (subHeight / 16.0), maxU, maxV);
            }
            GlStateManager.func_179084_k();
        }
    }

    private static void drawQuad(double x, double y, double width, double height, double minU, double minV, double maxU, double maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + height, 0.0).func_187315_a(minU, maxV).func_181675_d();
        buffer.func_181662_b(x + width, y + height, 0.0).func_187315_a(maxU, maxV).func_181675_d();
        buffer.func_181662_b(x + width, y, 0.0).func_187315_a(maxU, minV).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void fixEmptyTag(NBTTagCompound tag) {
        if (tag.func_150297_b("FluidName", 8) && tag.func_150297_b("Amount", 3)) {
            tag.func_82580_o("Empty");
        }
    }
}

